/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.FastViewBar;
import org.eclipse.ui.internal.FastViewManager;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.internal.util.Descriptors;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.util.Util;

public class PerspectivesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench workbench;
    private PerspectiveRegistry perspectiveRegistry;
    private ArrayList perspectives;
    private String defaultPerspectiveId;
    private ArrayList perspToDelete = new ArrayList();
    private ArrayList perspToRevert = new ArrayList();
    private Table perspectivesTable;
    private Button revertButton;
    private Button deleteButton;
    private Button setDefaultButton;
    private Label openViewModeLabel;
    private Button openSameWindowButton;
    private Button openNewWindowButton;
    private int openPerspMode;
    private int openViewMode;
    private Button openEmbedButton;
    private Button openFastButton;
    private Button fvbHideButton;
    private boolean isFVBConfigured;
    private final String FVG_TITLE = WorkbenchMessages.FastViewsGroup_title;
    private final String OVM_TITLE = WorkbenchMessages.OpenViewMode_title;
    private final String OVM_EMBED = WorkbenchMessages.OpenViewMode_embed;
    private final String OVM_FAST = WorkbenchMessages.OpenViewMode_fast;
    private final String FVB_HIDE = WorkbenchMessages.FastViewBar_hide;
    private final String OPM_TITLE = WorkbenchMessages.OpenPerspectiveMode_optionsTitle;
    private final String OPM_SAME_WINDOW = WorkbenchMessages.OpenPerspectiveMode_sameWindow;
    private final String OPM_NEW_WINDOW = WorkbenchMessages.OpenPerspectiveMode_newWindow;
    private Comparator comparator = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object object, Object object2) {
            IPerspectiveDescriptor iPerspectiveDescriptor = (IPerspectiveDescriptor)object;
            IPerspectiveDescriptor iPerspectiveDescriptor2 = (IPerspectiveDescriptor)object2;
            return this.collator.compare(iPerspectiveDescriptor.getLabel(), iPerspectiveDescriptor2.getLabel());
        }
    };

    protected Control createContents(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.perspectives_preference_page_context");
        Composite composite2 = this.createComposite(composite);
        this.createOpenPerspButtonGroup(composite2);
        this.createOpenViewButtonGroup(composite2);
        this.createCustomizePerspective(composite2);
        return composite2;
    }

    protected Composite createComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        return composite2;
    }

    protected void createOpenPerspButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Group group = new Group(composite, 16384);
        group.setText(this.OPM_TITLE);
        group.setLayoutData((Object)new GridData(768));
        group.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        this.openSameWindowButton = new Button((Composite)group, 16);
        this.openSameWindowButton.setText(this.OPM_SAME_WINDOW);
        this.openSameWindowButton.setSelection(this.openPerspMode == 0);
        this.openSameWindowButton.setFont(font);
        this.openSameWindowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PerspectivesPreferencePage.this.openPerspMode = 0;
            }
        });
        this.openNewWindowButton = new Button((Composite)group, 16);
        this.openNewWindowButton.setText(this.OPM_NEW_WINDOW);
        this.openNewWindowButton.setSelection(2 == this.openPerspMode);
        this.openNewWindowButton.setFont(font);
        this.openNewWindowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PerspectivesPreferencePage.this.openPerspMode = 2;
            }
        });
    }

    protected void createOpenViewButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Group group = new Group(composite, 16384);
        group.setText(this.FVG_TITLE);
        group.setLayoutData((Object)new GridData(768));
        group.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        this.openViewModeLabel = new Label((Composite)group, 0);
        this.openViewModeLabel.setText(this.OVM_TITLE);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.openViewModeLabel.setLayoutData((Object)gridData);
        this.openViewModeLabel.setFont(font);
        this.openEmbedButton = new Button((Composite)group, 16);
        this.openEmbedButton.setText(this.OVM_EMBED);
        this.openEmbedButton.setSelection(this.openViewMode == 0);
        this.openEmbedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PerspectivesPreferencePage.this.openViewMode = 0;
            }
        });
        this.openEmbedButton.setFont(font);
        if (this.openViewMode == 2) {
            this.openViewMode = 1;
        }
        this.openFastButton = new Button((Composite)group, 16);
        this.openFastButton.setText(this.OVM_FAST);
        this.openFastButton.setSelection(this.openViewMode == 1);
        this.openFastButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PerspectivesPreferencePage.this.openViewMode = 1;
            }
        });
        this.openFastButton.setFont(font);
        this.createFVBHideButton((Composite)group);
    }

    protected void createFVBHideButton(Composite composite) {
        if (!this.isFVBConfigured) {
            return;
        }
        Font font = composite.getFont();
        this.fvbHideButton = new Button(composite, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fvbHideButton.setLayoutData((Object)gridData);
        this.fvbHideButton.setText(this.FVB_HIDE);
        this.fvbHideButton.setSelection(this.getPreferenceStore().getBoolean("FVB_HIDE"));
        this.fvbHideButton.setFont(font);
    }

    protected Composite createCustomizePerspective(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 16384);
        label.setText(WorkbenchMessages.PerspectivesPreference_available);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setFont(font);
        this.perspectivesTable = new Table(composite2, 2816);
        this.perspectivesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PerspectivesPreferencePage.this.updateButtons();
            }
        });
        this.perspectivesTable.setFont(font);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.perspectivesTable.setLayoutData((Object)gridData);
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = this.perspectiveRegistry.getPerspectives();
        this.perspectives = new ArrayList(iPerspectiveDescriptorArray.length);
        int n = 0;
        while (n < iPerspectiveDescriptorArray.length) {
            this.perspectives.add(n, iPerspectiveDescriptorArray[n]);
            ++n;
        }
        Collections.sort(this.perspectives, this.comparator);
        this.defaultPerspectiveId = this.perspectiveRegistry.getDefaultPerspective();
        this.updatePerspectivesTable();
        Composite composite3 = (Composite)this.createVerticalButtonBar(composite2);
        gridData = new GridData(1040);
        composite3.setLayoutData((Object)gridData);
        String string = WorkbenchMessages.Preference_note;
        String string2 = WorkbenchMessages.RevertPerspective_note;
        Composite composite4 = this.createNoteComposite(font, composite, string, string2);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        composite4.setLayoutData((Object)gridData2);
        return composite2;
    }

    protected Button createVerticalButton(Composite composite, String string, boolean bl) {
        Shell shell;
        Button button = new Button(composite, 8);
        button.setText(string);
        GridData gridData = this.setButtonLayoutData(button);
        gridData.horizontalAlignment = 4;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PerspectivesPreferencePage.this.verticalButtonPressed(selectionEvent.widget);
            }
        });
        button.setToolTipText(string);
        if (bl && (shell = composite.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        button.setFont(composite.getFont());
        return button;
    }

    protected Control createVerticalButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(composite.getFont());
        this.setDefaultButton = this.createVerticalButton(composite2, WorkbenchMessages.PerspectivesPreference_MakeDefault, false);
        this.setDefaultButton.setToolTipText(WorkbenchMessages.PerspectivesPreference_MakeDefaultTip);
        this.revertButton = this.createVerticalButton(composite2, WorkbenchMessages.PerspectivesPreference_Reset, false);
        this.revertButton.setToolTipText(WorkbenchMessages.PerspectivesPreference_ResetTip);
        this.deleteButton = this.createVerticalButton(composite2, WorkbenchMessages.PerspectivesPreference_Delete, false);
        this.deleteButton.setToolTipText(WorkbenchMessages.PerspectivesPreference_DeleteTip);
        this.updateButtons();
        return composite2;
    }

    @Override
    public void init(IWorkbench iWorkbench) {
        this.workbench = iWorkbench;
        this.perspectiveRegistry = (PerspectiveRegistry)this.workbench.getPerspectiveRegistry();
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(iPreferenceStore);
        this.openViewMode = iPreferenceStore.getInt("OPEN_VIEW_MODE");
        this.openPerspMode = iPreferenceStore.getInt("OPEN_PERSPECTIVE_MODE");
        this.isFVBConfigured = ((WorkbenchWindow)this.workbench.getActiveWorkbenchWindow()).getShowFastViewBars();
    }

    protected void performDefaults() {
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        this.openViewMode = iPreferenceStore.getDefaultInt("OPEN_VIEW_MODE");
        if (this.openViewMode == 2) {
            this.openViewMode = 1;
        }
        this.openEmbedButton.setSelection(this.openViewMode == 0);
        this.openFastButton.setSelection(this.openViewMode == 1);
        if (this.isFVBConfigured) {
            this.fvbHideButton.setSelection(iPreferenceStore.getDefaultBoolean("FVB_HIDE"));
        }
        this.openPerspMode = iPreferenceStore.getDefaultInt("OPEN_PERSPECTIVE_MODE");
        this.openSameWindowButton.setSelection(this.openPerspMode == 0);
        this.openNewWindowButton.setSelection(2 == this.openPerspMode);
        String string = this.perspectiveRegistry.getDefaultPerspective();
        int n = this.indexOf(string);
        if (n >= 0) {
            this.defaultPerspectiveId = string;
            this.updatePerspectivesTable();
            this.perspectivesTable.setSelection(n);
        }
        String string2 = PrefUtil.getAPIPreferenceStore().getDefaultString("defaultPerspectiveId");
        IPerspectiveDescriptor iPerspectiveDescriptor = null;
        if (string2 != null) {
            iPerspectiveDescriptor = this.workbench.getPerspectiveRegistry().findPerspectiveWithId(string2);
        }
        if (iPerspectiveDescriptor == null) {
            string2 = this.workbench.getPerspectiveRegistry().getDefaultPerspective();
        }
        this.defaultPerspectiveId = string2;
        this.updatePerspectivesTable();
    }

    private int indexOf(String string) {
        if (string == null) {
            return -1;
        }
        PerspectiveDescriptor[] perspectiveDescriptorArray = new PerspectiveDescriptor[this.perspectives.size()];
        this.perspectives.toArray(perspectiveDescriptorArray);
        int n = 0;
        while (n < perspectiveDescriptorArray.length) {
            PerspectiveDescriptor perspectiveDescriptor = perspectiveDescriptorArray[n];
            if (perspectiveDescriptor.getId().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private boolean findOpenInstance(IPerspectiveDescriptor iPerspectiveDescriptor) {
        IWorkbenchWindow[] iWorkbenchWindowArray = this.workbench.getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                WorkbenchPage workbenchPage = (WorkbenchPage)iWorkbenchPageArray[n2];
                if (workbenchPage.findPerspective(iPerspectiveDescriptor) != null && !MessageDialog.openQuestion((Shell)this.getShell(), (String)WorkbenchMessages.PerspectivesPreference_perspectiveopen_title, (String)NLS.bind((String)WorkbenchMessages.PerspectivesPreference_perspectiveopen_message, (Object)iPerspectiveDescriptor.getLabel()))) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public boolean performOk() {
        Object object;
        Object object2;
        IPreferenceStore iPreferenceStore;
        if (!Util.equals(this.defaultPerspectiveId, this.perspectiveRegistry.getDefaultPerspective())) {
            this.perspectiveRegistry.setDefaultPerspective(this.defaultPerspectiveId);
        }
        if (this.perspectives.size() < this.perspectiveRegistry.getPerspectives().length) {
            iPreferenceStore = this.workbench.getWorkbenchWindows();
            int n = 0;
            while (n < ((IPreferenceStore)iPreferenceStore).length) {
                object2 = iPreferenceStore[n].getPages();
                int n2 = 0;
                while (n2 < ((IWorkbenchPage[])object2).length) {
                    object = (WorkbenchPage)object2[n2];
                    int n3 = 0;
                    while (n3 < this.perspToDelete.size()) {
                        IPerspectiveDescriptor iPerspectiveDescriptor = (IPerspectiveDescriptor)this.perspToDelete.get(n3);
                        if (((WorkbenchPage)object).findPerspective(iPerspectiveDescriptor) != null) {
                            ((WorkbenchPage)object).closePerspective(iPerspectiveDescriptor, true, true);
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            this.perspectiveRegistry.deletePerspectives(this.perspToDelete);
        }
        this.perspectiveRegistry.revertPerspectives(this.perspToRevert);
        iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setValue("OPEN_VIEW_MODE", this.openViewMode);
        if (this.isFVBConfigured) {
            Perspective perspective;
            iPreferenceStore.setValue("FVB_HIDE", this.fvbHideButton.getSelection());
            IWorkbenchWindow iWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
            if (iWorkbenchWindow != null && (object2 = (WorkbenchPage)iWorkbenchWindow.getActivePage()) != null && (perspective = ((WorkbenchPage)object2).getActivePerspective()) != null && (object = perspective.getFastViewManager()) != null) {
                ((FastViewManager)object).updateTrim(FastViewBar.FASTVIEWBAR_ID);
            }
        }
        iPreferenceStore.setValue("OPEN_PERSPECTIVE_MODE", this.openPerspMode);
        PrefUtil.savePrefs();
        return true;
    }

    protected void updateButtons() {
        int n = this.perspectivesTable.getSelectionIndex();
        PerspectiveDescriptor perspectiveDescriptor = null;
        if (n > -1) {
            perspectiveDescriptor = (PerspectiveDescriptor)this.perspectives.get(n);
        }
        if (perspectiveDescriptor != null) {
            this.revertButton.setEnabled(perspectiveDescriptor.isPredefined() && perspectiveDescriptor.hasCustomDefinition() && !this.perspToRevert.contains(perspectiveDescriptor));
            this.deleteButton.setEnabled(!perspectiveDescriptor.isPredefined());
            this.setDefaultButton.setEnabled(true);
        } else {
            this.revertButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.setDefaultButton.setEnabled(false);
        }
    }

    protected void updatePerspectivesTable() {
        this.perspectivesTable.removeAll();
        int n = 0;
        while (n < this.perspectives.size()) {
            PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)this.perspectives.get(n);
            this.newPerspectivesTableItem(perspectiveDescriptor, n, false);
            ++n;
        }
    }

    protected TableItem newPerspectivesTableItem(IPerspectiveDescriptor iPerspectiveDescriptor, int n, boolean bl) {
        ImageDescriptor imageDescriptor = iPerspectiveDescriptor.getImageDescriptor();
        TableItem tableItem = new TableItem(this.perspectivesTable, 0, n);
        if (imageDescriptor != null) {
            Descriptors.setImage((Item)tableItem, imageDescriptor);
        }
        String string = iPerspectiveDescriptor.getLabel();
        if (iPerspectiveDescriptor.getId().equals(this.defaultPerspectiveId)) {
            string = NLS.bind((String)WorkbenchMessages.PerspectivesPreference_defaultLabel, (Object)string);
        }
        tableItem.setText(string);
        tableItem.setData((Object)iPerspectiveDescriptor);
        if (bl) {
            this.perspectivesTable.setSelection(n);
        }
        return tableItem;
    }

    protected void verticalButtonPressed(Widget widget) {
        int n = this.perspectivesTable.getSelectionIndex();
        PerspectiveDescriptor perspectiveDescriptor = null;
        if (n <= -1) {
            return;
        }
        perspectiveDescriptor = (PerspectiveDescriptor)this.perspectives.get(n);
        if (widget == this.revertButton) {
            if (perspectiveDescriptor.isPredefined() && !this.perspToRevert.contains(perspectiveDescriptor)) {
                this.perspToRevert.add(perspectiveDescriptor);
            }
        } else if (widget == this.deleteButton) {
            if (!(perspectiveDescriptor.isPredefined() || this.perspToDelete.contains(perspectiveDescriptor) || this.findOpenInstance(perspectiveDescriptor))) {
                this.perspToDelete.add(perspectiveDescriptor);
                this.perspToRevert.remove(perspectiveDescriptor);
                this.perspectives.remove(perspectiveDescriptor);
                this.updatePerspectivesTable();
            }
        } else if (widget == this.setDefaultButton) {
            this.defaultPerspectiveId = perspectiveDescriptor.getId();
            this.updatePerspectivesTable();
            this.perspectivesTable.setSelection(n);
        }
        this.updateButtons();
    }
}

