/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.NewWizard;
import org.eclipse.ui.internal.dialogs.NewWizardCollectionComparator;
import org.eclipse.ui.internal.dialogs.NewWizardSelectionPage;
import org.eclipse.ui.internal.dialogs.WizardActivityFilter;
import org.eclipse.ui.internal.dialogs.WizardContentProvider;
import org.eclipse.ui.internal.dialogs.WizardPatternFilter;
import org.eclipse.ui.internal.dialogs.WizardTagFilter;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardNode;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

class NewWizardNewPage
implements ISelectionChangedListener {
    private static final String DIALOG_SETTING_SECTION_NAME = "NewWizardSelectionPage.";
    private static final int SIZING_LISTS_HEIGHT = 200;
    private static final int SIZING_VIEWER_WIDTH = 300;
    private static final String STORE_EXPANDED_CATEGORIES_ID = "NewWizardSelectionPage.STORE_EXPANDED_CATEGORIES_ID";
    private static final String STORE_SELECTED_ID = "NewWizardSelectionPage.STORE_SELECTED_ID";
    private NewWizardSelectionPage page;
    private FilteredTree filteredTree;
    private WizardPatternFilter filteredTreeFilter;
    private Hashtable selectedWizards = new Hashtable();
    private IDialogSettings settings;
    private Button showAllCheck;
    private IWizardCategory wizardCategories;
    private IWizardDescriptor[] primaryWizards;
    private CLabel descImageCanvas;
    private Map imageTable = new HashMap();
    private IWizardDescriptor selectedElement;
    private WizardActivityFilter filter = new WizardActivityFilter();
    private boolean needShowAll;
    private boolean projectsOnly;
    private ViewerFilter projectFilter = new WizardTagFilter(new String[]{"project"});

    public NewWizardNewPage(NewWizardSelectionPage newWizardSelectionPage, IWizardCategory iWizardCategory, IWizardDescriptor[] iWizardDescriptorArray, boolean bl) {
        this.page = newWizardSelectionPage;
        this.wizardCategories = iWizardCategory;
        this.primaryWizards = iWizardDescriptorArray;
        this.projectsOnly = bl;
        this.trimPrimaryWizards();
        if (this.primaryWizards.length > 0) {
            if (this.allPrimary(iWizardCategory)) {
                this.wizardCategories = null;
                this.needShowAll = false;
            } else {
                this.needShowAll = !this.allActivityEnabled(iWizardCategory);
            }
        } else {
            this.needShowAll = !this.allActivityEnabled(iWizardCategory);
        }
        IWizard iWizard = newWizardSelectionPage.getWizard();
        if (iWizard instanceof NewWizard && "org.eclipse.ui.Examples".equals(((NewWizard)iWizard).getCategoryId())) {
            this.filter.setFilterPrimaryWizards(true);
        }
    }

    private boolean allActivityEnabled(IWizardCategory iWizardCategory) {
        IWizardDescriptor[] iWizardDescriptorArray = iWizardCategory.getWizards();
        int n = 0;
        while (n < iWizardDescriptorArray.length) {
            IWizardDescriptor iWizardDescriptor = iWizardDescriptorArray[n];
            if (WorkbenchActivityHelper.filterItem(iWizardDescriptor)) {
                return false;
            }
            ++n;
        }
        IWizardCategory[] iWizardCategoryArray = iWizardCategory.getCategories();
        int n2 = 0;
        while (n2 < iWizardCategoryArray.length) {
            if (!this.allActivityEnabled(iWizardCategoryArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void trimPrimaryWizards() {
        ArrayList<IWizardDescriptor> arrayList = new ArrayList<IWizardDescriptor>(this.primaryWizards.length);
        if (this.wizardCategories == null) {
            return;
        }
        int n = 0;
        while (n < this.primaryWizards.length) {
            if (this.wizardCategories.findWizard(this.primaryWizards[n].getId()) != null) {
                arrayList.add(this.primaryWizards[n]);
            }
            ++n;
        }
        this.primaryWizards = arrayList.toArray(new WorkbenchWizardElement[arrayList.size()]);
    }

    private boolean allPrimary(IWizardCategory iWizardCategory) {
        IWizardDescriptor[] iWizardDescriptorArray = iWizardCategory.getWizards();
        int n = 0;
        while (n < iWizardDescriptorArray.length) {
            IWizardDescriptor iWizardDescriptor = iWizardDescriptorArray[n];
            if (!this.isPrimary(iWizardDescriptor)) {
                return false;
            }
            ++n;
        }
        IWizardCategory[] iWizardCategoryArray = iWizardCategory.getCategories();
        int n2 = 0;
        while (n2 < iWizardCategoryArray.length) {
            if (!this.allPrimary(iWizardCategoryArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isPrimary(IWizardDescriptor iWizardDescriptor) {
        int n = 0;
        while (n < this.primaryWizards.length) {
            if (this.primaryWizards[n].equals(iWizardDescriptor)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void activate() {
        this.page.setDescription(WorkbenchMessages.NewWizardNewPage_description);
    }

    protected Control createControl(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        GridData gridData = new GridData(1, 4, false, true);
        composite2.setLayoutData((Object)gridData);
        label.setFont(font);
        label.setText(WorkbenchMessages.NewWizardNewPage_wizardsLabel);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setFont(font);
        gridData = new GridData(4, 4, true, true);
        composite3.setLayoutData((Object)gridData);
        this.filteredTree = this.createFilteredTree(composite3);
        this.createOptionsButtons(composite3);
        this.createImage(composite3);
        this.updateDescription(null);
        this.restoreWidgetValues();
        return composite2;
    }

    protected FilteredTree createFilteredTree(Composite composite) {
        IWizardCategory[] iWizardCategoryArray;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 300;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        boolean bl = DialogUtil.inRegularFontMode(composite);
        if (bl) {
            gridData.heightHint = 200;
        }
        composite2.setLayoutData((Object)gridData);
        this.filteredTreeFilter = new WizardPatternFilter();
        FilteredTree filteredTree = new FilteredTree(composite2, 2820, this.filteredTreeFilter, true);
        final TreeViewer treeViewer = filteredTree.getViewer();
        treeViewer.setContentProvider((IContentProvider)new WizardContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        treeViewer.setComparator((ViewerComparator)NewWizardCollectionComparator.INSTANCE);
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.primaryWizards.length) {
            arrayList.add(this.primaryWizards[n]);
            ++n;
        }
        n = 0;
        if (this.wizardCategories != null) {
            if (this.wizardCategories.getParent() == null) {
                iWizardCategoryArray = this.wizardCategories.getCategories();
                int n2 = 0;
                while (n2 < iWizardCategoryArray.length) {
                    arrayList.add(iWizardCategoryArray[n2]);
                    ++n2;
                }
            } else {
                n = 1;
                arrayList.add(this.wizardCategories);
            }
        }
        if (n != 0) {
            treeViewer.setAutoExpandLevel(2);
        }
        iWizardCategoryArray = new AdaptableList(arrayList);
        treeViewer.setInput((Object)iWizardCategoryArray);
        filteredTree.setBackground(composite.getDisplay().getSystemColor(22));
        treeViewer.getTree().setFont(composite.getFont());
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
                NewWizardNewPage.this.selectionChanged(new SelectionChangedEvent((ISelectionProvider)doubleClickEvent.getViewer(), (ISelection)iStructuredSelection));
                Object object = iStructuredSelection.getFirstElement();
                if (treeViewer.isExpandable(object)) {
                    treeViewer.setExpandedState(object, !treeViewer.getExpandedState(object));
                } else if (object instanceof WorkbenchWizardElement) {
                    NewWizardNewPage.this.page.advanceToNextPageOrFinish();
                }
            }
        });
        treeViewer.addFilter((ViewerFilter)this.filter);
        if (this.projectsOnly) {
            treeViewer.addFilter(this.projectFilter);
        }
        Dialog.applyDialogFont((Control)filteredTree);
        return filteredTree;
    }

    private void createOptionsButtons(Composite composite) {
        if (this.needShowAll) {
            this.showAllCheck = new Button(composite, 32);
            GridData gridData = new GridData();
            this.showAllCheck.setLayoutData((Object)gridData);
            this.showAllCheck.setFont(composite.getFont());
            this.showAllCheck.setText(WorkbenchMessages.NewWizardNewPage_showAll);
            this.showAllCheck.setSelection(false);
            this.showAllCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private Object[] delta = new Object[0];

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean bl = NewWizardNewPage.this.showAllCheck.getSelection();
                    if (bl) {
                        NewWizardNewPage.this.filteredTree.getViewer().getControl().setRedraw(false);
                    } else {
                        this.delta = NewWizardNewPage.this.filteredTree.getViewer().getExpandedElements();
                    }
                    try {
                        Object object;
                        Object[] objectArray;
                        if (bl) {
                            NewWizardNewPage.this.filteredTree.getViewer().resetFilters();
                            NewWizardNewPage.this.filteredTree.getViewer().addFilter((ViewerFilter)NewWizardNewPage.this.filteredTreeFilter);
                            if (NewWizardNewPage.this.projectsOnly) {
                                NewWizardNewPage.this.filteredTree.getViewer().addFilter(NewWizardNewPage.this.projectFilter);
                            }
                            objectArray = NewWizardNewPage.this.filteredTree.getViewer().getExpandedElements();
                            object = new Object[this.delta.length + objectArray.length];
                            System.arraycopy(objectArray, 0, object, 0, objectArray.length);
                            System.arraycopy(this.delta, 0, object, objectArray.length, this.delta.length);
                            NewWizardNewPage.this.filteredTree.getViewer().setExpandedElements((Object[])object);
                        } else {
                            NewWizardNewPage.this.filteredTree.getViewer().addFilter((ViewerFilter)NewWizardNewPage.this.filter);
                            if (NewWizardNewPage.this.projectsOnly) {
                                NewWizardNewPage.this.filteredTree.getViewer().addFilter(NewWizardNewPage.this.projectFilter);
                            }
                        }
                        NewWizardNewPage.this.filteredTree.getViewer().refresh(false);
                        if (!bl) {
                            objectArray = NewWizardNewPage.this.filteredTree.getViewer().getExpandedElements();
                            object = new ArrayList<Object>(Arrays.asList(this.delta));
                            object.removeAll(Arrays.asList(objectArray));
                        }
                    }
                    finally {
                        if (bl) {
                            NewWizardNewPage.this.filteredTree.getViewer().getControl().setRedraw(true);
                        }
                    }
                }
            });
        }
    }

    private void createImage(Composite composite) {
        this.descImageCanvas = new CLabel(composite, 0);
        GridData gridData = new GridData(34);
        gridData.widthHint = 0;
        gridData.heightHint = 0;
        this.descImageCanvas.setLayoutData((Object)gridData);
        this.descImageCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                Iterator iterator = NewWizardNewPage.this.imageTable.values().iterator();
                while (iterator.hasNext()) {
                    ((Image)iterator.next()).dispose();
                }
                NewWizardNewPage.this.imageTable.clear();
            }
        });
    }

    protected void expandPreviouslyExpandedCategories() {
        String[] stringArray = this.settings.getArray(STORE_EXPANDED_CATEGORIES_ID);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ArrayList<IWizardCategory> arrayList = new ArrayList<IWizardCategory>(stringArray.length);
        if (this.wizardCategories != null) {
            int n = 0;
            while (n < stringArray.length) {
                IWizardCategory iWizardCategory = this.wizardCategories.findCategory((IPath)new Path(stringArray[n]));
                if (iWizardCategory != null) {
                    arrayList.add(iWizardCategory);
                }
                ++n;
            }
        }
        if (!arrayList.isEmpty()) {
            this.filteredTree.getViewer().setExpandedElements(arrayList.toArray());
        }
    }

    protected Object getSingleSelection(IStructuredSelection iStructuredSelection) {
        return iStructuredSelection.size() == 1 ? iStructuredSelection.getFirstElement() : null;
    }

    protected void restoreWidgetValues() {
        this.expandPreviouslyExpandedCategories();
        this.selectPreviouslySelected();
    }

    public void saveWidgetValues() {
        this.storeExpandedCategories();
        this.storeSelectedCategoryAndWizard();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.page.setErrorMessage(null);
        this.page.setMessage(null);
        Object object = this.getSingleSelection((IStructuredSelection)selectionChangedEvent.getSelection());
        if (object instanceof IWizardDescriptor) {
            if (object == this.selectedElement) {
                return;
            }
            this.updateWizardSelection((IWizardDescriptor)object);
        } else {
            this.selectedElement = null;
            this.page.setHasPages(false);
            this.page.setCanFinishEarly(false);
            this.page.selectWizardNode(null);
            this.updateDescription(null);
        }
    }

    protected void selectPreviouslySelected() {
        String string = this.settings.get(STORE_SELECTED_ID);
        if (string == null) {
            return;
        }
        if (this.wizardCategories == null) {
            return;
        }
        Object object = this.wizardCategories.findCategory((IPath)new Path(string));
        if (object == null && (object = this.wizardCategories.findWizard(string)) == null) {
            return;
        }
        final StructuredSelection structuredSelection = new StructuredSelection(object);
        this.filteredTree.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                NewWizardNewPage.this.filteredTree.getViewer().setSelection((ISelection)structuredSelection, true);
            }
        });
    }

    public void setDialogSettings(IDialogSettings iDialogSettings) {
        this.settings = iDialogSettings;
    }

    protected void storeExpandedCategories() {
        Object[] objectArray = this.filteredTree.getViewer().getExpandedElements();
        ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IWizardCategory) {
                arrayList.add(((IWizardCategory)objectArray[n]).getPath().toString());
            }
            ++n;
        }
        this.settings.put(STORE_EXPANDED_CATEGORIES_ID, arrayList.toArray(new String[arrayList.size()]));
    }

    protected void storeSelectedCategoryAndWizard() {
        Object object = this.getSingleSelection((IStructuredSelection)this.filteredTree.getViewer().getSelection());
        if (object != null) {
            if (object instanceof IWizardCategory) {
                this.settings.put(STORE_SELECTED_ID, ((IWizardCategory)object).getPath().toString());
            } else {
                this.settings.put(STORE_SELECTED_ID, ((IWizardDescriptor)object).getId());
            }
        }
    }

    private void updateDescription(IWizardDescriptor iWizardDescriptor) {
        GridData gridData;
        String string = "";
        if (iWizardDescriptor != null) {
            string = iWizardDescriptor.getDescription();
        }
        this.page.setDescription(string);
        if (this.hasImage(iWizardDescriptor)) {
            gridData = null;
            if (iWizardDescriptor != null) {
                gridData = iWizardDescriptor.getDescriptionImage();
            }
            if (gridData != null) {
                GridData gridData2 = (GridData)this.descImageCanvas.getLayoutData();
                gridData2.widthHint = -1;
                gridData2.heightHint = -1;
                Image image = (Image)this.imageTable.get(gridData);
                if (image == null) {
                    image = gridData.createImage(false);
                    this.imageTable.put(gridData, image);
                }
                this.descImageCanvas.setImage(image);
            }
        } else {
            gridData = (GridData)this.descImageCanvas.getLayoutData();
            gridData.widthHint = 0;
            gridData.heightHint = 0;
            this.descImageCanvas.setImage(null);
        }
        this.descImageCanvas.getParent().layout(true);
        this.filteredTree.getViewer().getTree().showSelection();
        gridData = this.page.getWizard().getContainer();
        if (gridData instanceof IWizardContainer2) {
            ((IWizardContainer2)gridData).updateSize();
        }
    }

    private boolean hasImage(IWizardDescriptor iWizardDescriptor) {
        if (iWizardDescriptor == null) {
            return false;
        }
        return iWizardDescriptor.getDescriptionImage() != null;
    }

    private void updateWizardSelection(IWizardDescriptor iWizardDescriptor) {
        WorkbenchWizardNode workbenchWizardNode;
        this.selectedElement = iWizardDescriptor;
        if (this.selectedWizards.containsKey(iWizardDescriptor)) {
            workbenchWizardNode = (WorkbenchWizardNode)this.selectedWizards.get(iWizardDescriptor);
        } else {
            workbenchWizardNode = new WorkbenchWizardNode(this.page, iWizardDescriptor){

                @Override
                public IWorkbenchWizard createWizard() throws CoreException {
                    return this.wizardElement.createWizard();
                }
            };
            this.selectedWizards.put(iWizardDescriptor, workbenchWizardNode);
        }
        this.page.setCanFinishEarly(iWizardDescriptor.canFinishEarly());
        this.page.setHasPages(iWizardDescriptor.hasPages());
        this.page.selectWizardNode(workbenchWizardNode);
        this.updateDescription(iWizardDescriptor);
    }
}

