/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.StringTokenizer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.NewWizardSelectionPage;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class NewWizard
extends Wizard {
    private static final String CATEGORY_SEPARATOR = "/";
    private String categoryId = null;
    private NewWizardSelectionPage mainPage;
    private boolean projectsOnly = false;
    private IStructuredSelection selection;
    private IWorkbench workbench;

    public void addPages() {
        IWizardCategory iWizardCategory = WorkbenchPlugin.getDefault().getNewWizardRegistry().getRootCategory();
        IWizardDescriptor[] iWizardDescriptorArray = WorkbenchPlugin.getDefault().getNewWizardRegistry().getPrimaryWizards();
        if (this.categoryId != null) {
            IWizardCategory iWizardCategory2 = iWizardCategory;
            StringTokenizer stringTokenizer = new StringTokenizer(this.categoryId, CATEGORY_SEPARATOR);
            while (stringTokenizer.hasMoreElements()) {
                if ((iWizardCategory2 = this.getChildWithID(iWizardCategory2, stringTokenizer.nextToken())) == null) break;
            }
            if (iWizardCategory2 != null) {
                iWizardCategory = iWizardCategory2;
            }
        }
        this.mainPage = new NewWizardSelectionPage(this.workbench, this.selection, iWizardCategory, iWizardDescriptorArray, this.projectsOnly);
        this.addPage((IWizardPage)this.mainPage);
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    private IWizardCategory getChildWithID(IWizardCategory iWizardCategory, String string) {
        IWizardCategory[] iWizardCategoryArray = iWizardCategory.getCategories();
        int n = 0;
        while (n < iWizardCategoryArray.length) {
            IWizardCategory iWizardCategory2 = iWizardCategoryArray[n];
            if (iWizardCategory2.getId().equals(string)) {
                return iWizardCategory2;
            }
            ++n;
        }
        return null;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
        if (this.getWindowTitle() == null) {
            if (this.projectsOnly) {
                this.setWindowTitle(WorkbenchMessages.NewProject_title);
            } else {
                this.setWindowTitle(WorkbenchMessages.NewWizard_title);
            }
        }
        this.setDefaultPageImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_WIZBAN_NEW_WIZ"));
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.mainPage.saveWidgetValues();
        if (this.getContainer().getCurrentPage() == this.mainPage && this.mainPage.canFinishEarly()) {
            IWizard iWizard = this.mainPage.getSelectedNode().getWizard();
            iWizard.setContainer(this.getContainer());
            return iWizard.performFinish();
        }
        return true;
    }

    public void setCategoryId(String string) {
        this.categoryId = string;
    }

    public void setProjectsOnly(boolean bl) {
        this.projectsOnly = bl;
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.mainPage && this.mainPage.canFinishEarly()) {
            return true;
        }
        return super.canFinish();
    }
}

