/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ImportExportPage;
import org.eclipse.ui.wizards.IWizardCategory;

public class ImportPage
extends ImportExportPage {
    private static final String STORE_SELECTED_IMPORT_WIZARD_ID = "ImportExportPage.STORE_SELECTED_IMPORT_WIZARD_ID";
    private static final String STORE_EXPANDED_IMPORT_CATEGORIES = "ImportExportPage.STORE_EXPANDED_IMPORT_CATEGORIES";
    protected ImportExportPage.CategorizedWizardSelectionTree importTree;

    public ImportPage(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super(iWorkbench, iStructuredSelection);
    }

    @Override
    protected void initialize() {
        this.workbench.getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.import_wizard_selection_wizard_page_context");
    }

    @Override
    protected Composite createTreeViewer(Composite composite) {
        IWizardCategory iWizardCategory = WorkbenchPlugin.getDefault().getImportWizardRegistry().getRootCategory();
        this.importTree = new ImportExportPage.CategorizedWizardSelectionTree(iWizardCategory, WorkbenchMessages.ImportWizard_selectSource);
        Composite composite2 = this.importTree.createControl(composite);
        this.importTree.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ImportPage.this.listSelectionChanged(selectionChangedEvent.getSelection());
            }
        });
        this.importTree.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ImportPage.this.treeDoubleClicked(doubleClickEvent);
            }
        });
        this.setTreeViewer(this.importTree.getViewer());
        return composite2;
    }

    @Override
    public void saveWidgetValues() {
        this.storeExpandedCategories(STORE_EXPANDED_IMPORT_CATEGORIES, this.importTree.getViewer());
        this.storeSelectedCategoryAndWizard(STORE_SELECTED_IMPORT_WIZARD_ID, this.importTree.getViewer());
        super.saveWidgetValues();
    }

    @Override
    protected void restoreWidgetValues() {
        IWizardCategory iWizardCategory = WorkbenchPlugin.getDefault().getImportWizardRegistry().getRootCategory();
        this.expandPreviouslyExpandedCategories(STORE_EXPANDED_IMPORT_CATEGORIES, iWizardCategory, this.importTree.getViewer());
        this.selectPreviouslySelected(STORE_SELECTED_IMPORT_WIZARD_ID, iWizardCategory, this.importTree.getViewer());
        super.restoreWidgetValues();
    }

    @Override
    protected ITriggerPoint getTriggerPoint() {
        return this.getWorkbench().getActivitySupport().getTriggerPointManager().getTriggerPoint("org.eclipse.ui.importWizards");
    }

    @Override
    protected void updateMessage() {
        this.setMessage(WorkbenchMessages.ImportExportPage_chooseImportSource);
        super.updateMessage();
    }
}

