/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.DataTransferWizardCollectionComparator;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.WizardActivityFilter;
import org.eclipse.ui.internal.dialogs.WizardContentProvider;
import org.eclipse.ui.internal.dialogs.WizardPatternFilter;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardNode;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardSelectionPage;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public abstract class ImportExportPage
extends WorkbenchWizardSelectionPage {
    protected static final String DIALOG_SETTING_SECTION_NAME = "ImportExportPage.";
    private TreeViewer treeViewer;

    protected ImportExportPage(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super("importExportPage", iWorkbench, iStructuredSelection, null, null);
        this.setTitle(WorkbenchMessages.Select);
    }

    public void createControl(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(font);
        Composite composite3 = this.createTreeViewer(composite2);
        Dialog.applyDialogFont((Control)composite3);
        this.restoreWidgetValues();
        this.setControl((Control)composite2);
        this.initialize();
    }

    protected abstract Composite createTreeViewer(Composite var1);

    protected void treeDoubleClicked(DoubleClickEvent doubleClickEvent) {
        ISelection iSelection = doubleClickEvent.getViewer().getSelection();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        this.listSelectionChanged((ISelection)iStructuredSelection);
        Object object = iStructuredSelection.getFirstElement();
        TreeViewer treeViewer = (TreeViewer)doubleClickEvent.getViewer();
        if (treeViewer.isExpandable(object)) {
            treeViewer.setExpandedState(object, !treeViewer.getExpandedState(object));
        } else if (object instanceof WorkbenchWizardElement && this.canFlipToNextPage()) {
            this.getContainer().showPage(this.getNextPage());
            return;
        }
        this.getContainer().showPage(this.getNextPage());
    }

    private void updateSelectedNode(WorkbenchWizardElement workbenchWizardElement) {
        this.setErrorMessage(null);
        if (workbenchWizardElement == null) {
            this.updateMessage();
            this.setSelectedNode(null);
            return;
        }
        this.setSelectedNode(this.createWizardNode(workbenchWizardElement));
        this.setMessage(workbenchWizardElement.getDescription());
    }

    protected void updateMessage() {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null) {
            ISelection iSelection = treeViewer.getSelection();
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof WorkbenchWizardElement) {
                this.updateSelectedNode((WorkbenchWizardElement)object);
            } else {
                this.setSelectedNode(null);
            }
        } else {
            this.setMessage(null);
        }
    }

    protected void listSelectionChanged(ISelection iSelection) {
        this.setErrorMessage(null);
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof WorkbenchWizardElement) {
            WorkbenchWizardElement workbenchWizardElement = (WorkbenchWizardElement)object;
            this.updateSelectedNode(workbenchWizardElement);
        } else {
            this.updateSelectedNode(null);
        }
    }

    private IWizardNode createWizardNode(IWizardDescriptor iWizardDescriptor) {
        return new WorkbenchWizardNode(this, iWizardDescriptor){

            @Override
            public IWorkbenchWizard createWizard() throws CoreException {
                return this.wizardElement.createWizard();
            }
        };
    }

    protected void restoreWidgetValues() {
        this.updateMessage();
    }

    protected void expandPreviouslyExpandedCategories(String string, IWizardCategory iWizardCategory, TreeViewer treeViewer) {
        String[] stringArray = this.getDialogSettings().getArray(string);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ArrayList<IWizardCategory> arrayList = new ArrayList<IWizardCategory>(stringArray.length);
        if (iWizardCategory != null) {
            int n = 0;
            while (n < stringArray.length) {
                IWizardCategory iWizardCategory2 = iWizardCategory.findCategory((IPath)new Path(stringArray[n]));
                if (iWizardCategory2 != null) {
                    arrayList.add(iWizardCategory2);
                }
                ++n;
            }
        }
        if (!arrayList.isEmpty()) {
            treeViewer.setExpandedElements(arrayList.toArray());
        }
    }

    protected void selectPreviouslySelected(String string, IWizardCategory iWizardCategory, TreeViewer treeViewer) {
        String string2 = this.getDialogSettings().get(string);
        if (string2 == null) {
            return;
        }
        if (iWizardCategory == null) {
            return;
        }
        Object object = iWizardCategory.findCategory((IPath)new Path(string2));
        if (object == null && (object = iWizardCategory.findWizard(string2)) == null) {
            return;
        }
        treeViewer.setSelection((ISelection)new StructuredSelection(object), true);
    }

    protected void storeExpandedCategories(String string, TreeViewer treeViewer) {
        Object[] objectArray = treeViewer.getExpandedElements();
        ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IWizardCategory) {
                arrayList.add(((IWizardCategory)objectArray[n]).getPath().toString());
            }
            ++n;
        }
        this.getDialogSettings().put(string, arrayList.toArray(new String[arrayList.size()]));
    }

    protected void storeSelectedCategoryAndWizard(String string, TreeViewer treeViewer) {
        Object object = ((IStructuredSelection)treeViewer.getSelection()).getFirstElement();
        if (object != null) {
            if (object instanceof IWizardCategory) {
                this.getDialogSettings().put(string, ((IWizardCategory)object).getPath().toString());
            } else {
                this.getDialogSettings().put(string, ((IWizardDescriptor)object).getId());
            }
        }
    }

    public void saveWidgetValues() {
    }

    @Override
    public IWizardPage getNextPage() {
        ITriggerPoint iTriggerPoint = this.getTriggerPoint();
        if (iTriggerPoint == null || WorkbenchActivityHelper.allowUseOf(iTriggerPoint, this.getSelectedNode())) {
            return super.getNextPage();
        }
        return null;
    }

    protected ITriggerPoint getTriggerPoint() {
        return null;
    }

    protected void setTreeViewer(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void initialize() {
    }

    protected class CategorizedWizardSelectionTree {
        private static final int SIZING_LISTS_HEIGHT = 200;
        private IWizardCategory wizardCategories;
        private String message;
        private TreeViewer viewer;

        protected CategorizedWizardSelectionTree(IWizardCategory iWizardCategory, String string) {
            this.wizardCategories = iWizardCategory;
            this.message = string;
        }

        protected Composite createControl(Composite composite) {
            Font font = composite.getFont();
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new GridLayout());
            composite2.setLayoutData((Object)new GridData(1808));
            composite2.setFont(font);
            Label label = new Label(composite2, 0);
            if (this.message != null) {
                label.setText(this.message);
            }
            label.setFont(font);
            this.createFilteredTree(composite2);
            this.layoutTopControl(this.viewer.getControl());
            return composite2;
        }

        private void createFilteredTree(Composite composite) {
            IWizardCategory[] iWizardCategoryArray;
            FilteredTree filteredTree = new FilteredTree(composite, 2820, new WizardPatternFilter(), true);
            this.viewer = filteredTree.getViewer();
            filteredTree.setFont(composite.getFont());
            this.viewer.setContentProvider((IContentProvider)new WizardContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.viewer.setComparator((ViewerComparator)DataTransferWizardCollectionComparator.INSTANCE);
            ArrayList<IWizardCategory> arrayList = new ArrayList<IWizardCategory>();
            boolean bl = false;
            if (this.wizardCategories != null) {
                if (this.wizardCategories.getParent() == null) {
                    iWizardCategoryArray = this.wizardCategories.getCategories();
                    int n = 0;
                    while (n < iWizardCategoryArray.length) {
                        arrayList.add(iWizardCategoryArray[n]);
                        ++n;
                    }
                } else {
                    bl = true;
                    arrayList.add(this.wizardCategories);
                }
            }
            if (bl) {
                this.viewer.setAutoExpandLevel(2);
            }
            iWizardCategoryArray = new AdaptableList(arrayList);
            this.viewer.addFilter((ViewerFilter)new WizardActivityFilter());
            this.viewer.setInput((Object)iWizardCategoryArray);
        }

        protected TreeViewer getViewer() {
            return this.viewer;
        }

        private void layoutTopControl(Control control) {
            GridData gridData = new GridData(1808);
            int n = DialogUtil.availableRows(control.getParent());
            gridData.heightHint = n > 50 ? 200 : n * 3;
            control.setLayoutData((Object)gridData);
        }
    }
}

