/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceContentProvider;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceLabelProvider;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.CapabilityFilter;
import org.eclipse.ui.internal.dialogs.PreferenceBoldLabelProvider;
import org.eclipse.ui.internal.dialogs.PreferenceHistoryEntry;
import org.eclipse.ui.internal.dialogs.PreferenceNodeFilter;
import org.eclipse.ui.internal.dialogs.PreferencePageHistory;
import org.eclipse.ui.internal.dialogs.PreferencePatternFilter;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.model.IContributionService;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public abstract class FilteredPreferenceDialog
extends PreferenceDialog
implements IWorkbenchPreferenceContainer {
    private static final int PAGE_MULTIPLIER = 9;
    private static final int INCREMENT = 10;
    protected PreferenceFilteredTree filteredTree;
    private Object pageData;
    IWorkingCopyManager workingCopyManager;
    private Collection updateJobs = new ArrayList();
    PreferencePageHistory history = new PreferencePageHistory(this);
    private Sash sash;
    private IHandlerActivation showViewHandler;
    private boolean locked;
    private boolean keyScrollingEnabled = false;
    private Listener keyScrollingFilter = null;

    public FilteredPreferenceDialog(Shell shell, PreferenceManager preferenceManager) {
        super(shell, preferenceManager);
    }

    protected IPreferenceNode findNodeMatching(String string) {
        IPreferenceNode iPreferenceNode = super.findNodeMatching(string);
        if (WorkbenchActivityHelper.filterItem(iPreferenceNode)) {
            return null;
        }
        return iPreferenceNode;
    }

    protected TreeViewer createTreeViewer(Composite composite) {
        TreeViewer treeViewer;
        int n = 4;
        if (!this.hasAtMostOnePage()) {
            this.filteredTree = new PreferenceFilteredTree(composite, n, new PreferencePatternFilter());
            GridData gridData = new GridData(4, 4, true, true);
            gridData.horizontalIndent = 7;
            this.filteredTree.setBackground(composite.getDisplay().getSystemColor(25));
            treeViewer = this.filteredTree.getViewer();
        } else {
            treeViewer = new TreeViewer(composite, n);
        }
        this.setContentAndLabelProviders(treeViewer);
        treeViewer.setInput((Object)this.getPreferenceManager());
        treeViewer.addFilter((ViewerFilter)new CapabilityFilter());
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                FilteredPreferenceDialog.this.handleTreeSelectionChanged(selectionChangedEvent);
            }
        });
        super.addListeners(treeViewer);
        return treeViewer;
    }

    private boolean hasAtMostOnePage() {
        PreferenceContentProvider preferenceContentProvider = new PreferenceContentProvider();
        try {
            Object[] objectArray = preferenceContentProvider.getElements((Object)this.getPreferenceManager());
            boolean bl = objectArray.length == 0 || objectArray.length == 1 && !preferenceContentProvider.hasChildren(objectArray[0]);
            return bl;
        }
        finally {
            preferenceContentProvider.dispose();
        }
    }

    protected void setContentAndLabelProviders(TreeViewer treeViewer) {
        if (this.hasAtMostOnePage()) {
            treeViewer.setLabelProvider((IBaseLabelProvider)new PreferenceLabelProvider());
        } else {
            treeViewer.setLabelProvider((IBaseLabelProvider)new PreferenceBoldLabelProvider(this.filteredTree));
        }
        IContributionService iContributionService = (IContributionService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IContributionService.class);
        treeViewer.setComparator((ViewerComparator)iContributionService.getComparatorFor(this.getContributionType()));
        treeViewer.setContentProvider((IContentProvider)new PreferenceContentProvider());
    }

    protected String getContributionType() {
        return "preference";
    }

    protected void handleTreeSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
    }

    protected Control createTreeAreaContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(composite.getDisplay().getSystemColor(25));
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 7;
        gridLayout.marginWidth = 7;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        TreeViewer treeViewer = this.createTreeViewer(composite2);
        this.setTreeViewer(treeViewer);
        this.updateTreeFont(JFaceResources.getDialogFont());
        GridData gridData = new GridData(1808);
        treeViewer.getControl().getParent().setLayoutData((Object)gridData);
        this.layoutTreeAreaControl((Control)composite2);
        return composite2;
    }

    public void showOnly(String[] stringArray) {
        if (!this.hasAtMostOnePage()) {
            this.filteredTree.addFilter(new PreferenceNodeFilter(stringArray));
        }
    }

    public void setPageData(Object object) {
        this.pageData = object;
    }

    protected void createPage(IPreferenceNode iPreferenceNode) {
        super.createPage(iPreferenceNode);
        if (this.pageData == null) {
            return;
        }
        IPreferencePage iPreferencePage = iPreferenceNode.getPage();
        if (iPreferencePage instanceof PreferencePage) {
            ((PreferencePage)iPreferencePage).applyData(this.pageData);
        }
    }

    public IPreferencePage getCurrentPage() {
        return super.getCurrentPage();
    }

    @Override
    public boolean openPage(String string, Object object) {
        this.setPageData(object);
        this.setCurrentPageId(string);
        IPreferencePage iPreferencePage = this.getCurrentPage();
        if (iPreferencePage instanceof PreferencePage) {
            ((PreferencePage)iPreferencePage).applyData(object);
        }
        return true;
    }

    public final void setCurrentPageId(String string) {
        IPreferenceNode iPreferenceNode = this.findNodeMatching(string);
        if (iPreferenceNode != null) {
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)iPreferenceNode));
            this.showPage(iPreferenceNode);
        }
    }

    @Override
    public IWorkingCopyManager getWorkingCopyManager() {
        if (this.workingCopyManager == null) {
            this.workingCopyManager = new WorkingCopyManager();
        }
        return this.workingCopyManager;
    }

    protected void okPressed() {
        super.okPressed();
        if (this.getReturnCode() == 2) {
            return;
        }
        if (this.workingCopyManager != null) {
            try {
                this.workingCopyManager.applyChanges();
            }
            catch (BackingStoreException backingStoreException) {
                String string = backingStoreException.getMessage();
                if (string == null) {
                    string = WorkbenchMessages.FilteredPreferenceDialog_PreferenceSaveFailed;
                }
                StatusUtil.handleStatus(String.valueOf(WorkbenchMessages.PreferencesExportDialog_ErrorDialogTitle) + ": " + string, backingStoreException, 2, this.getShell());
            }
        }
        Iterator iterator = this.updateJobs.iterator();
        while (iterator.hasNext()) {
            ((Job)iterator.next()).schedule();
        }
    }

    @Override
    public void registerUpdateJob(Job job) {
        this.updateJobs.add(job);
    }

    Control getContainerToolBar(Composite composite) {
        final ToolBarManager toolBarManager = new ToolBarManager(0x800100);
        toolBarManager.createControl(composite);
        this.history.createHistoryControls(toolBarManager.getControl(), toolBarManager);
        Action action = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return WorkbenchImages.getImageDescriptor("IMG_LCL_VIEW_MENU");
            }

            public void run() {
                MenuManager menuManager = new MenuManager();
                menuManager.add((IAction)new Action(){

                    public void run() {
                        FilteredPreferenceDialog.this.sash.addFocusListener((FocusListener)new FocusAdapter(){

                            public void focusGained(FocusEvent focusEvent) {
                                FilteredPreferenceDialog.this.sash.setBackground(FilteredPreferenceDialog.this.sash.getDisplay().getSystemColor(26));
                            }

                            public void focusLost(FocusEvent focusEvent) {
                                FilteredPreferenceDialog.this.sash.setBackground(FilteredPreferenceDialog.this.sash.getDisplay().getSystemColor(25));
                            }
                        });
                        FilteredPreferenceDialog.this.sash.setFocus();
                    }

                    public String getText() {
                        return WorkbenchMessages.FilteredPreferenceDialog_Resize;
                    }
                });
                menuManager.add((IAction)new Action(){

                    public void run() {
                        FilteredPreferenceDialog.this.activeKeyScrolling();
                    }

                    public String getText() {
                        return WorkbenchMessages.FilteredPreferenceDialog_Key_Scrolling;
                    }
                });
                Menu menu = menuManager.createContextMenu((Control)FilteredPreferenceDialog.this.getShell());
                Rectangle rectangle = toolBarManager.getControl().getBounds();
                Point point = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                point = toolBarManager.getControl().toDisplay(point);
                menu.setLocation(point.x, point.y);
                menu.setVisible(true);
            }
        };
        action.setToolTipText(WorkbenchMessages.FilteredPreferenceDialog_FilterToolTip);
        toolBarManager.add((IAction)action);
        IHandlerService iHandlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        this.showViewHandler = iHandlerService.activateHandler("org.eclipse.ui.window.showViewMenu", (IHandler)new ActionHandler((IAction)action), new ActiveShellExpression(this.getShell()));
        toolBarManager.update(false);
        return toolBarManager.getControl();
    }

    void activeKeyScrolling() {
        if (this.keyScrollingFilter == null) {
            Composite composite = this.getPageContainer().getParent();
            if (!(composite instanceof ScrolledComposite)) {
                return;
            }
            final ScrolledComposite scrolledComposite = (ScrolledComposite)composite;
            this.keyScrollingFilter = new Listener(){

                public void handleEvent(Event event) {
                    if (!FilteredPreferenceDialog.this.keyScrollingEnabled || scrolledComposite.isDisposed()) {
                        return;
                    }
                    switch (event.keyCode) {
                        case 0x1000002: {
                            scrolledComposite.setOrigin(scrolledComposite.getOrigin().x, scrolledComposite.getOrigin().y + 10);
                            break;
                        }
                        case 0x1000001: {
                            scrolledComposite.setOrigin(scrolledComposite.getOrigin().x, scrolledComposite.getOrigin().y - 10);
                            break;
                        }
                        case 0x1000003: {
                            scrolledComposite.setOrigin(scrolledComposite.getOrigin().x - 10, scrolledComposite.getOrigin().y);
                            break;
                        }
                        case 0x1000004: {
                            scrolledComposite.setOrigin(scrolledComposite.getOrigin().x + 10, scrolledComposite.getOrigin().y);
                            break;
                        }
                        case 0x1000006: {
                            scrolledComposite.setOrigin(scrolledComposite.getOrigin().x, scrolledComposite.getOrigin().y + 90);
                            break;
                        }
                        case 0x1000005: {
                            scrolledComposite.setOrigin(scrolledComposite.getOrigin().x, scrolledComposite.getOrigin().y - 90);
                            break;
                        }
                        case 0x1000007: {
                            scrolledComposite.setOrigin(0, 0);
                            break;
                        }
                        case 0x1000008: {
                            scrolledComposite.setOrigin(0, scrolledComposite.getSize().y);
                            break;
                        }
                        default: {
                            FilteredPreferenceDialog.this.keyScrollingEnabled = false;
                        }
                    }
                    event.type = 0;
                    event.doit = false;
                }
            };
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.addFilter(1, this.keyScrollingFilter);
            display.addFilter(31, this.keyScrollingFilter);
            scrolledComposite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    FilteredPreferenceDialog.this.removeKeyScrolling();
                }
            });
        }
        this.keyScrollingEnabled = true;
    }

    void removeKeyScrolling() {
        if (this.keyScrollingFilter != null) {
            this.keyScrollingEnabled = false;
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display != null) {
                display.removeFilter(1, this.keyScrollingFilter);
                display.removeFilter(31, this.keyScrollingFilter);
            }
            this.keyScrollingFilter = null;
        }
    }

    protected boolean showPage(IPreferenceNode iPreferenceNode) {
        boolean bl = super.showPage(iPreferenceNode);
        if (bl) {
            this.history.addHistoryEntry(new PreferenceHistoryEntry(iPreferenceNode.getId(), iPreferenceNode.getLabelText(), null));
        }
        return bl;
    }

    public boolean close() {
        if (this.showViewHandler != null) {
            IHandlerService iHandlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            iHandlerService.deactivateHandler(this.showViewHandler);
            this.showViewHandler.getHandler().dispose();
            this.showViewHandler = null;
        }
        this.removeKeyScrolling();
        this.history.dispose();
        return super.close();
    }

    protected Composite createTitleArea(Composite composite) {
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 7;
        composite.setLayout((Layout)gridLayout);
        Composite composite2 = super.createTitleArea(composite);
        Composite composite3 = new Composite(composite, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.verticalSpacing = 0;
        composite3.setLayout((Layout)gridLayout2);
        composite3.setLayoutData((Object)new GridData(0x1000008, 4, false, true));
        Control control = this.getContainerToolBar(composite3);
        control.setLayoutData((Object)new GridData(0x1000008, 4, false, true));
        return composite2;
    }

    protected void selectSavedItem() {
        Text text;
        this.getTreeViewer().setInput((Object)this.getPreferenceManager());
        super.selectSavedItem();
        if (this.getTreeViewer().getTree().getItemCount() > 1 && (text = this.filteredTree.getFilterControl()) != null) {
            text.setFocus();
        }
    }

    protected void updateTreeFont(Font font) {
        if (this.hasAtMostOnePage()) {
            Tree tree = this.getTreeViewer().getTree();
            this.applyDialogFont((Control)tree, font);
            tree.layout(true);
        } else {
            this.applyDialogFont((Control)this.filteredTree, font);
            this.filteredTree.layout(true);
        }
    }

    private void applyDialogFont(Control control, Font font) {
        control.setFont(font);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = 0;
            while (n < controlArray.length) {
                this.applyDialogFont(controlArray[n], font);
                ++n;
            }
        }
    }

    protected Sash createSash(Composite composite, Control control) {
        this.sash = super.createSash(composite, control);
        return this.sash;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    protected class PreferenceFilteredTree
    extends FilteredTree {
        private ViewerFilter viewerFilter;
        private String cachedTitle;

        PreferenceFilteredTree(Composite composite, int n, PatternFilter patternFilter) {
            super(composite, n, patternFilter, true);
        }

        protected void addFilter(ViewerFilter viewerFilter) {
            this.viewerFilter = viewerFilter;
            this.getViewer().addFilter(viewerFilter);
            if (this.filterText != null) {
                this.setFilterText(WorkbenchMessages.FilteredTree_FilterMessage);
                this.textChanged();
            }
            this.cachedTitle = this.getShell().getText();
            this.getShell().setText(NLS.bind((String)WorkbenchMessages.FilteredTree_FilteredDialogTitle, (Object)this.cachedTitle));
        }

        @Override
        protected void updateToolbar(boolean bl) {
            super.updateToolbar(this.viewerFilter != null || bl);
        }

        @Override
        protected void clearText() {
            this.setFilterText("");
            if (!FilteredPreferenceDialog.this.locked && this.viewerFilter != null) {
                this.getViewer().removeFilter(this.viewerFilter);
                this.viewerFilter = null;
                this.getShell().setText(this.cachedTitle);
            }
            this.textChanged();
        }
    }
}

