/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class FileExtensionDialog
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS_SECTION = "FileExtensionDialogSettings";
    private String filename = "";
    private String initialValue;
    private Text filenameField;
    private Button okButton;
    private String title;
    private String helpContextId;
    private final String headerTitle;
    private final String message2;
    private final String label;

    public FileExtensionDialog(Shell shell) {
        this(shell, WorkbenchMessages.FileExtension_shellTitle, "org.eclipse.ui.file_extension_dialog_context", WorkbenchMessages.FileExtension_dialogTitle, WorkbenchMessages.FileExtension_fileTypeMessage, WorkbenchMessages.FileExtension_fileTypeLabel);
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    public FileExtensionDialog(Shell shell, String string, String string2, String string3, String string4, String string5) {
        super(shell);
        this.title = string;
        this.helpContextId = string2;
        this.headerTitle = string3;
        this.message2 = string4;
        this.label = string5;
        this.setShellStyle(this.getShellStyle() | 0x10000000);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, this.helpContextId);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle(this.headerTitle);
        this.setMessage(this.message2);
        new Label(composite3, 16384).setText(this.label);
        this.filenameField = new Text(composite3, 2052);
        if (this.initialValue != null) {
            this.filenameField.setText(this.initialValue);
        }
        this.filenameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (modifyEvent.widget == FileExtensionDialog.this.filenameField) {
                    FileExtensionDialog.this.filename = FileExtensionDialog.this.filenameField.getText().trim();
                    FileExtensionDialog.this.okButton.setEnabled(FileExtensionDialog.this.validateFileType());
                }
            }
        });
        this.filenameField.setFocus();
        Dialog.applyDialogFont((Control)composite2);
        Point point = LayoutConstants.getMargins();
        GridLayoutFactory.fillDefaults().numColumns(2).margins(point.x, point.y).generateLayout(composite3);
        return composite3;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private boolean validateFileType() {
        if (this.filename.length() == 0) {
            this.setErrorMessage(null);
            return false;
        }
        int n = this.filename.lastIndexOf(46);
        if (n == this.filename.length() - 1 && (n == 0 || n == 1 && this.filename.charAt(0) == '*')) {
            this.setErrorMessage(WorkbenchMessages.FileExtension_extensionEmptyMessage);
            return false;
        }
        n = this.filename.indexOf(42);
        if (n > -1) {
            if (this.filename.length() == 1) {
                this.setErrorMessage(WorkbenchMessages.FileExtension_extensionEmptyMessage);
                return false;
            }
            if (n != 0 || this.filename.charAt(1) != '.') {
                this.setErrorMessage(WorkbenchMessages.FileExtension_fileNameInvalidMessage);
                return false;
            }
            if (this.filename.length() > n && this.filename.indexOf(42, n + 1) != -1) {
                this.setErrorMessage(WorkbenchMessages.FileExtension_fileNameInvalidMessage);
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public String getExtension() {
        int n = this.filename.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        if (n == this.filename.length()) {
            return "";
        }
        return this.filename.substring(n + 1, this.filename.length());
    }

    public String getName() {
        int n = this.filename.lastIndexOf(46);
        if (n == -1) {
            return this.filename;
        }
        if (n == 0) {
            return "*";
        }
        return this.filename.substring(0, n);
    }

    public void setInitialValue(String string) {
        this.initialValue = string;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings iDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_SETTINGS_SECTION);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return iDialogSettings2;
    }

    protected boolean isResizable() {
        return true;
    }
}

