/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.EditorSelectionDialog;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.FileExtensionDialog;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class FileEditorsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private static final String DATA_EDITOR = "editor";
    private static final String DATA_FROM_CONTENT_TYPE = "type";
    protected Table resourceTypeTable;
    protected Button addResourceTypeButton;
    protected Button removeResourceTypeButton;
    protected Table editorTable;
    protected Button addEditorButton;
    protected Button removeEditorButton;
    protected Button defaultEditorButton;
    protected Label editorLabel;
    protected IWorkbench workbench;
    protected List imagesToDispose;
    protected Map editorsToImages;

    public void addResourceType(String string, String string2) {
        IFileEditorMapping iFileEditorMapping;
        Assert.isTrue((string != null && string.length() != 0 || string2 != null && string2.length() != 0 ? 1 : 0) != 0);
        int n = string.indexOf(42);
        if (n > -1) {
            Assert.isTrue((n == 0 && string.length() == 1 ? 1 : 0) != 0);
            Assert.isTrue((string2 != null && string2.length() != 0 ? 1 : 0) != 0);
        }
        String string3 = (String.valueOf(string) + (string2 == null || string2.length() == 0 ? "" : "." + string2)).toUpperCase();
        TableItem[] tableItemArray = this.resourceTypeTable.getItems();
        boolean bl = false;
        int n2 = 0;
        while (n2 < tableItemArray.length && !bl) {
            iFileEditorMapping = (IFileEditorMapping)tableItemArray[n2].getData();
            int n3 = string3.compareToIgnoreCase(iFileEditorMapping.getLabel());
            if (n3 == 0) {
                MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)WorkbenchMessages.FileEditorPreference_existsTitle, (String)WorkbenchMessages.FileEditorPreference_existsMessage);
                return;
            }
            if (n3 < 0) {
                bl = true;
                continue;
            }
            ++n2;
        }
        iFileEditorMapping = new FileEditorMapping(string, string2);
        TableItem tableItem = this.newResourceTableItem(iFileEditorMapping, n2, true);
        this.resourceTypeTable.setFocus();
        this.resourceTypeTable.showItem(tableItem);
        this.fillEditorTable();
    }

    protected Control createContents(Composite composite) {
        this.imagesToDispose = new ArrayList();
        this.editorsToImages = new HashMap(50);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        PreferenceLinkArea preferenceLinkArea = new PreferenceLinkArea(composite2, 0, "org.eclipse.ui.preferencePages.ContentTypes", WorkbenchMessages.FileEditorPreference_contentTypesRelatedLink, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        gridData = new GridData(768);
        preferenceLinkArea.getControl().setLayoutData((Object)gridData);
        Label label = new Label(composite2, 16384);
        label.setText(WorkbenchMessages.FileEditorPreference_fileTypes);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.resourceTypeTable = new Table(composite2, 67586);
        this.resourceTypeTable.addListener(13, (Listener)this);
        this.resourceTypeTable.addListener(14, (Listener)this);
        gridData = new GridData(768);
        int n = DialogUtil.availableRows(composite2);
        gridData.heightHint = this.resourceTypeTable.getItemHeight() * (n / 8);
        this.resourceTypeTable.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        composite3.setLayout((Layout)gridLayout2);
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite3.setLayoutData((Object)gridData);
        this.addResourceTypeButton = new Button(composite3, 8);
        this.addResourceTypeButton.setText(WorkbenchMessages.FileEditorPreference_add);
        this.addResourceTypeButton.addListener(13, (Listener)this);
        this.setButtonLayoutData(this.addResourceTypeButton);
        this.removeResourceTypeButton = new Button(composite3, 8);
        this.removeResourceTypeButton.setText(WorkbenchMessages.FileEditorPreference_remove);
        this.removeResourceTypeButton.addListener(13, (Listener)this);
        this.setButtonLayoutData(this.removeResourceTypeButton);
        label = new Label(composite2, 16384);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.editorLabel = new Label(composite2, 16384);
        this.editorLabel.setText(WorkbenchMessages.FileEditorPreference_associatedEditors);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.editorLabel.setLayoutData((Object)gridData);
        this.editorTable = new Table(composite2, 2050);
        this.editorTable.addListener(13, (Listener)this);
        this.editorTable.addListener(14, (Listener)this);
        gridData = new GridData(1808);
        gridData.heightHint = this.editorTable.getItemHeight() * 7;
        this.editorTable.setLayoutData((Object)gridData);
        composite3 = new Composite(composite2, 0);
        gridLayout2 = new GridLayout();
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        composite3.setLayout((Layout)gridLayout2);
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite3.setLayoutData((Object)gridData);
        this.addEditorButton = new Button(composite3, 8);
        this.addEditorButton.setText(WorkbenchMessages.FileEditorPreference_addEditor);
        this.addEditorButton.addListener(13, (Listener)this);
        this.addEditorButton.setLayoutData((Object)gridData);
        this.setButtonLayoutData(this.addEditorButton);
        this.removeEditorButton = new Button(composite3, 8);
        this.removeEditorButton.setText(WorkbenchMessages.FileEditorPreference_removeEditor);
        this.removeEditorButton.addListener(13, (Listener)this);
        this.setButtonLayoutData(this.removeEditorButton);
        this.defaultEditorButton = new Button(composite3, 8);
        this.defaultEditorButton.setText(WorkbenchMessages.FileEditorPreference_default);
        this.defaultEditorButton.addListener(13, (Listener)this);
        this.setButtonLayoutData(this.defaultEditorButton);
        this.fillResourceTypeTable();
        if (this.resourceTypeTable.getItemCount() > 0) {
            this.resourceTypeTable.setSelection(0);
        }
        this.fillEditorTable();
        this.updateEnabledState();
        this.workbench.getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.file_editors_preference_page_context");
        this.applyDialogFont(composite2);
        return composite2;
    }

    public void dispose() {
        Iterator<Object> iterator;
        super.dispose();
        if (this.imagesToDispose != null) {
            iterator = this.imagesToDispose.iterator();
            while (iterator.hasNext()) {
                ((Image)iterator.next()).dispose();
            }
            this.imagesToDispose = null;
        }
        if (this.editorsToImages != null) {
            iterator = this.editorsToImages.values().iterator();
            while (iterator.hasNext()) {
                ((Image)iterator.next()).dispose();
            }
            this.editorsToImages = null;
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    protected void fillEditorTable() {
        this.editorTable.removeAll();
        FileEditorMapping fileEditorMapping = this.getSelectedResourceType();
        if (fileEditorMapping != null) {
            IContentType[] iContentTypeArray;
            IEditorDescriptor[] iEditorDescriptorArray = fileEditorMapping.getEditors();
            int n = 0;
            while (n < iEditorDescriptorArray.length) {
                iContentTypeArray = iEditorDescriptorArray[n];
                TableItem tableItem = new TableItem(this.editorTable, 0);
                tableItem.setData(DATA_EDITOR, (Object)iContentTypeArray);
                String string = null;
                if (fileEditorMapping != null && fileEditorMapping.getDefaultEditor() == iContentTypeArray && fileEditorMapping.isDeclaredDefaultEditor((IEditorDescriptor)iContentTypeArray)) {
                    string = WorkbenchMessages.FileEditorPreference_defaultLabel;
                }
                if (string != null) {
                    tableItem.setText(String.valueOf(iContentTypeArray.getLabel()) + " " + string);
                } else {
                    tableItem.setText(iContentTypeArray.getLabel());
                }
                tableItem.setImage(this.getImage((IEditorDescriptor)iContentTypeArray));
                ++n;
            }
            EditorRegistry editorRegistry = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
            iContentTypeArray = Platform.getContentTypeManager().findContentTypesFor(fileEditorMapping.getLabel());
            int n2 = 0;
            while (n2 < iContentTypeArray.length) {
                iEditorDescriptorArray = editorRegistry.getEditorsForContentType(iContentTypeArray[n2]);
                int n3 = 0;
                while (n3 < iEditorDescriptorArray.length) {
                    IEditorDescriptor iEditorDescriptor = iEditorDescriptorArray[n3];
                    TableItem[] tableItemArray = this.editorTable.getItems();
                    TableItem tableItem = null;
                    int n4 = 0;
                    while (n4 < tableItemArray.length) {
                        if (tableItemArray[n4].getData(DATA_EDITOR).equals(iEditorDescriptor)) {
                            tableItem = tableItemArray[n4];
                            break;
                        }
                        ++n4;
                    }
                    if (tableItem == null) {
                        TableItem tableItem2 = new TableItem(this.editorTable, 0);
                        tableItem2.setData(DATA_EDITOR, (Object)iEditorDescriptor);
                        tableItem2.setData(DATA_FROM_CONTENT_TYPE, (Object)iContentTypeArray[n2]);
                        this.setLockedItemText(tableItem2, iEditorDescriptor.getLabel());
                        tableItem2.setImage(this.getImage(iEditorDescriptor));
                    } else {
                        tableItem.setData(DATA_FROM_CONTENT_TYPE, (Object)iContentTypeArray[n2]);
                        this.setLockedItemText(tableItem, tableItem.getText());
                    }
                    ++n3;
                }
                ++n2;
            }
        }
    }

    private void setLockedItemText(TableItem tableItem, String string) {
        tableItem.setText(NLS.bind((String)WorkbenchMessages.FileEditorPreference_isLocked, (Object)string, (Object)((IContentType)tableItem.getData(DATA_FROM_CONTENT_TYPE)).getName()));
    }

    protected void fillResourceTypeTable() {
        IFileEditorMapping[] iFileEditorMappingArray = WorkbenchPlugin.getDefault().getEditorRegistry().getFileEditorMappings();
        int n = 0;
        while (n < iFileEditorMappingArray.length) {
            FileEditorMapping fileEditorMapping = (FileEditorMapping)iFileEditorMappingArray[n];
            fileEditorMapping = (FileEditorMapping)fileEditorMapping.clone();
            this.newResourceTableItem(fileEditorMapping, n, false);
            ++n;
        }
    }

    protected Image getImage(IEditorDescriptor iEditorDescriptor) {
        Image image = (Image)this.editorsToImages.get(iEditorDescriptor);
        if (image == null) {
            image = iEditorDescriptor.getImageDescriptor().createImage();
            this.editorsToImages.put(iEditorDescriptor, image);
        }
        return image;
    }

    protected FileEditorMapping getSelectedResourceType() {
        TableItem[] tableItemArray = this.resourceTypeTable.getSelection();
        if (tableItemArray.length == 1) {
            return (FileEditorMapping)tableItemArray[0].getData();
        }
        return null;
    }

    protected IEditorDescriptor[] getAssociatedEditors() {
        if (this.getSelectedResourceType() == null) {
            return null;
        }
        if (this.editorTable.getItemCount() > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < this.editorTable.getItemCount()) {
                arrayList.add(this.editorTable.getItem(n).getData(DATA_EDITOR));
                ++n;
            }
            return arrayList.toArray(new IEditorDescriptor[arrayList.size()]);
        }
        return null;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.addResourceTypeButton) {
            this.promptForResourceType();
        } else if (event.widget == this.removeResourceTypeButton) {
            this.removeSelectedResourceType();
        } else if (event.widget == this.addEditorButton) {
            this.promptForEditor();
        } else if (event.widget == this.removeEditorButton) {
            this.removeSelectedEditor();
        } else if (event.widget == this.defaultEditorButton) {
            this.setSelectedEditorAsDefault();
        } else if (event.widget == this.resourceTypeTable) {
            this.fillEditorTable();
        }
        this.updateEnabledState();
    }

    @Override
    public void init(IWorkbench iWorkbench) {
        this.workbench = iWorkbench;
        this.noDefaultAndApplyButton();
    }

    protected TableItem newResourceTableItem(IFileEditorMapping iFileEditorMapping, int n, boolean bl) {
        Image image = iFileEditorMapping.getImageDescriptor().createImage(false);
        if (image != null) {
            this.imagesToDispose.add(image);
        }
        TableItem tableItem = new TableItem(this.resourceTypeTable, 0, n);
        if (image != null) {
            tableItem.setImage(image);
        }
        tableItem.setText(iFileEditorMapping.getLabel());
        tableItem.setData((Object)iFileEditorMapping);
        if (bl) {
            this.resourceTypeTable.setSelection(n);
        }
        return tableItem;
    }

    public boolean performOk() {
        TableItem[] tableItemArray = this.resourceTypeTable.getItems();
        FileEditorMapping[] fileEditorMappingArray = new FileEditorMapping[tableItemArray.length];
        int n = 0;
        while (n < tableItemArray.length) {
            fileEditorMappingArray[n] = (FileEditorMapping)tableItemArray[n].getData();
            ++n;
        }
        EditorRegistry editorRegistry = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
        editorRegistry.setFileEditorMappings(fileEditorMappingArray);
        editorRegistry.saveAssociations();
        PrefUtil.savePrefs();
        return true;
    }

    public void promptForEditor() {
        EditorDescriptor editorDescriptor;
        EditorSelectionDialog editorSelectionDialog = new EditorSelectionDialog(this.getControl().getShell());
        editorSelectionDialog.setEditorsToFilter(this.getAssociatedEditors());
        editorSelectionDialog.setMessage(NLS.bind((String)WorkbenchMessages.Choose_the_editor_for_file, (Object)this.getSelectedResourceType().getLabel()));
        if (editorSelectionDialog.open() == 0 && (editorDescriptor = (EditorDescriptor)editorSelectionDialog.getSelectedEditor()) != null) {
            int n = this.editorTable.getItemCount();
            boolean bl = n < 1;
            TableItem tableItem = new TableItem(this.editorTable, 0, n);
            tableItem.setData(DATA_EDITOR, (Object)editorDescriptor);
            if (bl) {
                tableItem.setText(String.valueOf(editorDescriptor.getLabel()) + " " + WorkbenchMessages.FileEditorPreference_defaultLabel);
            } else {
                tableItem.setText(editorDescriptor.getLabel());
            }
            tableItem.setImage(this.getImage(editorDescriptor));
            this.editorTable.setSelection(n);
            this.editorTable.setFocus();
            this.getSelectedResourceType().addEditor(editorDescriptor);
            if (bl) {
                this.getSelectedResourceType().setDefaultEditor(editorDescriptor);
            }
            this.updateSelectedResourceType();
        }
    }

    public void promptForResourceType() {
        FileExtensionDialog fileExtensionDialog = new FileExtensionDialog(this.getControl().getShell(), WorkbenchMessages.FileExtension_shellTitle, "org.eclipse.ui.file_extension_dialog_context", WorkbenchMessages.FileExtension_dialogTitle, WorkbenchMessages.FileExtension_fileTypeMessage, WorkbenchMessages.FileExtension_fileTypeLabel);
        if (fileExtensionDialog.open() == 0) {
            String string = fileExtensionDialog.getName();
            String string2 = fileExtensionDialog.getExtension();
            this.addResourceType(string, string2);
        }
    }

    public void removeSelectedEditor() {
        boolean bl;
        TableItem[] tableItemArray = this.editorTable.getSelection();
        boolean bl2 = bl = this.editorTable.getSelectionIndex() == 0;
        if (tableItemArray.length > 0) {
            int n = 0;
            while (n < tableItemArray.length) {
                this.getSelectedResourceType().removeEditor((EditorDescriptor)tableItemArray[n].getData(DATA_EDITOR));
                tableItemArray[n].dispose();
                ++n;
            }
        }
        if (bl && this.editorTable.getItemCount() > 0) {
            TableItem tableItem = this.editorTable.getItem(0);
            this.getSelectedResourceType().setDefaultEditor((EditorDescriptor)tableItem.getData(DATA_EDITOR));
            tableItem.setText(String.valueOf(((EditorDescriptor)tableItem.getData(DATA_EDITOR)).getLabel()) + " " + WorkbenchMessages.FileEditorPreference_defaultLabel);
            if (!this.isEditorRemovable(tableItem)) {
                this.setLockedItemText(tableItem, tableItem.getText());
            }
        }
    }

    public void removeSelectedResourceType() {
        TableItem[] tableItemArray = this.resourceTypeTable.getSelection();
        int n = 0;
        while (n < tableItemArray.length) {
            tableItemArray[n].dispose();
            ++n;
        }
        this.editorTable.removeAll();
    }

    public void setSelectedEditorAsDefault() {
        TableItem[] tableItemArray = this.editorTable.getSelection();
        if (tableItemArray.length > 0) {
            TableItem tableItem = this.editorTable.getItem(0);
            tableItem.setText(((EditorDescriptor)tableItem.getData(DATA_EDITOR)).getLabel());
            if (!this.isEditorRemovable(tableItem)) {
                this.setLockedItemText(tableItem, tableItem.getText());
            }
            EditorDescriptor editorDescriptor = (EditorDescriptor)tableItemArray[0].getData(DATA_EDITOR);
            this.getSelectedResourceType().setDefaultEditor(editorDescriptor);
            IContentType iContentType = (IContentType)tableItemArray[0].getData(DATA_FROM_CONTENT_TYPE);
            tableItemArray[0].dispose();
            TableItem tableItem2 = new TableItem(this.editorTable, 0, 0);
            tableItem2.setData(DATA_EDITOR, (Object)editorDescriptor);
            if (iContentType != null) {
                tableItem2.setData(DATA_FROM_CONTENT_TYPE, (Object)iContentType);
            }
            tableItem2.setText(String.valueOf(editorDescriptor.getLabel()) + " " + WorkbenchMessages.FileEditorPreference_defaultLabel);
            tableItem2.setImage(this.getImage(editorDescriptor));
            if (!this.isEditorRemovable(tableItem2)) {
                this.setLockedItemText(tableItem2, tableItem2.getText());
            }
            this.editorTable.setSelection(new TableItem[]{tableItem2});
        }
    }

    public void updateEnabledState() {
        int n = this.resourceTypeTable.getSelectionCount();
        int n2 = this.editorTable.getSelectionCount();
        this.removeResourceTypeButton.setEnabled(n != 0);
        this.editorLabel.setEnabled(n == 1);
        this.addEditorButton.setEnabled(n == 1);
        this.removeEditorButton.setEnabled(this.areEditorsRemovable());
        this.defaultEditorButton.setEnabled(n2 == 1);
    }

    private boolean areEditorsRemovable() {
        TableItem[] tableItemArray = this.editorTable.getSelection();
        if (tableItemArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < tableItemArray.length) {
            if (!this.isEditorRemovable(tableItemArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean isEditorRemovable(TableItem tableItem) {
        IContentType iContentType = (IContentType)tableItem.getData(DATA_FROM_CONTENT_TYPE);
        return iContentType == null;
    }

    public void updateSelectedResourceType() {
    }
}

