/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.ExceptionHandler;

public class EventLoopProgressMonitor
extends ProgressMonitorWrapper
implements IProgressMonitorWithBlocking {
    private static int T_THRESH = 100;
    private static int T_MAX = 50;
    private long lastTime = System.currentTimeMillis();
    private String taskName;

    public EventLoopProgressMonitor(IProgressMonitor iProgressMonitor) {
        super(iProgressMonitor);
    }

    public void beginTask(String string, int n) {
        super.beginTask(string, n);
        this.taskName = string;
        this.runEventLoop();
    }

    public void clearBlocked() {
        Dialog.getBlockedHandler().clearBlocked();
    }

    public void done() {
        super.done();
        this.taskName = null;
        this.runEventLoop();
    }

    public void internalWorked(double d) {
        super.internalWorked(d);
        this.runEventLoop();
    }

    public boolean isCanceled() {
        this.runEventLoop();
        return super.isCanceled();
    }

    private void runEventLoop() {
        long l = System.currentTimeMillis();
        if (l - this.lastTime < (long)T_THRESH) {
            return;
        }
        this.lastTime = l;
        Display display = Display.getDefault();
        if (display == null) {
            return;
        }
        ExceptionHandler exceptionHandler = ExceptionHandler.getInstance();
        do {
            try {
                if (display.readAndDispatch()) continue;
            }
            catch (Throwable throwable) {
                exceptionHandler.handleException(throwable);
            }
            break;
        } while (System.currentTimeMillis() - l <= (long)T_MAX);
    }

    public void setBlocked(IStatus iStatus) {
        Dialog.getBlockedHandler().showBlocked((IProgressMonitor)this, iStatus, this.taskName);
    }

    public void setCanceled(boolean bl) {
        super.setCanceled(bl);
        this.taskName = null;
        this.runEventLoop();
    }

    public void setTaskName(String string) {
        super.setTaskName(string);
        this.taskName = string;
        this.runEventLoop();
    }

    public void subTask(String string) {
        if (this.taskName == null) {
            this.taskName = string;
        }
        super.subTask(string);
        this.runEventLoop();
    }

    public void worked(int n) {
        super.worked(n);
        this.runEventLoop();
    }

    protected String getTaskName() {
        return this.taskName;
    }
}

