/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecoratorDefinition;
import org.eclipse.ui.internal.decorators.DecoratorManager;

public class DecoratorsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text descriptionText;
    private CheckboxTableViewer checkboxViewer;

    protected Control createContents(Composite composite) {
        Font font = composite.getFont();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.decorators_preference_page_context");
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setFont(font);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(WorkbenchMessages.DecoratorsPreferencePage_explanation);
        label.setFont(font);
        this.createDecoratorsArea(composite2);
        this.createDescriptionArea(composite2);
        this.populateDecorators();
        return composite2;
    }

    private void createDecoratorsArea(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(font);
        Label label = new Label(composite2, 0);
        label.setText(WorkbenchMessages.DecoratorsPreferencePage_decoratorsLabel);
        label.setFont(font);
        this.checkboxViewer = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2180);
        this.checkboxViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.checkboxViewer.getTable().setFont(composite2.getFont());
        this.checkboxViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ((DecoratorDefinition)object).getName();
            }
        });
        this.checkboxViewer.getTable().setFont(font);
        this.checkboxViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private final Comparator comparer = new Comparator(){
                private Collator collator = Collator.getInstance();

                public int compare(Object object, Object object2) {
                    String string = ((DecoratorDefinition)object).getName();
                    String string2 = ((DecoratorDefinition)object2).getName();
                    return this.collator.compare(string, string2);
                }
            };

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = new Object[objectArray.length];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                Collections.sort(Arrays.asList(objectArray2), this.comparer);
                return objectArray2;
            }
        });
        this.checkboxViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (selectionChangedEvent.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                    DecoratorDefinition decoratorDefinition = (DecoratorDefinition)iStructuredSelection.getFirstElement();
                    if (decoratorDefinition == null) {
                        DecoratorsPreferencePage.this.clearDescription();
                    } else {
                        DecoratorsPreferencePage.this.showDescription(decoratorDefinition);
                    }
                }
            }
        });
        this.checkboxViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                DecoratorsPreferencePage.this.checkboxViewer.setSelection((ISelection)new StructuredSelection(checkStateChangedEvent.getElement()));
            }
        });
    }

    private void createDescriptionArea(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(font);
        Label label = new Label(composite2, 0);
        label.setText(WorkbenchMessages.DecoratorsPreferencePage_description);
        label.setFont(font);
        this.descriptionText = new Text(composite2, 2378);
        this.descriptionText.setLayoutData((Object)new GridData(1808));
        this.descriptionText.setFont(font);
    }

    private void populateDecorators() {
        DecoratorDefinition[] decoratorDefinitionArray = this.getAllDefinitions();
        this.checkboxViewer.setInput((Object)decoratorDefinitionArray);
        int n = 0;
        while (n < decoratorDefinitionArray.length) {
            this.checkboxViewer.setChecked((Object)decoratorDefinitionArray[n], decoratorDefinitionArray[n].isEnabled());
            ++n;
        }
    }

    private void showDescription(DecoratorDefinition decoratorDefinition) {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        String string = decoratorDefinition.getDescription();
        if (string == null || string.length() == 0) {
            this.descriptionText.setText(WorkbenchMessages.PreferencePage_noDescription);
        } else {
            this.descriptionText.setText(string);
        }
    }

    private void clearDescription() {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        this.descriptionText.setText("");
    }

    protected void performDefaults() {
        super.performDefaults();
        DecoratorManager decoratorManager = WorkbenchPlugin.getDefault().getDecoratorManager();
        DecoratorDefinition[] decoratorDefinitionArray = decoratorManager.getAllDecoratorDefinitions();
        int n = 0;
        while (n < decoratorDefinitionArray.length) {
            this.checkboxViewer.setChecked((Object)decoratorDefinitionArray[n], decoratorDefinitionArray[n].getDefaultValue());
            ++n;
        }
    }

    public boolean performOk() {
        if (super.performOk()) {
            DecoratorManager decoratorManager = this.getDecoratorManager();
            decoratorManager.clearCaches();
            DecoratorDefinition[] decoratorDefinitionArray = decoratorManager.getAllDecoratorDefinitions();
            int n = 0;
            while (n < decoratorDefinitionArray.length) {
                boolean bl = this.checkboxViewer.getChecked((Object)decoratorDefinitionArray[n]);
                decoratorDefinitionArray[n].setEnabled(bl);
                ++n;
            }
            decoratorManager.clearCaches();
            decoratorManager.updateForEnablementChange();
            return true;
        }
        return false;
    }

    @Override
    public void init(IWorkbench iWorkbench) {
    }

    private DecoratorDefinition[] getAllDefinitions() {
        return this.getDecoratorManager().getAllDecoratorDefinitions();
    }

    private DecoratorManager getDecoratorManager() {
        return WorkbenchPlugin.getDefault().getDecoratorManager();
    }
}

