/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.internal.provisional.action.ToolBarContributionItem2;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.OpenPerspectiveAction;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.ActionSetActionBars;
import org.eclipse.ui.internal.ActionSetContributionItem;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.PluginActionCoolBarContributionItem;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.PluginActionSetBuilder;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.dialogs.TreeManager;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.internal.registry.ActionSetDescriptor;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.model.WorkbenchViewerComparator;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.IViewCategory;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class CustomizePerspectiveDialog
extends TrayDialog {
    private static final String TOOLBAR_ICON = "$nl$/icons/full/obj16/toolbar.gif";
    private static final String SUBMENU_ICON = "$nl$/icons/full/obj16/submenu.gif";
    private static final String MENU_ICON = "$nl$/icons/full/obj16/menu.gif";
    private static final String WARNING_ICON = "$nl$/icons/full/obj16/warn_tsk.gif";
    private static final String SHORTCUT_CONTRIBUTION_ITEM_ID_OPEN_PERSPECTIVE = "openPerspective";
    private static final String SHORTCUT_CONTRIBUTION_ITEM_ID_SHOW_VIEW = "showView";
    private static final String KEYS_PREFERENCE_PAGE_ID = "org.eclipse.ui.preferencePages.Keys";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final int MIN_TOOLTIP_WIDTH = 160;
    private WorkbenchWindow window;
    private Perspective perspective;
    private TabFolder tabFolder;
    private static final int TAB_WIDTH_IN_DLUS = 490;
    private static final int TAB_HEIGHT_IN_DLUS = 230;
    private final String[] shortcutMenuColumnHeaders = new String[]{WorkbenchMessages.ActionSetSelection_menuColumnHeader, WorkbenchMessages.ActionSetSelection_descriptionColumnHeader};
    private int[] shortcutMenuColumnWidths = new int[]{125, 300};
    ImageDescriptor menuImageDescriptor = null;
    ImageDescriptor submenuImageDescriptor = null;
    ImageDescriptor toolbarImageDescriptor = null;
    ImageDescriptor warningImageDescriptor = null;
    private TreeManager treeManager;
    private DisplayItem menuItems;
    private DisplayItem toolBarItems;
    private Category shortcuts;
    private DisplayItem wizards;
    private DisplayItem perspectives;
    private DisplayItem views;
    private Map idToActionSet = new HashMap();
    private final List actionSets = new ArrayList();
    private IWorkbenchWindowConfigurer configurer;
    private TabItem actionSetTab;
    private CheckboxTableViewer actionSetAvailabilityTable;
    private CheckboxTreeViewer menuStructureViewer1;
    private CheckboxTreeViewer menuStructureViewer2;
    private CheckboxTreeViewer toolbarStructureViewer1;
    private CheckboxTreeViewer toolbarStructureViewer2;
    private Set toDispose;
    private CustomizeActionBars customizeActionBars;
    private Font tooltipHeading;

    private static ActionContributionItem getIContributionItem(IWizardDescriptor iWizardDescriptor, IWorkbenchWindow iWorkbenchWindow) {
        NewWizardShortcutAction newWizardShortcutAction = new NewWizardShortcutAction(iWorkbenchWindow, iWizardDescriptor);
        return new ActionContributionItem((IAction)newWizardShortcutAction);
    }

    private static ActionContributionItem getIContributionItem(IPerspectiveDescriptor iPerspectiveDescriptor, IWorkbenchWindow iWorkbenchWindow) {
        OpenPerspectiveAction openPerspectiveAction = new OpenPerspectiveAction(iWorkbenchWindow, iPerspectiveDescriptor, null);
        return new ActionContributionItem((IAction)openPerspectiveAction);
    }

    private static ActionContributionItem getIContributionItem(IWorkbenchWindow iWorkbenchWindow) {
        ActionFactory.IWorkbenchAction iWorkbenchAction = ActionFactory.SHOW_VIEW_MENU.create(iWorkbenchWindow);
        return new ActionContributionItem((IAction)iWorkbenchAction);
    }

    public CustomizePerspectiveDialog(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer, Perspective perspective) {
        super(iWorkbenchWindowConfigurer.getWindow().getShell());
        this.treeManager = new TreeManager();
        this.configurer = iWorkbenchWindowConfigurer;
        this.perspective = perspective;
        this.window = (WorkbenchWindow)iWorkbenchWindowConfigurer.getWindow();
        this.toDispose = new HashSet();
        this.initializeIcons();
        this.initializeActionSetInput();
        this.loadMenuAndToolbarStructure();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String string = this.perspective.getDesc().getLabel();
        string = NLS.bind((String)WorkbenchMessages.ActionSetSelection_customize, (Object)string);
        shell.setText(string);
        this.window.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.action_set_selection_dialog_context");
    }

    protected Control createDialogArea(Composite composite) {
        FontData[] fontDataArray = JFaceResources.getDefaultFont().getFontData();
        FontData fontData = new FontData(fontDataArray[0].getName(), fontDataArray[0].getHeight(), 1);
        this.tooltipHeading = new Font((Device)composite.getDisplay(), fontData);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.tabFolder = new TabFolder(composite2, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(490);
        gridData.heightHint = this.convertVerticalDLUsToPixels(230);
        this.tabFolder.setLayoutData((Object)gridData);
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText(WorkbenchMessages.HideToolBarItems_toolBarItemsTab);
        tabItem.setControl((Control)this.createToolBarVisibilityPage((Composite)this.tabFolder));
        tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setControl((Control)this.createMenuVisibilityPage((Composite)this.tabFolder));
        tabItem.setText(WorkbenchMessages.HideMenuItems_menuItemsTab);
        CustomizePerspectiveDialog.applyDialogFont((Control)this.tabFolder);
        return composite2;
    }

    private Composite createShortCutsPage(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 64);
        label.setText(NLS.bind((String)WorkbenchMessages.Shortcuts_selectShortcutsLabel, (Object)this.perspective.getDesc().getLabel()));
        GridData gridData = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 258);
        label2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        SashForm sashForm = new SashForm(composite2, 256);
        gridData = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)gridData);
        Composite composite3 = new Composite((Composite)sashForm, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(composite3, 64);
        label.setText(WorkbenchMessages.Shortcuts_availableMenus);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Combo combo = new Combo(composite3, 8);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ComboViewer comboViewer = new ComboViewer(combo);
        comboViewer.setContentProvider((IContentProvider)TreeManager.getTreeContentProvider());
        comboViewer.setLabelProvider(TreeManager.getLabelProvider());
        label = new Label(composite3, 64);
        label.setText(WorkbenchMessages.Shortcuts_availableCategories);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final CheckboxTreeViewer checkboxTreeViewer = new CheckboxTreeViewer(composite3);
        checkboxTreeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        checkboxTreeViewer.setLabelProvider(TreeManager.getLabelProvider());
        checkboxTreeViewer.setContentProvider((IContentProvider)TreeManager.getTreeContentProvider());
        checkboxTreeViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        checkboxTreeViewer.setCheckStateProvider((ICheckStateProvider)new CategoryCheckProvider());
        checkboxTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                Category category = (Category)checkStateChangedEvent.getElement();
                category.setItemsState(checkStateChangedEvent.getChecked());
                CustomizePerspectiveDialog.this.updateCategoryAndParents((StructuredViewer)checkboxTreeViewer, category);
            }
        });
        this.treeManager.addListener(new TreeManager.CheckListener(){

            @Override
            public void checkChanged(TreeManager.TreeItem treeItem) {
                ShortcutItem shortcutItem;
                if (treeItem instanceof Category) {
                    checkboxTreeViewer.update((Object)treeItem, null);
                } else if (treeItem instanceof ShortcutItem && (shortcutItem = (ShortcutItem)treeItem).getCategory() != null) {
                    shortcutItem.getCategory().update();
                    CustomizePerspectiveDialog.this.updateCategoryAndParents((StructuredViewer)checkboxTreeViewer, shortcutItem.getCategory());
                }
            }
        });
        Composite composite4 = new Composite((Composite)sashForm, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(composite4, 64);
        label.setText(WorkbenchMessages.Shortcuts_allShortcuts);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final CheckboxTableViewer checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)composite4, (int)2816);
        Table table = checkboxTableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new ShortcutLabelProvider());
        checkboxTableViewer.setCheckStateProvider(TreeManager.getCheckStateProvider());
        checkboxTableViewer.addCheckStateListener(this.treeManager.getViewerCheckStateListener());
        this.treeManager.getCheckListener((ICheckable)checkboxTableViewer);
        checkboxTableViewer.setContentProvider((IContentProvider)new TreeManager.TreeItemContentProvider(){

            @Override
            public Object[] getChildren(Object object) {
                if (object instanceof Category) {
                    return ((Category)object).getContributionItems().toArray();
                }
                return super.getChildren(object);
            }
        });
        checkboxTableViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                Category category = (Category)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                checkboxTreeViewer.setInput((Object)category);
                checkboxTableViewer.setInput((Object)category);
                if (category.getChildren().size() != 0) {
                    CustomizePerspectiveDialog.this.setSelectionOn((Viewer)checkboxTreeViewer, category.getChildren().get(0));
                }
            }
        });
        checkboxTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                Category category = (Category)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                checkboxTableViewer.setInput((Object)category);
            }
        });
        table.setHeaderVisible(true);
        int[] nArray = new int[this.shortcutMenuColumnWidths.length];
        int n = 0;
        while (n < this.shortcutMenuColumnWidths.length) {
            nArray[n] = this.convertHorizontalDLUsToPixels(this.shortcutMenuColumnWidths[n]);
            ++n;
        }
        n = 0;
        while (n < this.shortcutMenuColumnHeaders.length) {
            TableColumn tableColumn = new TableColumn(table, 0, n);
            tableColumn.setResizable(true);
            tableColumn.setText(this.shortcutMenuColumnHeaders[n]);
            tableColumn.setWidth(nArray[n]);
            ++n;
        }
        sashForm.setWeights(new int[]{30, 70});
        comboViewer.setInput((Object)this.shortcuts);
        if (this.shortcuts.getChildren().size() > 0) {
            this.setSelectionOn((Viewer)comboViewer, this.shortcuts.getChildren().get(0));
        }
        return composite2;
    }

    private Composite createActionSetAvailabilityPage(Composite composite) {
        CheckboxTableViewer checkboxTableViewer;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 64);
        label.setText(NLS.bind((String)WorkbenchMessages.ActionSetSelection_selectActionSetsLabel, (Object)this.perspective.getDesc().getLabel()));
        GridData gridData = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 258);
        label2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        SashForm sashForm = new SashForm(composite2, 256);
        gridData = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)gridData);
        Composite composite3 = new Composite((Composite)sashForm, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(composite3, 64);
        label.setText(WorkbenchMessages.ActionSetSelection_availableActionSets);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.actionSetAvailabilityTable = checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)composite3, (int)2816);
        checkboxTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        checkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        checkboxTableViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object object) {
                return ((ActionSet)object).isActive();
            }

            public boolean isGrayed(Object object) {
                return false;
            }
        });
        checkboxTableViewer.setInput((Object)this.actionSets.toArray());
        Table table = checkboxTableViewer.getTable();
        new TableToolTip(table);
        final ActionSet[] actionSetArray = new ActionSet[1];
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (actionSetArray[0] == null) {
                    return false;
                }
                return CustomizePerspectiveDialog.includeInSetStructure((DisplayItem)object2, actionSetArray[0]);
            }
        };
        checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                ActionSet actionSet = (ActionSet)checkStateChangedEvent.getElement();
                if (checkStateChangedEvent.getChecked()) {
                    actionSet.setActive(true);
                    for (DisplayItem displayItem : actionSet.contributionItems) {
                        displayItem.setCheckState(true);
                    }
                } else {
                    actionSet.setActive(false);
                }
            }
        });
        Composite composite4 = new Composite((Composite)sashForm, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        composite4.setLayout((Layout)gridLayout);
        composite4.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite5 = new Composite(composite4, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite5.setLayout((Layout)gridLayout);
        composite5.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(composite5, 64);
        label.setText(WorkbenchMessages.ActionSetSelection_menubarActions);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final TreeViewer treeViewer = new TreeViewer(composite5);
        treeViewer.setAutoExpandLevel(-1);
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.setUseHashlookup(true);
        treeViewer.setContentProvider((IContentProvider)TreeManager.getTreeContentProvider());
        treeViewer.setLabelProvider(TreeManager.getLabelProvider());
        treeViewer.addFilter(viewerFilter);
        treeViewer.setInput((Object)this.menuItems);
        Tree tree = treeViewer.getTree();
        new ItemDetailToolTip(treeViewer, tree, false, true, viewerFilter);
        Composite composite6 = new Composite(composite4, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite6.setLayout((Layout)gridLayout);
        composite6.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(composite6, 64);
        label.setText(WorkbenchMessages.ActionSetSelection_toolbarActions);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final TreeViewer treeViewer2 = new TreeViewer(composite6);
        treeViewer2.setAutoExpandLevel(-1);
        treeViewer2.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer2.setContentProvider((IContentProvider)TreeManager.getTreeContentProvider());
        treeViewer2.setLabelProvider(TreeManager.getLabelProvider());
        treeViewer2.addFilter(viewerFilter);
        treeViewer2.setInput((Object)this.toolBarItems);
        tree = treeViewer2.getTree();
        new ItemDetailToolTip(treeViewer2, tree, false, true, viewerFilter);
        checkboxTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                actionSetArray[0] = (ActionSet)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                treeViewer.setInput((Object)CustomizePerspectiveDialog.this.menuItems);
                treeViewer2.setInput((Object)CustomizePerspectiveDialog.this.toolBarItems);
            }
        });
        sashForm.setWeights(new int[]{30, 70});
        return composite2;
    }

    private Composite createMenuVisibilityPage(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 64);
        label.setText(WorkbenchMessages.HideMenuItems_chooseMenuItemsLabel);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 258);
        label2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final PageBook pageBook = new PageBook(composite2, 0);
        gridData = new GridData(1808);
        pageBook.setLayoutData(gridData);
        final Composite composite3 = CustomizePerspectiveDialog.createItemStructureGroup(pageBook, WorkbenchMessages.HideMenuItems_menuStructure);
        this.menuStructureViewer1 = this.initStructureViewer(composite3, new TreeManager.ViewerCheckStateListener(), null);
        this.treeManager.getCheckListener((ICheckable)this.menuStructureViewer1);
        this.menuStructureViewer1.setCheckStateProvider(TreeManager.getCheckStateProvider());
        this.menuStructureViewer1.setInput((Object)this.menuItems);
        final SashForm sashForm = new SashForm((Composite)pageBook, 256);
        gridData = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)gridData);
        final TableViewer tableViewer = this.initActionSetViewer(CustomizePerspectiveDialog.createActionSetGroup((Composite)sashForm));
        tableViewer.addFilter((ViewerFilter)new ShowUsedActionSetsFilter(this.menuItems));
        tableViewer.setInput((Object)this.actionSets.toArray());
        ActionSetFilter actionSetFilter = new ActionSetFilter();
        Composite composite4 = CustomizePerspectiveDialog.createItemStructureGroup((Composite)sashForm, WorkbenchMessages.HideMenuItems_menuStructure);
        FilteredViewerCheckListener filteredViewerCheckListener = new FilteredViewerCheckListener(TreeManager.getTreeContentProvider(), actionSetFilter);
        this.menuStructureViewer2 = this.initStructureViewer(composite4, filteredViewerCheckListener, actionSetFilter);
        this.treeManager.addListener(new FilteredModelCheckListener(actionSetFilter, (StructuredViewer)this.menuStructureViewer2));
        this.menuStructureViewer2.addFilter((ViewerFilter)actionSetFilter);
        tableViewer.addSelectionChangedListener((ISelectionChangedListener)new ActionSetSelectionChangedListener((TreeViewer)this.menuStructureViewer2, actionSetFilter));
        this.menuStructureViewer2.setCheckStateProvider((ICheckStateProvider)new FilteredTreeCheckProvider(TreeManager.getTreeContentProvider(), actionSetFilter));
        this.menuStructureViewer2.setInput((Object)this.menuItems);
        this.treeManager.addListener(new TreeManager.CheckListener(){

            @Override
            public void checkChanged(TreeManager.TreeItem treeItem) {
                if (!(treeItem instanceof DisplayItem)) {
                    return;
                }
                if (!treeItem.getState()) {
                    return;
                }
                if (CustomizePerspectiveDialog.isAvailable((DisplayItem)treeItem)) {
                    return;
                }
                treeItem.setCheckState(false);
            }
        });
        final Button button = new Button(composite2, 32);
        button.setText(WorkbenchMessages.HideItems_turnOnActionSets);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (button.getSelection()) {
                    Object object = ((StructuredSelection)CustomizePerspectiveDialog.this.menuStructureViewer1.getSelection()).getFirstElement();
                    ActionSet actionSet = null;
                    DisplayItem displayItem = null;
                    if (object instanceof DisplayItem) {
                        displayItem = (DisplayItem)object;
                        actionSet = displayItem.getActionSet();
                    }
                    if (actionSet == null) {
                        actionSet = (ActionSet)tableViewer.getElementAt(0);
                    }
                    CustomizePerspectiveDialog.this.setSelectionOn((Viewer)tableViewer, actionSet);
                    tableViewer.reveal((Object)actionSet);
                    if (displayItem != null) {
                        CustomizePerspectiveDialog.this.setSelectionOn((Viewer)CustomizePerspectiveDialog.this.menuStructureViewer2, displayItem);
                        CustomizePerspectiveDialog.this.menuStructureViewer2.reveal((Object)displayItem);
                    }
                    pageBook.showPage((Control)sashForm);
                } else {
                    pageBook.showPage((Control)composite3);
                }
            }
        });
        pageBook.showPage((Control)composite3);
        sashForm.setWeights(new int[]{30, 70});
        return composite2;
    }

    private Composite createToolBarVisibilityPage(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 64);
        label.setText(WorkbenchMessages.HideToolBarItems_chooseToolBarItemsLabel);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        label.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 258);
        label2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        final PageBook pageBook = new PageBook(composite2, 0);
        gridData = new GridData(1808);
        pageBook.setLayoutData(gridData);
        final Composite composite3 = CustomizePerspectiveDialog.createItemStructureGroup(pageBook, WorkbenchMessages.HideToolBarItems_toolBarStructure);
        this.toolbarStructureViewer1 = this.initStructureViewer(composite3, new TreeManager.ViewerCheckStateListener(), null);
        this.treeManager.getCheckListener((ICheckable)this.toolbarStructureViewer1);
        this.toolbarStructureViewer1.setCheckStateProvider(TreeManager.getCheckStateProvider());
        this.toolbarStructureViewer1.setInput((Object)this.toolBarItems);
        final SashForm sashForm = new SashForm((Composite)pageBook, 256);
        gridData = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)gridData);
        final TableViewer tableViewer = this.initActionSetViewer(CustomizePerspectiveDialog.createActionSetGroup((Composite)sashForm));
        tableViewer.addFilter((ViewerFilter)new ShowUsedActionSetsFilter(this.toolBarItems));
        tableViewer.setInput((Object)this.actionSets.toArray());
        ActionSetFilter actionSetFilter = new ActionSetFilter();
        Composite composite4 = CustomizePerspectiveDialog.createItemStructureGroup((Composite)sashForm, WorkbenchMessages.HideToolBarItems_toolBarStructure);
        FilteredViewerCheckListener filteredViewerCheckListener = new FilteredViewerCheckListener(TreeManager.getTreeContentProvider(), actionSetFilter);
        this.toolbarStructureViewer2 = this.initStructureViewer(composite4, filteredViewerCheckListener, actionSetFilter);
        this.toolbarStructureViewer2.addFilter((ViewerFilter)actionSetFilter);
        this.treeManager.addListener(new FilteredModelCheckListener(actionSetFilter, (StructuredViewer)this.toolbarStructureViewer2));
        tableViewer.addSelectionChangedListener((ISelectionChangedListener)new ActionSetSelectionChangedListener((TreeViewer)this.toolbarStructureViewer2, actionSetFilter));
        this.toolbarStructureViewer2.setCheckStateProvider((ICheckStateProvider)new FilteredTreeCheckProvider(TreeManager.getTreeContentProvider(), actionSetFilter));
        this.toolbarStructureViewer2.setInput((Object)this.toolBarItems);
        this.treeManager.addListener(new TreeManager.CheckListener(){

            @Override
            public void checkChanged(TreeManager.TreeItem treeItem) {
                if (!(treeItem instanceof DisplayItem)) {
                    return;
                }
                if (!treeItem.getState()) {
                    return;
                }
                if (CustomizePerspectiveDialog.isAvailable((DisplayItem)treeItem)) {
                    return;
                }
                treeItem.setCheckState(false);
            }
        });
        final Button button = new Button(composite2, 32);
        button.setText(WorkbenchMessages.HideItems_turnOnActionSets);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (button.getSelection()) {
                    Object object = ((StructuredSelection)CustomizePerspectiveDialog.this.toolbarStructureViewer1.getSelection()).getFirstElement();
                    ActionSet actionSet = null;
                    DisplayItem displayItem = null;
                    if (object instanceof DisplayItem) {
                        displayItem = (DisplayItem)object;
                        actionSet = displayItem.getActionSet();
                    }
                    if (actionSet == null) {
                        actionSet = (ActionSet)tableViewer.getElementAt(0);
                    }
                    CustomizePerspectiveDialog.this.setSelectionOn((Viewer)tableViewer, actionSet);
                    tableViewer.reveal((Object)actionSet);
                    if (displayItem != null) {
                        CustomizePerspectiveDialog.this.setSelectionOn((Viewer)CustomizePerspectiveDialog.this.toolbarStructureViewer2, displayItem);
                        CustomizePerspectiveDialog.this.toolbarStructureViewer2.reveal((Object)displayItem);
                    }
                    pageBook.showPage((Control)sashForm);
                } else {
                    pageBook.showPage((Control)composite3);
                }
            }
        });
        pageBook.showPage((Control)composite3);
        sashForm.setWeights(new int[]{30, 70});
        return composite2;
    }

    private TableViewer initActionSetViewer(Composite composite) {
        TableViewer tableViewer = new TableViewer(composite, 2816);
        tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        tableViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        Table table = tableViewer.getTable();
        new TableToolTip(table);
        return tableViewer;
    }

    private CheckboxTreeViewer initStructureViewer(Composite composite, ICheckStateListener iCheckStateListener, ViewerFilter viewerFilter) {
        CheckboxTreeViewer checkboxTreeViewer = new CheckboxTreeViewer(composite, 2816);
        checkboxTreeViewer.getControl().setLayoutData((Object)new GridData(1808));
        checkboxTreeViewer.setUseHashlookup(true);
        checkboxTreeViewer.setContentProvider((IContentProvider)TreeManager.getTreeContentProvider());
        checkboxTreeViewer.addCheckStateListener((ICheckStateListener)new UnavailableContributionItemCheckListener(checkboxTreeViewer, iCheckStateListener));
        checkboxTreeViewer.setLabelProvider((IBaseLabelProvider)new GrayOutUnavailableLabelProvider(composite.getDisplay(), viewerFilter));
        new ItemDetailToolTip((TreeViewer)checkboxTreeViewer, checkboxTreeViewer.getTree(), true, true, viewerFilter);
        return checkboxTreeViewer;
    }

    private static Composite createItemStructureGroup(Composite composite, String string) {
        GridLayout gridLayout = new GridLayout();
        Composite composite2 = new Composite(composite, 0);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite2, 64);
        label.setText(string);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return composite2;
    }

    private static Composite createActionSetGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite2, 64);
        label.setText(WorkbenchMessages.HideItems_commandGroupTitle);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return composite2;
    }

    private void setSelectionOn(Viewer viewer, Object object) {
        viewer.setSelection((ISelection)new StructuredSelection(object), true);
    }

    private static boolean includeInSetStructure(DisplayItem displayItem, ActionSet actionSet) {
        if (displayItem.actionSet != null && displayItem.actionSet.equals(actionSet)) {
            return true;
        }
        for (DisplayItem displayItem2 : displayItem.getChildren()) {
            if (!CustomizePerspectiveDialog.includeInSetStructure(displayItem2, actionSet)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAvailable(DisplayItem displayItem) {
        if (displayItem.getActionSet() == null) {
            return true;
        }
        if (displayItem.getActionSet().isActive()) {
            return true;
        }
        for (DisplayItem displayItem2 : displayItem.getChildren()) {
            if (!CustomizePerspectiveDialog.isAvailable(displayItem2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEffectivelyAvailable(DisplayItem displayItem, ViewerFilter viewerFilter) {
        if (!CustomizePerspectiveDialog.isAvailable(displayItem)) {
            return false;
        }
        List list = displayItem.getChildren();
        if (list.isEmpty()) {
            return true;
        }
        for (DisplayItem displayItem2 : list) {
            if (viewerFilter != null && !viewerFilter.select(null, null, (Object)displayItem2) || !CustomizePerspectiveDialog.isAvailable(displayItem2)) continue;
            return true;
        }
        for (DisplayItem displayItem2 : list) {
            if (viewerFilter != null && !viewerFilter.select(null, null, (Object)displayItem2) || !CustomizePerspectiveDialog.isEffectivelyAvailable(displayItem2, viewerFilter)) continue;
            return true;
        }
        return false;
    }

    private static void collectDescendantCommandGroups(Collection collection, DisplayItem displayItem, ViewerFilter viewerFilter) {
        List list = displayItem.getChildren();
        for (DisplayItem displayItem2 : list) {
            if ((viewerFilter == null || viewerFilter.select(null, null, (Object)displayItem2)) && displayItem2.getActionSet() != null) {
                collection.add(displayItem2.getActionSet());
            }
            CustomizePerspectiveDialog.collectDescendantCommandGroups(collection, displayItem2, viewerFilter);
        }
    }

    private Binding[] getKeyBindings(DisplayItem displayItem) {
        IBindingService iBindingService = (IBindingService)this.window.getService(IBindingService.class);
        if (!(iBindingService instanceof BindingService)) {
            return new Binding[0];
        }
        String string = CustomizePerspectiveDialog.getCommandID(displayItem);
        String string2 = CustomizePerspectiveDialog.getParamID(displayItem);
        BindingManager bindingManager = ((BindingService)iBindingService).getBindingManager();
        Collection collection = bindingManager.getActiveBindingsDisregardingContextFlat();
        ArrayList<Binding> arrayList = new ArrayList<Binding>(2);
        for (Binding binding : collection) {
            if (binding.getParameterizedCommand() == null || binding.getParameterizedCommand().getId() == null || !binding.getParameterizedCommand().getId().equals(string)) continue;
            if (string2 == null) {
                arrayList.add(binding);
                continue;
            }
            Map map = binding.getParameterizedCommand().getParameterMap();
            String string3 = null;
            if (CustomizePerspectiveDialog.isNewWizard(displayItem)) {
                string3 = "newWizardId";
            } else if (CustomizePerspectiveDialog.isShowView(displayItem)) {
                string3 = "org.eclipse.ui.views.showView.viewId";
            } else if (CustomizePerspectiveDialog.isShowPerspective(displayItem)) {
                string3 = "org.eclipse.ui.perspectives.showPerspective.perspectiveId";
            }
            if (string3 == null || !string2.equals(map.get(string3))) continue;
            arrayList.add(binding);
        }
        Binding[] bindingArray = arrayList.toArray(new Binding[arrayList.size()]);
        return bindingArray;
    }

    private String keyBindingsAsString(Binding[] bindingArray) {
        String string = null;
        int n = 0;
        while (n < bindingArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < n && !bl) {
                if (bindingArray[n].getTriggerSequence().equals((Object)bindingArray[n2].getTriggerSequence())) {
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                String string2 = bindingArray[n].getTriggerSequence().format();
                string = n == 0 ? string2 : Util.createList(string, string2);
            }
            ++n;
        }
        return string;
    }

    private void actionSetAvailabilityChanged() {
        this.menuStructureViewer1.refresh();
        this.menuStructureViewer2.refresh();
        this.toolbarStructureViewer1.refresh();
        this.toolbarStructureViewer2.refresh();
    }

    private void initializeActionSetInput() {
        ActionSetRegistry actionSetRegistry = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] iActionSetDescriptorArray = actionSetRegistry.getActionSets();
        IActionSetDescriptor[] iActionSetDescriptorArray2 = ((WorkbenchPage)this.window.getActivePage()).getActionSets();
        List<IActionSetDescriptor> list = Arrays.asList(iActionSetDescriptorArray2);
        int n = 0;
        while (n < iActionSetDescriptorArray.length) {
            ActionSetDescriptor actionSetDescriptor = (ActionSetDescriptor)iActionSetDescriptorArray[n];
            if (!WorkbenchActivityHelper.filterItem(actionSetDescriptor)) {
                ActionSet actionSet = new ActionSet(actionSetDescriptor, list.contains(actionSetDescriptor));
                this.idToActionSet.put(actionSetDescriptor.getId(), actionSet);
                this.actionSets.add(actionSet);
            }
            ++n;
        }
    }

    private void initializeIcons() {
        String string = MENU_ICON;
        URL uRL = BundleUtility.find("org.eclipse.ui", string);
        this.menuImageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
        string = SUBMENU_ICON;
        uRL = BundleUtility.find("org.eclipse.ui", string);
        this.submenuImageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
        string = TOOLBAR_ICON;
        uRL = BundleUtility.find("org.eclipse.ui", string);
        this.toolbarImageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
        string = WARNING_ICON;
        uRL = BundleUtility.find("org.eclipse.ui", string);
        this.warningImageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
    }

    private void initializeNewWizardsMenu(DisplayItem displayItem, Category category, IWizardCategory iWizardCategory, List list) {
        Category category2 = new Category(iWizardCategory.getLabel());
        category.addChild(category2);
        IWizardDescriptor[] iWizardDescriptorArray = iWizardCategory.getWizards();
        int n = 0;
        while (n < iWizardDescriptorArray.length) {
            WorkbenchWizardElement workbenchWizardElement = (WorkbenchWizardElement)iWizardDescriptorArray[n];
            ShortcutItem shortcutItem = new ShortcutItem(workbenchWizardElement.getLabel(), workbenchWizardElement);
            shortcutItem.setLabel(workbenchWizardElement.getLabel());
            shortcutItem.setDescription(workbenchWizardElement.getDescription());
            if (workbenchWizardElement.getImageDescriptor() != null) {
                shortcutItem.setImageDescriptor(workbenchWizardElement.getImageDescriptor());
            }
            shortcutItem.setCheckState(list.contains(workbenchWizardElement.getId()));
            displayItem.addChild(shortcutItem);
            category2.addShortcutItem(shortcutItem);
            ++n;
        }
        IWizardCategory[] iWizardCategoryArray = iWizardCategory.getCategories();
        int n2 = 0;
        while (n2 < iWizardCategoryArray.length) {
            this.initializeNewWizardsMenu(displayItem, category2, iWizardCategoryArray[n2], list);
            ++n2;
        }
    }

    private void initializeNewWizardsMenu(DisplayItem displayItem) {
        Category category = new Category(WorkbenchMessages.ActionSetDialogInput_wizardCategory);
        this.shortcuts.addChild(category);
        IWizardCategory iWizardCategory = WorkbenchPlugin.getDefault().getNewWizardRegistry().getRootCategory();
        IWizardCategory[] iWizardCategoryArray = iWizardCategory.getCategories();
        List<String> list = Arrays.asList(this.perspective.getNewWizardShortcuts());
        int n = 0;
        while (n < iWizardCategoryArray.length) {
            IWizardCategory iWizardCategory2 = iWizardCategoryArray[n];
            if (!WorkbenchActivityHelper.filterItem(iWizardCategory2)) {
                this.initializeNewWizardsMenu(displayItem, category, iWizardCategory2, list);
            }
            ++n;
        }
    }

    private void initializePerspectivesMenu(DisplayItem displayItem) {
        Category category = new Category(WorkbenchMessages.ActionSetDialogInput_perspectiveCategory);
        this.shortcuts.addChild(category);
        IPerspectiveRegistry iPerspectiveRegistry = WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = iPerspectiveRegistry.getPerspectives();
        List<String> list = Arrays.asList(this.perspective.getPerspectiveShortcuts());
        int n = 0;
        while (n < iPerspectiveDescriptorArray.length) {
            IPerspectiveDescriptor iPerspectiveDescriptor = iPerspectiveDescriptorArray[n];
            if (!WorkbenchActivityHelper.filterItem(iPerspectiveDescriptor)) {
                ShortcutItem shortcutItem = new ShortcutItem(iPerspectiveDescriptor.getLabel(), iPerspectiveDescriptor);
                shortcutItem.setImageDescriptor(iPerspectiveDescriptor.getImageDescriptor());
                shortcutItem.setDescription(iPerspectiveDescriptor.getDescription());
                shortcutItem.setCheckState(list.contains(iPerspectiveDescriptor.getId()));
                displayItem.addChild(shortcutItem);
                category.addShortcutItem(shortcutItem);
            }
            ++n;
        }
    }

    private void initializeViewsMenu(DisplayItem displayItem) {
        Category category = new Category(WorkbenchMessages.ActionSetDialogInput_viewCategory);
        this.shortcuts.addChild(category);
        IViewRegistry iViewRegistry = WorkbenchPlugin.getDefault().getViewRegistry();
        IViewCategory[] iViewCategoryArray = iViewRegistry.getCategories();
        List<String> list = Arrays.asList(this.perspective.getShowViewShortcuts());
        int n = 0;
        while (n < iViewCategoryArray.length) {
            IViewCategory iViewCategory = iViewCategoryArray[n];
            if (!WorkbenchActivityHelper.filterItem(iViewCategory)) {
                Category category2 = new Category(iViewCategory.getLabel());
                category.addChild(category2);
                IViewDescriptor[] iViewDescriptorArray = iViewCategory.getViews();
                if (iViewDescriptorArray != null) {
                    int n2 = 0;
                    while (n2 < iViewDescriptorArray.length) {
                        IViewDescriptor iViewDescriptor = iViewDescriptorArray[n2];
                        if (!iViewDescriptor.getId().equals("org.eclipse.ui.internal.introview") && !WorkbenchActivityHelper.filterItem(iViewDescriptor)) {
                            ShortcutItem shortcutItem = new ShortcutItem(iViewDescriptor.getLabel(), iViewDescriptor);
                            shortcutItem.setImageDescriptor(iViewDescriptor.getImageDescriptor());
                            shortcutItem.setDescription(iViewDescriptor.getDescription());
                            shortcutItem.setCheckState(list.contains(iViewDescriptor.getId()));
                            displayItem.addChild(shortcutItem);
                            category2.addShortcutItem(shortcutItem);
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    private void loadMenuAndToolbarStructure() {
        ActionSet actionSet2;
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.customizeActionBars = new CustomizeActionBars(this.configurer);
        this.window.fillActionBars(this.customizeActionBars, 7);
        IMenuService iMenuService = (IMenuService)this.window.getService(IMenuService.class);
        iMenuService.populateContributionManager((ContributionManager)this.customizeActionBars.getMenuManager(), "menu:org.eclipse.ui.main.menu");
        ICoolBarManager iCoolBarManager = this.customizeActionBars.getCoolBarManager();
        if (iCoolBarManager != null) {
            iMenuService.populateContributionManager((ContributionManager)iCoolBarManager, "toolbar:org.eclipse.ui.main.toolbar");
        }
        for (ActionSet actionSet2 : this.actionSets) {
            ActionSetDescriptor actionSetDescriptor = actionSet2.descriptor;
            PluginActionSet pluginActionSet = this.buildMenusAndToolbarsFor(this.customizeActionBars, actionSetDescriptor);
            if (pluginActionSet == null) continue;
            pluginActionSet.dispose();
        }
        this.customizeActionBars.menuManager.setVisible(true);
        CustomizePerspectiveDialog.makeAllContributionsVisible((IContributionManager)this.customizeActionBars.menuManager);
        Menu menu = this.customizeActionBars.menuManager.createMenuBar((Decorations)workbenchWindow.getShell());
        actionSet2 = this.customizeActionBars.coolBarManager.createControl((Composite)workbenchWindow.getShell());
        actionSet2.equals(actionSet2);
        this.customizeActionBars.menuManager.updateAll(true);
        this.customizeActionBars.coolBarManager.update(true);
        this.shortcuts = new Category("");
        this.toolBarItems = this.createToolBarStructure((CoolBar)actionSet2);
        this.menuItems = this.createMenuStructure(menu);
    }

    private PluginActionSet buildMenusAndToolbarsFor(CustomizeActionBars customizeActionBars, ActionSetDescriptor actionSetDescriptor) {
        String string = actionSetDescriptor.getId();
        ActionSetActionBars actionSetActionBars = new ActionSetActionBars(customizeActionBars, this.window, customizeActionBars, string);
        actionSetActionBars.getMenuManager().setVisible(true);
        PluginActionSetBuilder pluginActionSetBuilder = new PluginActionSetBuilder();
        PluginActionSet pluginActionSet = null;
        try {
            pluginActionSet = (PluginActionSet)actionSetDescriptor.createActionSet();
            pluginActionSet.init(null, actionSetActionBars);
        }
        catch (CoreException coreException) {
            WorkbenchPlugin.log("Unable to create action set " + actionSetDescriptor.getId(), coreException);
            return null;
        }
        pluginActionSetBuilder.buildMenuAndToolBarStructure(pluginActionSet, this.window);
        return pluginActionSet;
    }

    private static String getCommandID(DisplayItem displayItem) {
        IContributionItem iContributionItem = displayItem.getIContributionItem();
        if (displayItem instanceof ShortcutItem && CustomizePerspectiveDialog.isShowView(displayItem)) {
            return "org.eclipse.ui.views.showView";
        }
        return CustomizePerspectiveDialog.getIDFromIContributionItem(iContributionItem);
    }

    public static String getIDFromIContributionItem(Object object) {
        if (object instanceof ActionContributionItem) {
            ActionContributionItem actionContributionItem = (ActionContributionItem)object;
            IAction iAction = actionContributionItem.getAction();
            if (iAction == null) {
                return null;
            }
            if (iAction instanceof NewWizardShortcutAction) {
                return "org.eclipse.ui.newWizard";
            }
            if (iAction instanceof OpenPerspectiveAction) {
                return "org.eclipse.ui.perspectives.showPerspective";
            }
            String string = iAction.getActionDefinitionId();
            if (string != null) {
                return string;
            }
            return iAction.getId();
        }
        if (object instanceof ActionSetContributionItem) {
            ActionSetContributionItem actionSetContributionItem = (ActionSetContributionItem)object;
            IContributionItem iContributionItem = actionSetContributionItem.getInnerItem();
            return CustomizePerspectiveDialog.getIDFromIContributionItem(iContributionItem);
        }
        if (object instanceof CommandContributionItem) {
            CommandContributionItem commandContributionItem = (CommandContributionItem)((Object)object);
            ParameterizedCommand parameterizedCommand = commandContributionItem.getCommand();
            if (parameterizedCommand == null) {
                return null;
            }
            return parameterizedCommand.getId();
        }
        if (object instanceof IPerspectiveDescriptor) {
            return ((IPerspectiveDescriptor)object).getId();
        }
        if (object instanceof IViewDescriptor) {
            return ((IViewDescriptor)object).getId();
        }
        if (object instanceof WorkbenchWizardElement) {
            return ((WorkbenchWizardElement)object).getLocalId();
        }
        if (object instanceof IContributionItem) {
            String string = ((IContributionItem)object).getId();
            if (string != null) {
                return string;
            }
            return object.getClass().getName();
        }
        return null;
    }

    private static String getDescription(Object object) {
        if (object instanceof DisplayItem) {
            DisplayItem displayItem = (DisplayItem)object;
            if (CustomizePerspectiveDialog.isNewWizard(displayItem)) {
                ShortcutItem shortcutItem = (ShortcutItem)displayItem;
                IWizardDescriptor iWizardDescriptor = (IWizardDescriptor)shortcutItem.getDescriptor();
                return iWizardDescriptor.getDescription();
            }
            if (CustomizePerspectiveDialog.isShowPerspective(displayItem)) {
                ShortcutItem shortcutItem = (ShortcutItem)displayItem;
                IPerspectiveDescriptor iPerspectiveDescriptor = (IPerspectiveDescriptor)shortcutItem.getDescriptor();
                return iPerspectiveDescriptor.getDescription();
            }
            if (CustomizePerspectiveDialog.isShowView(displayItem)) {
                ShortcutItem shortcutItem = (ShortcutItem)displayItem;
                IViewDescriptor iViewDescriptor = (IViewDescriptor)shortcutItem.getDescriptor();
                return iViewDescriptor.getDescription();
            }
            if (displayItem instanceof DynamicContributionItem) {
                return WorkbenchMessages.HideItems_dynamicItemDescription;
            }
            IContributionItem iContributionItem = displayItem.getIContributionItem();
            return CustomizePerspectiveDialog.getDescription(iContributionItem);
        }
        if (object instanceof ActionSet) {
            ActionSet actionSet = (ActionSet)object;
            return actionSet.descriptor.getDescription();
        }
        return null;
    }

    private static String getDescription(IContributionItem iContributionItem) {
        if (iContributionItem instanceof ActionContributionItem) {
            ActionContributionItem actionContributionItem = (ActionContributionItem)iContributionItem;
            IAction iAction = actionContributionItem.getAction();
            if (iAction == null) {
                return null;
            }
            return iAction.getDescription();
        }
        if (iContributionItem instanceof ActionSetContributionItem) {
            ActionSetContributionItem actionSetContributionItem = (ActionSetContributionItem)iContributionItem;
            IContributionItem iContributionItem2 = actionSetContributionItem.getInnerItem();
            return CustomizePerspectiveDialog.getDescription(iContributionItem2);
        }
        return null;
    }

    private static String getParamID(DisplayItem displayItem) {
        if (displayItem instanceof ShortcutItem) {
            ShortcutItem shortcutItem = (ShortcutItem)displayItem;
            if (CustomizePerspectiveDialog.isNewWizard(shortcutItem)) {
                ActionContributionItem actionContributionItem = (ActionContributionItem)displayItem.getIContributionItem();
                NewWizardShortcutAction newWizardShortcutAction = (NewWizardShortcutAction)actionContributionItem.getAction();
                return newWizardShortcutAction.getLocalId();
            }
            if (CustomizePerspectiveDialog.isShowPerspective(shortcutItem)) {
                ActionContributionItem actionContributionItem = (ActionContributionItem)displayItem.getIContributionItem();
                OpenPerspectiveAction openPerspectiveAction = (OpenPerspectiveAction)actionContributionItem.getAction();
                return openPerspectiveAction.getLocalId();
            }
            if (CustomizePerspectiveDialog.isShowView(shortcutItem)) {
                IViewDescriptor iViewDescriptor = (IViewDescriptor)shortcutItem.getDescriptor();
                return iViewDescriptor.getId();
            }
        }
        return null;
    }

    private static boolean isNewWizard(DisplayItem displayItem) {
        if (!(displayItem instanceof ShortcutItem)) {
            return false;
        }
        return ((ShortcutItem)displayItem).getDescriptor() instanceof IWizardDescriptor;
    }

    private static boolean isShowPerspective(DisplayItem displayItem) {
        if (!(displayItem instanceof ShortcutItem)) {
            return false;
        }
        return ((ShortcutItem)displayItem).getDescriptor() instanceof IPerspectiveDescriptor;
    }

    private static boolean isShowView(DisplayItem displayItem) {
        if (!(displayItem instanceof ShortcutItem)) {
            return false;
        }
        return ((ShortcutItem)displayItem).getDescriptor() instanceof IViewDescriptor;
    }

    private static String getActionSetID(IContributionItem iContributionItem) {
        if (iContributionItem instanceof ActionSetContributionItem) {
            ActionSetContributionItem actionSetContributionItem = (ActionSetContributionItem)iContributionItem;
            return actionSetContributionItem.getActionSetId();
        }
        if (iContributionItem instanceof PluginActionCoolBarContributionItem) {
            PluginActionCoolBarContributionItem pluginActionCoolBarContributionItem = (PluginActionCoolBarContributionItem)iContributionItem;
            return pluginActionCoolBarContributionItem.getActionSetId();
        }
        return null;
    }

    private static void makeAllContributionsVisible(IContributionManager iContributionManager) {
        IContributionItem[] iContributionItemArray = iContributionManager.getItems();
        int n = 0;
        while (n < iContributionItemArray.length) {
            CustomizePerspectiveDialog.makeContributionVisible(iContributionItemArray[n]);
            ++n;
        }
    }

    private static void makeContributionVisible(IContributionItem iContributionItem) {
        iContributionItem.setVisible(true);
        if (iContributionItem instanceof IContributionManager) {
            CustomizePerspectiveDialog.makeAllContributionsVisible((IContributionManager)iContributionItem);
        }
        if (iContributionItem instanceof SubContributionItem) {
            CustomizePerspectiveDialog.makeContributionVisible(((SubContributionItem)iContributionItem).getInnerItem());
        }
    }

    private DisplayItem createMenuStructure(Menu menu) {
        DisplayItem displayItem = new DisplayItem("", null);
        this.createMenuEntries(menu, displayItem, true);
        return displayItem;
    }

    private void createMenuEntries(Menu menu, DisplayItem displayItem, boolean bl) {
        Object object;
        IContributionManager iContributionManager;
        Object object2;
        if (menu == null) {
            return;
        }
        MenuItem[] menuItemArray = menu.getItems();
        HashMap<IContributionItem, IContributionItem> hashMap = new HashMap<IContributionItem, IContributionItem>();
        DisplayItem displayItem2 = null;
        if (bl && menu.getParentItem() != null && (object2 = menu.getParentItem().getData()) instanceof IContributionManager) {
            iContributionManager = (IContributionManager)object2;
            object = iContributionManager.getItems();
            int n = 0;
            while (n < ((IContributionItem[])object).length) {
                if (object[n].isDynamic()) {
                    hashMap.put(n > 0 ? object[n - 1] : null, object[n]);
                }
                ++n;
            }
            if (hashMap.containsKey(null)) {
                IContributionItem iContributionItem = (IContributionItem)hashMap.get(null);
                displayItem2 = new DynamicContributionItem(iContributionItem);
                displayItem.addChild(displayItem2);
            }
        }
        int n = 0;
        while (n < menuItemArray.length) {
            if (!menuItemArray[n].getText().equals("")) {
                iContributionManager = (IContributionItem)menuItemArray[n].getData();
                if (displayItem2 != null && iContributionManager.equals(displayItem2.getIContributionItem())) {
                    ((DynamicContributionItem)displayItem2).addCurrentItem(menuItemArray[n]);
                } else {
                    object = new DisplayItem(menuItemArray[n].getText(), (IContributionItem)iContributionManager);
                    Image image = menuItemArray[n].getImage();
                    if (image != null) {
                        ((TreeManager.TreeItem)object).setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
                    }
                    ((DisplayItem)object).setActionSet((ActionSet)this.idToActionSet.get(CustomizePerspectiveDialog.getActionSetID((IContributionItem)iContributionManager)));
                    displayItem.addChild((TreeManager.TreeItem)object);
                    if (ActionFactory.NEW.getId().equals(((IContributionItem)menuItemArray[n].getData()).getId())) {
                        this.initializeNewWizardsMenu((DisplayItem)object);
                        this.wizards = object;
                    } else if (SHORTCUT_CONTRIBUTION_ITEM_ID_OPEN_PERSPECTIVE.equals(((IContributionItem)menuItemArray[n].getData()).getId())) {
                        this.initializePerspectivesMenu((DisplayItem)object);
                        this.perspectives = object;
                    } else if (SHORTCUT_CONTRIBUTION_ITEM_ID_SHOW_VIEW.equals(((IContributionItem)menuItemArray[n].getData()).getId())) {
                        this.initializeViewsMenu((DisplayItem)object);
                        this.views = object;
                    } else {
                        this.createMenuEntries(menuItemArray[n].getMenu(), (DisplayItem)object, bl);
                    }
                    if (((TreeManager.TreeItem)object).getChildren().isEmpty()) {
                        ((TreeManager.TreeItem)object).setCheckState(this.getMenuItemIsVisible((DisplayItem)object));
                    }
                    if (image == null) {
                        if (displayItem != null && displayItem.getParent() == null) {
                            ((TreeManager.TreeItem)object).setImageDescriptor(this.menuImageDescriptor);
                        } else if (((TreeManager.TreeItem)object).getChildren().size() > 0) {
                            ((TreeManager.TreeItem)object).setImageDescriptor(this.submenuImageDescriptor);
                        }
                    }
                }
                if (bl && hashMap.containsKey(menuItemArray[n].getData())) {
                    object = (IContributionItem)hashMap.get(menuItemArray[n].getData());
                    displayItem2 = new DynamicContributionItem((IContributionItem)object);
                    displayItem2.setCheckState(this.getMenuItemIsVisible(displayItem2));
                    displayItem.addChild(displayItem2);
                }
            }
            ++n;
        }
    }

    private boolean getMenuItemIsVisible(DisplayItem displayItem) {
        return CustomizePerspectiveDialog.isAvailable(displayItem) && !this.perspective.getHiddenMenuItems().contains(CustomizePerspectiveDialog.getCommandID(displayItem));
    }

    private boolean getToolbarItemIsVisible(DisplayItem displayItem) {
        return CustomizePerspectiveDialog.isAvailable(displayItem) && !this.perspective.getHiddenToolbarItems().contains(CustomizePerspectiveDialog.getCommandID(displayItem));
    }

    private void updateCategoryAndParents(StructuredViewer structuredViewer, Category category) {
        while (category.getParent() != this.shortcuts) {
            structuredViewer.update((Object)category, null);
            category = (Category)category.getParent();
        }
    }

    private DisplayItem createToolBarStructure(CoolBar coolBar) {
        DisplayItem displayItem = new DisplayItem(null, null);
        this.createToolbarEntries(coolBar, displayItem);
        return displayItem;
    }

    private void createToolbarEntries(CoolBar coolBar, DisplayItem displayItem) {
        if (coolBar == null) {
            return;
        }
        CoolItem[] coolItemArray = coolBar.getItems();
        ArrayList<Object> arrayList = new ArrayList<Object>(coolItemArray.length);
        int n = 0;
        while (n < coolItemArray.length) {
            String string;
            Object object;
            IContributionItem iContributionItem = (IContributionItem)coolItemArray[n].getData();
            if (iContributionItem instanceof IToolBarContributionItem) {
                object = (IToolBarContributionItem)iContributionItem;
                string = this.window.getToolbarLabel(object.getId());
                if (string == null || string.equals("")) {
                    string = coolItemArray[n].getText();
                }
            } else {
                string = coolItemArray[n].getText();
            }
            object = new DisplayItem(string, iContributionItem);
            if (coolItemArray[n].getImage() == null) {
                ((TreeManager.TreeItem)object).setImageDescriptor(this.toolbarImageDescriptor);
            }
            ((DisplayItem)object).setActionSet((ActionSet)this.idToActionSet.get(CustomizePerspectiveDialog.getActionSetID(iContributionItem)));
            displayItem.addChild((TreeManager.TreeItem)object);
            Control control = coolItemArray[n].getControl();
            if (control instanceof ToolBar) {
                ToolItem[] toolItemArray = ((ToolBar)control).getItems();
                this.createToolbarEntries(toolItemArray, (DisplayItem)object);
            }
            arrayList.add(object);
            ++n;
        }
    }

    private void createToolbarEntries(ToolItem[] toolItemArray, DisplayItem displayItem) {
        if (toolItemArray == null) {
            return;
        }
        int n = 0;
        while (n < toolItemArray.length) {
            IContributionItem iContributionItem = (IContributionItem)toolItemArray[n].getData();
            if (!iContributionItem.isGroupMarker() && !iContributionItem.isSeparator()) {
                DisplayItem displayItem2 = new DisplayItem(toolItemArray[n].getToolTipText(), iContributionItem);
                Image image = toolItemArray[n].getImage();
                if (image != null) {
                    displayItem2.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
                }
                displayItem2.setActionSet((ActionSet)this.idToActionSet.get(CustomizePerspectiveDialog.getActionSetID(iContributionItem)));
                iContributionItem.setVisible(true);
                displayItem2.setCheckState(this.getToolbarItemIsVisible(displayItem2));
                displayItem.addChild(displayItem2);
            }
            ++n;
        }
    }

    private boolean showShortcutTab() {
        return this.window.containsSubmenu(4) || this.window.containsSubmenu(2) || this.window.containsSubmenu(1);
    }

    private ArrayList getVisibleIDs(TreeManager.TreeItem treeItem) {
        if (treeItem == null) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(treeItem.getChildren().size());
        for (DisplayItem displayItem : treeItem.getChildren()) {
            if (!(displayItem instanceof ShortcutItem) || !displayItem.getState()) continue;
            arrayList.add(CustomizePerspectiveDialog.getParamID(displayItem));
        }
        return arrayList;
    }

    private void getChangedIds(DisplayItem displayItem, List list, List list2) {
        if (displayItem instanceof ShortcutItem) {
            return;
        }
        if (displayItem == this.wizards || displayItem == this.perspectives || displayItem == this.views) {
            return;
        }
        if (displayItem.getChildren().size() > 0) {
            Object object;
            if (displayItem.isChangedByUser()) {
                object = CustomizePerspectiveDialog.getCommandID(displayItem);
                if (displayItem.getState()) {
                    list2.add(object);
                } else {
                    list.add(object);
                }
            }
            object = displayItem.getChildren().iterator();
            while (object.hasNext()) {
                this.getChangedIds((DisplayItem)object.next(), list, list2);
            }
        } else if (displayItem.isChangedByUser()) {
            String string = CustomizePerspectiveDialog.getCommandID(displayItem);
            if (displayItem.getState()) {
                list2.add(string);
            } else {
                list.add(string);
            }
        }
    }

    private boolean updateHiddenElements(DisplayItem displayItem, Collection collection) {
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.getChangedIds(displayItem, arrayList2, arrayList);
        for (Object e : arrayList) {
            if (!collection.contains(e)) continue;
            bl = true;
            collection.remove(e);
        }
        for (Object e : arrayList2) {
            if (collection.contains(e)) continue;
            bl = true;
            collection.add(e);
        }
        return bl;
    }

    protected void okPressed() {
        if (this.showShortcutTab()) {
            this.perspective.setNewWizardActionIds(this.getVisibleIDs(this.wizards));
            this.perspective.setPerspectiveActionIds(this.getVisibleIDs(this.perspectives));
            this.perspective.setShowViewActionIds(this.getVisibleIDs(this.views));
        }
        boolean bl = false;
        ArrayList<ActionSetDescriptor> arrayList = new ArrayList<ActionSetDescriptor>();
        ArrayList<ActionSetDescriptor> arrayList2 = new ArrayList<ActionSetDescriptor>();
        for (ActionSet actionSet : this.actionSets) {
            if (!actionSet.wasChanged()) continue;
            bl = true;
            if (actionSet.isActive()) {
                arrayList.add(actionSet.descriptor);
                continue;
            }
            arrayList2.add(actionSet.descriptor);
        }
        this.perspective.turnOnActionSets(arrayList.toArray(new IActionSetDescriptor[arrayList.size()]));
        this.perspective.turnOffActionSets(arrayList2.toArray(new IActionSetDescriptor[arrayList2.size()]));
        bl |= this.updateHiddenElements(this.menuItems, this.perspective.getHiddenMenuItems());
        if (bl |= this.updateHiddenElements(this.toolBarItems, this.perspective.getHiddenToolbarItems())) {
            this.perspective.updateActionBars();
        }
        super.okPressed();
    }

    public boolean close() {
        this.tooltipHeading.dispose();
        for (Resource resource : this.toDispose) {
            resource.dispose();
        }
        this.treeManager.dispose();
        this.customizeActionBars.dispose();
        return super.close();
    }

    private String removeShortcut(String string) {
        if (string == null) {
            return string;
        }
        int n = string.lastIndexOf(64);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if ((n = string.lastIndexOf(9)) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    protected boolean applyDialogFont() {
        return false;
    }

    protected boolean isResizable() {
        return true;
    }

    private void viewActionSet(DisplayItem displayItem) {
        this.viewActionSet(displayItem.getActionSet());
    }

    private void viewActionSet(ActionSet actionSet) {
        this.tabFolder.setSelection(this.actionSetTab);
        this.actionSetAvailabilityTable.reveal((Object)actionSet);
        this.setSelectionOn((Viewer)this.actionSetAvailabilityTable, actionSet);
        this.actionSetAvailabilityTable.getControl().setFocus();
    }

    private static int getLeafStates(TreeManager.TreeItem treeItem, ITreeContentProvider iTreeContentProvider, ViewerFilter viewerFilter) {
        Object[] objectArray = iTreeContentProvider.getChildren((Object)treeItem);
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < objectArray.length) {
            if (viewerFilter.select(null, null, objectArray[n])) {
                TreeManager.TreeItem treeItem2 = (TreeManager.TreeItem)objectArray[n];
                switch (CustomizePerspectiveDialog.getLeafStates(treeItem2, iTreeContentProvider, viewerFilter)) {
                    case 2: {
                        bl = true;
                        break;
                    }
                    case 1: {
                        bl2 = true;
                        bl = true;
                        break;
                    }
                    case 0: {
                        bl2 = true;
                    }
                }
                if (bl && bl2) {
                    return 1;
                }
            }
            ++n;
        }
        if (!bl && !bl2) {
            return treeItem.getState() ? 2 : 0;
        }
        return bl ? 2 : 0;
    }

    private static void setAllLeafs(DisplayItem displayItem, boolean bl, ITreeContentProvider iTreeContentProvider, ViewerFilter viewerFilter) {
        Object[] objectArray = iTreeContentProvider.getChildren((Object)displayItem);
        boolean bl2 = true;
        int n = 0;
        while (n < objectArray.length) {
            bl2 = false;
            if (viewerFilter.select(null, null, objectArray[n])) {
                DisplayItem displayItem2 = (DisplayItem)objectArray[n];
                CustomizePerspectiveDialog.setAllLeafs(displayItem2, bl, iTreeContentProvider, viewerFilter);
            }
            ++n;
        }
        if (bl2) {
            displayItem.setCheckState(bl);
        }
    }

    private class ActionSet {
        private ActionSetDescriptor descriptor;
        private List contributionItems;
        private boolean active;
        private boolean wasChanged = false;

        public ActionSet(ActionSetDescriptor actionSetDescriptor, boolean bl) {
            this.descriptor = actionSetDescriptor;
            this.active = bl;
            this.contributionItems = new ArrayList();
        }

        public void addItem(DisplayItem displayItem) {
            this.contributionItems.add(displayItem);
        }

        public String toString() {
            return this.descriptor.getLabel();
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean wasChanged() {
            return this.wasChanged;
        }

        public void setActive(boolean bl) {
            boolean bl2 = this.active;
            this.active = bl;
            if (!bl) {
                for (DisplayItem displayItem : this.contributionItems) {
                    displayItem.setCheckState(false);
                }
            }
            if (bl2 != bl) {
                CustomizePerspectiveDialog.this.actionSetAvailabilityChanged();
            }
            this.wasChanged = true;
        }
    }

    private static class ActionSetFilter
    extends ViewerFilter {
        private ActionSet actionSet;

        private ActionSetFilter() {
        }

        public void setActionSet(ActionSet actionSet) {
            this.actionSet = actionSet;
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (!(object2 instanceof DisplayItem)) {
                return false;
            }
            if (this.actionSet == null) {
                return false;
            }
            return CustomizePerspectiveDialog.includeInSetStructure((DisplayItem)object2, this.actionSet);
        }
    }

    private static final class ActionSetSelectionChangedListener
    implements ISelectionChangedListener {
        private final TreeViewer filterViewer;
        private final ActionSetFilter filter;

        public ActionSetSelectionChangedListener(TreeViewer treeViewer, ActionSetFilter actionSetFilter) {
            this.filterViewer = treeViewer;
            this.filter = actionSetFilter;
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            Object object = ((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
            this.filter.setActionSet((ActionSet)object);
            this.filterViewer.refresh();
            this.filterViewer.expandAll();
        }
    }

    private class Category
    extends TreeManager.TreeItem {
        private List contributionItems;

        public Category(String string) {
            TreeManager treeManager = CustomizePerspectiveDialog.this.treeManager;
            treeManager.getClass();
            super(treeManager, string == null ? null : DialogUtil.removeAccel(CustomizePerspectiveDialog.this.removeShortcut(string)));
            this.contributionItems = new ArrayList();
        }

        public List getContributionItems() {
            return this.contributionItems;
        }

        public void addShortcutItem(ShortcutItem shortcutItem) {
            this.contributionItems.add(shortcutItem);
            shortcutItem.setCategory(this);
        }

        public void update() {
            for (DisplayItem displayItem : this.contributionItems) {
                if (!displayItem.getState()) continue;
                this.setCheckState(true);
                return;
            }
            this.setCheckState(false);
        }

        public void setItemsState(boolean bl) {
            for (TreeManager.TreeItem treeItem : this.contributionItems) {
                treeItem.setCheckState(bl);
            }
            for (TreeManager.TreeItem treeItem : this.getChildren()) {
                ((Category)treeItem).setItemsState(bl);
            }
        }
    }

    private static class CategoryCheckProvider
    implements ICheckStateProvider {
        private CategoryCheckProvider() {
        }

        public boolean isChecked(Object object) {
            Category category = (Category)object;
            if (category.getChildren().isEmpty() && category.getContributionItems().isEmpty()) {
                return false;
            }
            for (TreeManager.TreeItem treeItem : category.getChildren()) {
                if (!this.isChecked(treeItem)) continue;
                return true;
            }
            for (TreeManager.TreeItem treeItem : category.getContributionItems()) {
                if (!treeItem.getState()) continue;
                return true;
            }
            return false;
        }

        public boolean isGrayed(Object object) {
            boolean bl = false;
            boolean bl2 = false;
            Category category = (Category)object;
            for (TreeManager.TreeItem treeItem : category.getChildren()) {
                if (this.isGrayed(treeItem)) {
                    return true;
                }
                if (this.isChecked(treeItem)) {
                    bl = true;
                } else {
                    bl2 = true;
                }
                if (!bl || !bl2) continue;
                return true;
            }
            for (TreeManager.TreeItem treeItem : category.getContributionItems()) {
                if (treeItem.getState()) {
                    bl = true;
                } else {
                    bl2 = true;
                }
                if (!bl || !bl2) continue;
                return true;
            }
            return false;
        }
    }

    public class CustomizeActionBars
    implements IActionBarConfigurer2,
    IActionBars2 {
        IWorkbenchWindowConfigurer configurer;
        private MenuManager menuManager = new MenuManager();
        private CoolBarManager coolBarManager = new CoolBarManager();
        private StatusLineManager statusLineManager = new StatusLineManager();

        public CustomizeActionBars(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
            this.configurer = iWorkbenchWindowConfigurer;
        }

        @Override
        public IWorkbenchWindowConfigurer getWindowConfigurer() {
            return this.configurer;
        }

        @Override
        public IMenuManager getMenuManager() {
            return this.menuManager;
        }

        @Override
        public IStatusLineManager getStatusLineManager() {
            return this.statusLineManager;
        }

        @Override
        public ICoolBarManager getCoolBarManager() {
            return this.coolBarManager;
        }

        @Override
        public IToolBarManager getToolBarManager() {
            return null;
        }

        @Override
        public void setGlobalActionHandler(String string, IAction iAction) {
        }

        @Override
        public void updateActionBars() {
        }

        @Override
        public void clearGlobalActionHandlers() {
        }

        @Override
        public IAction getGlobalActionHandler(String string) {
            return null;
        }

        @Override
        public void registerGlobalAction(IAction iAction) {
        }

        public void dispose() {
            this.coolBarManager.dispose();
            this.menuManager.dispose();
            this.statusLineManager.dispose();
        }

        @Override
        public final IServiceLocator getServiceLocator() {
            return this.configurer.getWindow();
        }

        @Override
        public IToolBarContributionItem createToolBarContributionItem(IToolBarManager iToolBarManager, String string) {
            return new ToolBarContributionItem2(iToolBarManager, string);
        }

        @Override
        public IToolBarManager createToolBarManager() {
            return new ToolBarManager();
        }
    }

    private class DisplayItem
    extends TreeManager.TreeItem {
        private IContributionItem item;
        private ActionSet actionSet;

        public DisplayItem(String string, IContributionItem iContributionItem) {
            TreeManager treeManager = CustomizePerspectiveDialog.this.treeManager;
            treeManager.getClass();
            super(treeManager, string == null ? null : DialogUtil.removeAccel(CustomizePerspectiveDialog.this.removeShortcut(string)));
            this.item = iContributionItem;
        }

        public void setActionSet(ActionSet actionSet) {
            this.actionSet = actionSet;
            if (actionSet != null) {
                actionSet.addItem(this);
            }
        }

        public ActionSet getActionSet() {
            return this.actionSet;
        }

        public IContributionItem getIContributionItem() {
            return this.item;
        }
    }

    private class DynamicContributionItem
    extends DisplayItem {
        private List preview;

        public DynamicContributionItem(IContributionItem iContributionItem) {
            super(WorkbenchMessages.HideItems_dynamicItemName, iContributionItem);
            this.preview = new ArrayList();
        }

        public void addCurrentItem(MenuItem menuItem) {
            this.preview.add(menuItem);
        }

        public List getCurrentItems() {
            return this.preview;
        }
    }

    private final class FilteredModelCheckListener
    implements TreeManager.CheckListener {
        private final ActionSetFilter filter;
        private final StructuredViewer viewer;

        private FilteredModelCheckListener(ActionSetFilter actionSetFilter, StructuredViewer structuredViewer) {
            this.filter = actionSetFilter;
            this.viewer = structuredViewer;
        }

        @Override
        public void checkChanged(TreeManager.TreeItem treeItem) {
            TreeManager.TreeItem treeItem2 = treeItem;
            boolean bl = false;
            while (treeItem2 != null) {
                boolean bl2 = bl = bl || this.filter.select(null, null, treeItem2);
                if (bl) {
                    this.viewer.update((Object)treeItem2, null);
                }
                treeItem2 = treeItem2.getParent();
            }
        }
    }

    private static class FilteredTreeCheckProvider
    implements ICheckStateProvider {
        private ITreeContentProvider contentProvider;
        private ViewerFilter filter;

        public FilteredTreeCheckProvider(ITreeContentProvider iTreeContentProvider, ViewerFilter viewerFilter) {
            this.contentProvider = iTreeContentProvider;
            this.filter = viewerFilter;
        }

        public boolean isChecked(Object object) {
            TreeManager.TreeItem treeItem = (TreeManager.TreeItem)object;
            return CustomizePerspectiveDialog.getLeafStates(treeItem, this.contentProvider, this.filter) != 0;
        }

        public boolean isGrayed(Object object) {
            TreeManager.TreeItem treeItem = (TreeManager.TreeItem)object;
            return CustomizePerspectiveDialog.getLeafStates(treeItem, this.contentProvider, this.filter) == 1;
        }
    }

    private static class FilteredViewerCheckListener
    implements ICheckStateListener {
        private ITreeContentProvider contentProvider;
        private ViewerFilter filter;

        public FilteredViewerCheckListener(ITreeContentProvider iTreeContentProvider, ViewerFilter viewerFilter) {
            this.contentProvider = iTreeContentProvider;
            this.filter = viewerFilter;
        }

        public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
            CustomizePerspectiveDialog.setAllLeafs((DisplayItem)checkStateChangedEvent.getElement(), checkStateChangedEvent.getChecked(), this.contentProvider, this.filter);
        }
    }

    private class GrayOutUnavailableLabelProvider
    extends TreeManager.TreeItemLabelProvider
    implements IColorProvider {
        private Display display;
        private ViewerFilter filter;

        public GrayOutUnavailableLabelProvider(Display display, ViewerFilter viewerFilter) {
            this.display = display;
            this.filter = viewerFilter;
        }

        public Color getBackground(Object object) {
            return null;
        }

        public Color getForeground(Object object) {
            if (!CustomizePerspectiveDialog.isEffectivelyAvailable((DisplayItem)object, this.filter)) {
                return this.display.getSystemColor(15);
            }
            return null;
        }

        @Override
        public Image getImage(Object object) {
            DisplayItem displayItem;
            Image image = super.getImage(object);
            if (object instanceof DisplayItem && image != null && !CustomizePerspectiveDialog.isEffectivelyAvailable(displayItem = (DisplayItem)object, this.filter)) {
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)image);
                ImageDescriptor imageDescriptor2 = ImageDescriptor.createWithFlags((ImageDescriptor)imageDescriptor, (int)1);
                Image image2 = imageDescriptor2.createImage();
                CustomizePerspectiveDialog.this.toDispose.add(image2);
                return image2;
            }
            return image;
        }
    }

    private class ItemDetailToolTip
    extends NameAndDescriptionToolTip {
        private Tree tree;
        private boolean showActionSet;
        private boolean showKeyBindings;
        private ViewerFilter filter;
        private TreeViewer v;

        private ItemDetailToolTip(TreeViewer treeViewer, Tree tree, boolean bl, boolean bl2, ViewerFilter viewerFilter) {
            super((Control)tree, 2);
            this.tree = tree;
            this.v = treeViewer;
            this.showActionSet = bl;
            this.showKeyBindings = bl2;
            this.filter = viewerFilter;
            this.setHideOnMouseDown(false);
        }

        public Point getLocation(Point point, Event event) {
            ViewerCell viewerCell = this.v.getCell(new Point(event.x, event.y));
            if (viewerCell != null) {
                return this.tree.toDisplay(event.x, viewerCell.getBounds().y + viewerCell.getBounds().height);
            }
            return super.getLocation(point, event);
        }

        protected Object getToolTipArea(Event event) {
            return this.v.getCell(new Point(event.x, event.y));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void addContent(Composite composite, Object object) {
            Object object2;
            Object object3;
            Object object4;
            StringBuffer stringBuffer;
            Object object5;
            final DisplayItem displayItem = (DisplayItem)object;
            if (this.showActionSet) {
                object5 = null;
                stringBuffer = null;
                if (CustomizePerspectiveDialog.isEffectivelyAvailable(displayItem, this.filter)) {
                    if (displayItem.actionSet != null) {
                        object4 = displayItem.getActionSet().descriptor.getLabel();
                        object5 = NLS.bind((String)WorkbenchMessages.HideItems_itemInActionSet, (Object)object4);
                    }
                } else {
                    stringBuffer = CustomizePerspectiveDialog.this.warningImageDescriptor.createImage();
                    if (displayItem.getChildren().isEmpty()) {
                        object4 = displayItem.getActionSet().descriptor.getLabel();
                        object5 = NLS.bind((String)WorkbenchMessages.HideItems_itemInUnavailableActionSet, (Object)object4);
                    } else {
                        object4 = new LinkedHashSet();
                        CustomizePerspectiveDialog.collectDescendantCommandGroups((Collection)object4, displayItem, this.filter);
                        if (object4.size() == 1) {
                            object3 = (ActionSet)object4.iterator().next();
                            object5 = NLS.bind((String)WorkbenchMessages.HideItems_unavailableChildCommandGroup, (Object)((ActionSet)object3).descriptor.getId(), (Object)((ActionSet)object3).descriptor.getLabel());
                        } else {
                            object3 = null;
                            for (ActionSet actionSet : object4) {
                                object2 = MessageFormat.format("<a href=\"{0}\">{1}</a>", actionSet.descriptor.getId(), actionSet.descriptor.getLabel());
                                object3 = object3 == null ? object2 : Util.createList((String)object3, (String)object2);
                            }
                            object3 = NLS.bind((String)"{0}{1}", (Object[])new Object[]{NEW_LINE, object3});
                            object5 = NLS.bind((String)WorkbenchMessages.HideItems_unavailableChildCommandGroups, (Object)object3);
                        }
                    }
                }
                if (object5 != null) {
                    object4 = this.createEntryWithLink(composite, (Image)stringBuffer, (String)object5);
                    object4.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                            this.widgetSelected(selectionEvent);
                        }

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            ActionSet actionSet = (ActionSet)CustomizePerspectiveDialog.this.idToActionSet.get(selectionEvent.text);
                            if (actionSet == null) {
                                ItemDetailToolTip.this.hide();
                                CustomizePerspectiveDialog.this.viewActionSet(displayItem);
                            } else {
                                ItemDetailToolTip.this.hide();
                                CustomizePerspectiveDialog.this.viewActionSet(actionSet);
                            }
                        }
                    });
                }
            }
            if (this.showKeyBindings && CustomizePerspectiveDialog.getCommandID(displayItem) != null && (stringBuffer = (object5 = (ICommandService)CustomizePerspectiveDialog.this.window.getService(ICommandService.class)).getCommand(CustomizePerspectiveDialog.getCommandID(displayItem))) != null && stringBuffer.isDefined()) {
                void var8_14;
                Link link;
                boolean bl;
                object4 = CustomizePerspectiveDialog.this.getKeyBindings(displayItem);
                object3 = CustomizePerspectiveDialog.this.keyBindingsAsString(object4);
                Object var8_9 = null;
                boolean bl2 = bl = displayItem.getActionSet() == null || displayItem.getActionSet().isActive();
                if (((Binding[])object4).length > 0) {
                    if (bl) {
                        String string = NLS.bind((String)WorkbenchMessages.HideItems_keyBindings, (Object)object3);
                    } else {
                        String string = NLS.bind((String)WorkbenchMessages.HideItems_keyBindingsActionSetUnavailable, (Object)object3);
                    }
                } else if (bl) {
                    String string = WorkbenchMessages.HideItems_noKeyBindings;
                } else {
                    String string = WorkbenchMessages.HideItems_noKeyBindingsActionSetUnavailable;
                }
                if (((Binding[])object4).length == 0) {
                    link = new HashMap();
                    if (displayItem instanceof ShortcutItem) {
                        if (CustomizePerspectiveDialog.isNewWizard(displayItem)) {
                            link.put("newWizardId", CustomizePerspectiveDialog.getParamID(displayItem));
                        } else if (CustomizePerspectiveDialog.isShowPerspective(displayItem)) {
                            link.put("org.eclipse.ui.perspectives.showPerspective.perspectiveId", CustomizePerspectiveDialog.getParamID(displayItem));
                        } else if (CustomizePerspectiveDialog.isShowView(displayItem)) {
                            link.put("org.eclipse.ui.views.showView.viewId", CustomizePerspectiveDialog.getParamID(displayItem));
                        }
                    }
                    ParameterizedCommand parameterizedCommand = ParameterizedCommand.generateCommand((Command)stringBuffer, link);
                    object2 = parameterizedCommand;
                } else {
                    object2 = object4[0];
                }
                link = this.createEntryWithLink(composite, null, (String)var8_14);
                link.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                        this.widgetDefaultSelected(selectionEvent);
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn(CustomizePerspectiveDialog.this.getShell(), CustomizePerspectiveDialog.KEYS_PREFERENCE_PAGE_ID, new String[0], object2);
                        ItemDetailToolTip.this.hide();
                        preferenceDialog.open();
                    }
                });
            }
            if (displayItem instanceof DynamicContributionItem) {
                object5 = (DynamicContributionItem)displayItem;
                stringBuffer = new StringBuffer();
                object4 = ((DynamicContributionItem)object5).getCurrentItems();
                if (object4.size() > 0) {
                    stringBuffer.append(WorkbenchMessages.HideItems_dynamicItemList);
                    for (MenuItem menuItem : object4) {
                        stringBuffer.append(NEW_LINE).append("- ").append(menuItem.getText());
                    }
                } else {
                    stringBuffer.append(WorkbenchMessages.HideItems_dynamicItemEmptyList);
                }
                this.createEntry(composite, null, stringBuffer.toString());
            }
        }

        @Override
        protected Object getModelElement(Event event) {
            TreeItem treeItem = this.tree.getItem(new Point(event.x, event.y));
            if (treeItem == null) {
                return null;
            }
            return treeItem.getData();
        }
    }

    private abstract class NameAndDescriptionToolTip
    extends ToolTip {
        public NameAndDescriptionToolTip(Control control, int n) {
            super(control, n, false);
        }

        protected abstract Object getModelElement(Event var1);

        protected boolean shouldCreateToolTip(Event event) {
            return super.shouldCreateToolTip(event) && this.getModelElement(event) != null;
        }

        protected Composite createToolTipContentArea(Event event, Composite composite) {
            Object object = this.getModelElement(event);
            Image image = null;
            String string = null;
            if (object instanceof DisplayItem) {
                image = ((DisplayItem)object).getImage();
                string = ((DisplayItem)object).getLabel();
            } else if (object instanceof ActionSet) {
                string = ((ActionSet)object).descriptor.getLabel();
            }
            Composite composite2 = new Composite(composite, 0);
            composite2.setBackground(composite.getDisplay().getSystemColor(29));
            composite2.setLayout((Layout)new GridLayout(2, false));
            Label label = this.createEntry(composite2, image, string);
            label.setFont(CustomizePerspectiveDialog.this.tooltipHeading);
            GridDataFactory.createFrom((GridData)((GridData)label.getLayoutData())).hint(-1, -1).minSize(160, 1).applyTo((Control)label);
            String string2 = CustomizePerspectiveDialog.getDescription(object);
            if (string2 != null) {
                this.createEntry(composite2, null, string2);
            }
            this.addContent(composite2, object);
            return composite2;
        }

        protected Label createEntry(Composite composite, Image image, String string) {
            Label label;
            if (image != null) {
                label = new Label(composite, 0);
                label.setImage(image);
                label.setBackground(composite.getDisplay().getSystemColor(29));
                label.setData((Object)new GridData());
            }
            label = new Label(composite, 64);
            if (image == null) {
                GridDataFactory.generate((Control)label, (int)2, (int)1);
            } else {
                GridDataFactory.generate((Control)label, (int)1, (int)1);
            }
            label.setText(string);
            label.setBackground(composite.getDisplay().getSystemColor(29));
            return label;
        }

        protected Link createEntryWithLink(Composite composite, Image image, String string) {
            Label label;
            if (image != null) {
                label = new Label(composite, 0);
                label.setImage(image);
                label.setBackground(composite.getDisplay().getSystemColor(29));
                label.setData((Object)new GridData());
            }
            label = new Link(composite, 64);
            if (image == null) {
                GridDataFactory.generate((Control)label, (int)2, (int)1);
            }
            label.setText(string);
            label.setBackground(composite.getDisplay().getSystemColor(29));
            return label;
        }

        protected void addContent(Composite composite, Object object) {
        }
    }

    private class ShortcutItem
    extends DisplayItem {
        private String description;
        private Category category;
        private Object descriptor;

        public ShortcutItem(String string, IWizardDescriptor iWizardDescriptor) {
            super(string, (IContributionItem)CustomizePerspectiveDialog.getIContributionItem(iWizardDescriptor, CustomizePerspectiveDialog.this.window));
            this.descriptor = iWizardDescriptor;
        }

        public ShortcutItem(String string, IPerspectiveDescriptor iPerspectiveDescriptor) {
            super(string, (IContributionItem)CustomizePerspectiveDialog.getIContributionItem(iPerspectiveDescriptor, CustomizePerspectiveDialog.this.window));
            this.descriptor = iPerspectiveDescriptor;
        }

        public ShortcutItem(String string, IViewDescriptor iViewDescriptor) {
            super(string, (IContributionItem)CustomizePerspectiveDialog.getIContributionItem(CustomizePerspectiveDialog.this.window));
            this.descriptor = iViewDescriptor;
        }

        public Object getDescriptor() {
            return this.descriptor;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public void setCategory(Category category) {
            this.category = category;
        }

        public Category getCategory() {
            return this.category;
        }
    }

    private class ShortcutLabelProvider
    extends TreeManager.TreeItemLabelProvider
    implements ITableLabelProvider {
        private ShortcutLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 0) {
                return this.getImage(object);
            }
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (n == 1) {
                return ((ShortcutItem)object).getDescription();
            }
            return this.getText(object);
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
        }

        public boolean isLabelProperty(Object object, String string) {
            return false;
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
        }
    }

    private static final class ShowUsedActionSetsFilter
    extends ViewerFilter {
        private DisplayItem rootItem;

        public ShowUsedActionSetsFilter(DisplayItem displayItem) {
            this.rootItem = displayItem;
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            return CustomizePerspectiveDialog.includeInSetStructure(this.rootItem, (ActionSet)object2);
        }
    }

    private class TableToolTip
    extends NameAndDescriptionToolTip {
        private Table table;

        public TableToolTip(Table table) {
            super((Control)table, 1);
            this.table = table;
        }

        @Override
        protected Object getModelElement(Event event) {
            TableItem tableItem = this.table.getItem(new Point(event.x, event.y));
            if (tableItem == null) {
                return null;
            }
            return tableItem.getData();
        }
    }

    private class UnavailableContributionItemCheckListener
    implements ICheckStateListener {
        private CheckboxTreeViewer viewer;
        private ICheckStateListener originalListener;

        public UnavailableContributionItemCheckListener(CheckboxTreeViewer checkboxTreeViewer, ICheckStateListener iCheckStateListener) {
            this.viewer = checkboxTreeViewer;
            this.originalListener = iCheckStateListener;
        }

        public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
            ViewerFilter[] viewerFilterArray;
            DisplayItem displayItem = (DisplayItem)checkStateChangedEvent.getElement();
            boolean bl = CustomizePerspectiveDialog.isEffectivelyAvailable(displayItem, (viewerFilterArray = this.viewer.getFilters()).length > 0 ? viewerFilterArray[0] : null);
            if (bl) {
                this.originalListener.checkStateChanged(checkStateChangedEvent);
                return;
            }
            boolean bl2 = CustomizePerspectiveDialog.isAvailable(displayItem);
            this.viewer.update(checkStateChangedEvent.getElement(), null);
            if (bl2) {
                if (this.viewer.getExpandedState((Object)displayItem)) {
                    MessageBox messageBox = new MessageBox(this.viewer.getControl().getShell(), 268435496);
                    messageBox.setText(WorkbenchMessages.HideItemsCannotMakeVisible_dialogTitle);
                    messageBox.setMessage(NLS.bind((String)WorkbenchMessages.HideItemsCannotMakeVisible_unavailableChildrenText, (Object)displayItem.getLabel()));
                    messageBox.open();
                } else {
                    MessageBox messageBox = new MessageBox(this.viewer.getControl().getShell(), 268435496);
                    messageBox.setText(WorkbenchMessages.HideItemsCannotMakeVisible_dialogTitle);
                    messageBox.setMessage(NLS.bind((String)WorkbenchMessages.HideItemsCannotMakeVisible_unavailableChildrenText, (Object)displayItem.getLabel()));
                    messageBox.open();
                }
            } else {
                MessageBox messageBox = new MessageBox(this.viewer.getControl().getShell(), 268435656);
                messageBox.setText(WorkbenchMessages.HideItemsCannotMakeVisible_dialogTitle);
                String string = NLS.bind((String)WorkbenchMessages.HideItemsCannotMakeVisible_unavailableCommandGroupText, (Object)displayItem.getLabel(), (Object)displayItem.getActionSet());
                String string2 = NLS.bind((String)"{0}{1}{1}{2}", (Object[])new Object[]{string, NEW_LINE, WorkbenchMessages.HideItemsCannotMakeVisible_switchToCommandGroupTab});
                messageBox.setMessage(string2);
                if (messageBox.open() == 64) {
                    CustomizePerspectiveDialog.this.viewActionSet(displayItem);
                }
            }
        }
    }
}

