/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.FileExtensionDialog;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ContentTypesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ListViewer fileAssociationViewer;
    private Button removeButton;
    private TreeViewer contentTypesViewer;
    private Button addButton;
    private Button editButton;
    private Text charsetField;
    private Button setButton;
    private IWorkbench workbench;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        PreferenceLinkArea preferenceLinkArea = new PreferenceLinkArea(composite2, 0, "org.eclipse.ui.preferencePages.FileEditors", WorkbenchMessages.ContentTypes_FileEditorsRelatedLink, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData gridData = new GridData(768);
        preferenceLinkArea.getControl().setLayoutData((Object)gridData);
        this.createContentTypesTree(composite2);
        this.createFileAssociations(composite2);
        this.createCharset(composite2);
        this.workbench.getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.content_types_preference_page_context");
        this.applyDialogFont(composite2);
        return composite2;
    }

    private void createCharset(final Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setFont(composite.getFont());
        label.setText(WorkbenchMessages.ContentTypes_characterSetLabel);
        this.charsetField = new Text(composite2, 2052);
        this.charsetField.setFont(composite.getFont());
        this.charsetField.setEnabled(false);
        GridData gridData2 = new GridData(768);
        this.charsetField.setLayoutData((Object)gridData2);
        this.setButton = new Button(composite2, 8);
        this.setButton.setFont(composite.getFont());
        this.setButton.setText(WorkbenchMessages.ContentTypes_characterSetUpdateLabel);
        this.setButton.setEnabled(false);
        this.setButtonLayoutData(this.setButton);
        this.setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    String string = ContentTypesPreferencePage.this.charsetField.getText().trim();
                    if (string.length() == 0) {
                        string = null;
                    }
                    ContentTypesPreferencePage.this.getSelectedContentType().setDefaultCharset(string);
                    ContentTypesPreferencePage.this.setButton.setEnabled(false);
                }
                catch (CoreException coreException) {
                    StatusUtil.handleStatus(coreException.getStatus(), 2, composite.getShell());
                }
            }
        });
        this.charsetField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                IContentType iContentType = ContentTypesPreferencePage.this.getSelectedContentType();
                String string = iContentType.getDefaultCharset();
                if (string == null) {
                    string = "";
                }
                ContentTypesPreferencePage.this.setButton.setEnabled(!string.equals(ContentTypesPreferencePage.this.charsetField.getText()) && ContentTypesPreferencePage.this.getErrorMessage() == null);
            }
        });
        this.charsetField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = null;
                String string2 = ContentTypesPreferencePage.this.charsetField.getText();
                try {
                    if (string2.length() != 0 && !Charset.isSupported(string2)) {
                        string = WorkbenchMessages.ContentTypes_unsupportedEncoding;
                    }
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    string = WorkbenchMessages.ContentTypes_unsupportedEncoding;
                }
                ContentTypesPreferencePage.this.setErrorMessage(string);
            }
        });
    }

    private void createFileAssociations(final Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(WorkbenchMessages.ContentTypes_fileAssociationsLabel);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fileAssociationViewer = new ListViewer(composite);
        this.fileAssociationViewer.setComparator((ViewerComparator)new FileSpecComparator());
        this.fileAssociationViewer.getControl().setFont(composite.getFont());
        this.fileAssociationViewer.setContentProvider((IContentProvider)new FileSpecContentProvider());
        this.fileAssociationViewer.setLabelProvider((IBaseLabelProvider)new FileSpecLabelProvider());
        label = new GridData(1808);
        label.horizontalSpan = 1;
        this.fileAssociationViewer.getControl().setLayoutData((Object)label);
        this.fileAssociationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                if (iStructuredSelection.isEmpty()) {
                    ContentTypesPreferencePage.this.editButton.setEnabled(false);
                    ContentTypesPreferencePage.this.removeButton.setEnabled(false);
                    return;
                }
                boolean bl = true;
                List list = iStructuredSelection.toList();
                for (Spec spec : list) {
                    if (!spec.isPredefined) continue;
                    bl = false;
                }
                ContentTypesPreferencePage.this.editButton.setEnabled(bl && iStructuredSelection.size() == 1);
                ContentTypesPreferencePage.this.removeButton.setEnabled(bl);
            }
        });
        label = new Composite(composite, 0);
        gridData = new GridLayout(1, false);
        gridData.marginWidth = 0;
        gridData.marginHeight = 0;
        label.setLayout((Layout)gridData);
        GridData gridData2 = new GridData(2);
        label.setLayoutData((Object)gridData2);
        this.addButton = new Button((Composite)label, 8);
        this.addButton.setFont(composite.getFont());
        this.addButton.setText(WorkbenchMessages.ContentTypes_fileAssociationsAddLabel);
        this.addButton.setEnabled(false);
        this.setButtonLayoutData(this.addButton);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                block7: {
                    Shell shell = composite.getShell();
                    IContentType iContentType = ContentTypesPreferencePage.this.getSelectedContentType();
                    FileExtensionDialog fileExtensionDialog = new FileExtensionDialog(shell, WorkbenchMessages.ContentTypes_addDialog_title, "org.eclipse.ui.file_extension_dialog_context", WorkbenchMessages.ContentTypes_addDialog_messageHeader, WorkbenchMessages.ContentTypes_addDialog_message, WorkbenchMessages.ContentTypes_addDialog_label);
                    if (fileExtensionDialog.open() == 0) {
                        String string = fileExtensionDialog.getName();
                        String string2 = fileExtensionDialog.getExtension();
                        try {
                            try {
                                if (string.equals("*")) {
                                    iContentType.addFileSpec(string2, 8);
                                    break block7;
                                }
                                iContentType.addFileSpec(String.valueOf(string) + (string2.length() > 0 ? String.valueOf('.') + string2 : ""), 4);
                            }
                            catch (CoreException coreException) {
                                StatusUtil.handleStatus(coreException.getStatus(), 2, shell);
                                WorkbenchPlugin.log(coreException);
                                ContentTypesPreferencePage.this.fileAssociationViewer.refresh(false);
                            }
                        }
                        finally {
                            ContentTypesPreferencePage.this.fileAssociationViewer.refresh(false);
                        }
                    }
                }
            }
        });
        this.editButton = new Button((Composite)label, 8);
        this.editButton.setFont(composite.getFont());
        this.editButton.setText(WorkbenchMessages.ContentTypes_fileAssociationsEditLabel);
        this.editButton.setEnabled(false);
        this.setButtonLayoutData(this.editButton);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                block12: {
                    Shell shell = composite.getShell();
                    IContentType iContentType = ContentTypesPreferencePage.this.getSelectedContentType();
                    Spec spec = ContentTypesPreferencePage.this.getSelectedSpecs()[0];
                    FileExtensionDialog fileExtensionDialog = new FileExtensionDialog(shell, WorkbenchMessages.ContentTypes_editDialog_title, "org.eclipse.ui.file_extension_dialog_context", WorkbenchMessages.ContentTypes_editDialog_messageHeader, WorkbenchMessages.ContentTypes_editDialog_message, WorkbenchMessages.ContentTypes_editDialog_label);
                    if (spec.name == null) {
                        fileExtensionDialog.setInitialValue("*." + spec.ext);
                    } else {
                        fileExtensionDialog.setInitialValue(spec.name);
                    }
                    if (fileExtensionDialog.open() == 0) {
                        String string = fileExtensionDialog.getName();
                        String string2 = fileExtensionDialog.getExtension();
                        try {
                            try {
                                if (spec.name != null) {
                                    iContentType.removeFileSpec(spec.name, 4);
                                } else if (spec.ext != null) {
                                    iContentType.removeFileSpec(spec.ext, 8);
                                }
                                if (string.equals("*")) {
                                    iContentType.addFileSpec(string2, 8);
                                    break block12;
                                }
                                iContentType.addFileSpec(String.valueOf(string) + (string2.length() > 0 ? String.valueOf('.') + string2 : ""), 4);
                            }
                            catch (CoreException coreException) {
                                StatusUtil.handleStatus(coreException.getStatus(), 2, shell);
                                WorkbenchPlugin.log(coreException);
                                ContentTypesPreferencePage.this.fileAssociationViewer.refresh(false);
                            }
                        }
                        finally {
                            ContentTypesPreferencePage.this.fileAssociationViewer.refresh(false);
                        }
                    }
                }
            }
        });
        this.removeButton = new Button((Composite)label, 8);
        this.removeButton.setEnabled(false);
        this.removeButton.setText(WorkbenchMessages.ContentTypes_fileAssociationsRemoveLabel);
        this.setButtonLayoutData(this.removeButton);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IContentType iContentType = ContentTypesPreferencePage.this.getSelectedContentType();
                Spec[] specArray = ContentTypesPreferencePage.this.getSelectedSpecs();
                MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, new IStatus[0], WorkbenchMessages.ContentTypes_errorDialogMessage, null);
                int n = 0;
                while (n < specArray.length) {
                    Spec spec = specArray[n];
                    try {
                        if (spec.name != null) {
                            iContentType.removeFileSpec(spec.name, 4);
                        } else if (spec.ext != null) {
                            iContentType.removeFileSpec(spec.ext, 8);
                        }
                    }
                    catch (CoreException coreException) {
                        multiStatus.add(coreException.getStatus());
                    }
                    ++n;
                }
                if (!multiStatus.isOK()) {
                    StatusUtil.handleStatus((IStatus)multiStatus, 2, composite.getShell());
                }
                ContentTypesPreferencePage.this.fileAssociationViewer.refresh(false);
            }
        });
    }

    protected Spec[] getSelectedSpecs() {
        List list = ((IStructuredSelection)this.fileAssociationViewer.getSelection()).toList();
        return list.toArray(new Spec[list.size()]);
    }

    protected IContentType getSelectedContentType() {
        return (IContentType)((IStructuredSelection)this.contentTypesViewer.getSelection()).getFirstElement();
    }

    private void createContentTypesTree(Composite composite) {
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(WorkbenchMessages.ContentTypes_contentTypesLabel);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.contentTypesViewer = new TreeViewer(composite, 2820);
        this.contentTypesViewer.getControl().setFont(composite.getFont());
        this.contentTypesViewer.setContentProvider((IContentProvider)new ContentTypesContentProvider());
        this.contentTypesViewer.setLabelProvider((IBaseLabelProvider)new ContentTypesLabelProvider());
        this.contentTypesViewer.setComparator(new ViewerComparator());
        this.contentTypesViewer.setInput((Object)Platform.getContentTypeManager());
        label = new GridData(1808);
        label.horizontalSpan = 2;
        this.contentTypesViewer.getControl().setLayoutData((Object)label);
        this.contentTypesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IContentType iContentType = (IContentType)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                ContentTypesPreferencePage.this.fileAssociationViewer.setInput((Object)iContentType);
                if (iContentType != null) {
                    String string = iContentType.getDefaultCharset();
                    if (string == null) {
                        string = "";
                    }
                    ContentTypesPreferencePage.this.charsetField.setText(string);
                } else {
                    ContentTypesPreferencePage.this.charsetField.setText("");
                }
                ContentTypesPreferencePage.this.charsetField.setEnabled(iContentType != null);
                ContentTypesPreferencePage.this.addButton.setEnabled(iContentType != null);
                ContentTypesPreferencePage.this.setButton.setEnabled(false);
            }
        });
    }

    @Override
    public void init(IWorkbench iWorkbench) {
        this.workbench = iWorkbench;
        this.noDefaultAndApplyButton();
    }

    private class ContentTypesContentProvider
    implements ITreeContentProvider {
        private IContentTypeManager manager;

        private ContentTypesContentProvider() {
        }

        public Object[] getChildren(Object object) {
            ArrayList<IContentType> arrayList = new ArrayList<IContentType>();
            IContentType iContentType = (IContentType)object;
            IContentType[] iContentTypeArray = this.manager.getAllContentTypes();
            int n = 0;
            while (n < iContentTypeArray.length) {
                IContentType iContentType2 = iContentTypeArray[n];
                if (Util.equals(iContentType2.getBaseType(), iContentType)) {
                    arrayList.add(iContentType2);
                }
                ++n;
            }
            return arrayList.toArray();
        }

        public Object getParent(Object object) {
            IContentType iContentType = (IContentType)object;
            return iContentType.getBaseType();
        }

        public boolean hasChildren(Object object) {
            return this.getChildren(object).length > 0;
        }

        public Object[] getElements(Object object) {
            return this.getChildren(null);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            this.manager = (IContentTypeManager)object2;
        }
    }

    private class ContentTypesLabelProvider
    extends LabelProvider {
        private ContentTypesLabelProvider() {
        }

        public String getText(Object object) {
            IContentType iContentType = (IContentType)object;
            return iContentType.getName();
        }
    }

    private class FileSpecComparator
    extends ViewerComparator {
        private FileSpecComparator() {
        }

        public int category(Object object) {
            return ((Spec)object).sortValue;
        }
    }

    private class FileSpecContentProvider
    implements IStructuredContentProvider {
        private FileSpecContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object[] getElements(Object object) {
            IContentType iContentType = (IContentType)object;
            String[] stringArray = iContentType.getFileSpecs(9);
            String[] stringArray2 = iContentType.getFileSpecs(5);
            String[] stringArray3 = iContentType.getFileSpecs(10);
            String[] stringArray4 = iContentType.getFileSpecs(6);
            return this.createSpecs(stringArray, stringArray2, stringArray3, stringArray4);
        }

        private Object[] createSpecs(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
            Spec spec;
            ArrayList<Spec> arrayList = new ArrayList<Spec>();
            int n = 0;
            while (n < stringArray2.length) {
                spec = new Spec();
                spec.name = stringArray2[n];
                spec.isPredefined = false;
                spec.sortValue = 0;
                arrayList.add(spec);
                ++n;
            }
            n = 0;
            while (n < stringArray4.length) {
                spec = new Spec();
                spec.name = stringArray4[n];
                spec.isPredefined = true;
                spec.sortValue = 1;
                arrayList.add(spec);
                ++n;
            }
            n = 0;
            while (n < stringArray.length) {
                spec = new Spec();
                spec.ext = stringArray[n];
                spec.isPredefined = false;
                spec.sortValue = 2;
                arrayList.add(spec);
                ++n;
            }
            n = 0;
            while (n < stringArray3.length) {
                spec = new Spec();
                spec.ext = stringArray3[n];
                spec.isPredefined = true;
                spec.sortValue = 3;
                arrayList.add(spec);
                ++n;
            }
            return arrayList.toArray();
        }
    }

    private class FileSpecLabelProvider
    extends LabelProvider {
        private FileSpecLabelProvider() {
        }

        public String getText(Object object) {
            String string = super.getText(object);
            return TextProcessor.process((String)string, (String)"*.");
        }
    }

    private class Spec {
        String name;
        String ext;
        boolean isPredefined;
        int sortValue;

        private Spec() {
        }

        public String toString() {
            String string = this.name != null ? this.name : "*." + this.ext;
            if (this.isPredefined) {
                string = NLS.bind((String)WorkbenchMessages.ContentTypes_lockedFormat, (Object)string);
            }
            return string;
        }
    }
}

