/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.dialogs.IWorkingSetNewWizard;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkingSet;
import org.eclipse.ui.internal.registry.WorkingSetRegistry;

public abstract class AbstractWorkingSetDialog
extends SelectionDialog
implements IWorkingSetSelectionDialog {
    private static final int ID_NEW = 1025;
    private static final int ID_DETAILS = 1026;
    private static final int ID_REMOVE = 1027;
    private static final int ID_SELECTALL = 1028;
    private static final int ID_DESELECTALL = 1029;
    private Button newButton;
    private Button detailsButton;
    private Button removeButton;
    private Button selectAllButton;
    private Button deselectAllButton;
    private IWorkingSet[] result;
    private List addedWorkingSets;
    private List removedWorkingSets;
    private Map editedWorkingSets;
    private List removedMRUWorkingSets;
    private Set workingSetIds;
    private boolean canEdit;

    protected AbstractWorkingSetDialog(Shell shell, String[] stringArray, boolean bl) {
        super(shell);
        if (stringArray != null) {
            this.workingSetIds = new HashSet();
            int n = 0;
            while (n < stringArray.length) {
                this.workingSetIds.add(stringArray[n]);
                ++n;
            }
        }
        this.canEdit = bl;
    }

    protected Set getSupportedWorkingSetIds() {
        return this.workingSetIds;
    }

    protected void addModifyButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 131072);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1026);
        composite2.setLayoutData((Object)gridData);
        this.newButton = this.createButton(composite2, 1025, WorkbenchMessages.WorkingSetSelectionDialog_newButton_label, false);
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractWorkingSetDialog.this.createWorkingSet();
            }
        });
        if (this.canEdit) {
            this.detailsButton = this.createButton(composite2, 1026, WorkbenchMessages.WorkingSetSelectionDialog_detailsButton_label, false);
            this.detailsButton.setEnabled(false);
            this.detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AbstractWorkingSetDialog.this.editSelectedWorkingSet();
                }
            });
            this.removeButton = this.createButton(composite2, 1027, WorkbenchMessages.WorkingSetSelectionDialog_removeButton_label, false);
            this.removeButton.setEnabled(false);
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    AbstractWorkingSetDialog.this.removeSelectedWorkingSets();
                }
            });
        }
        gridLayout.numColumns = 1;
    }

    protected void addSelectionButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(32);
        composite2.setLayoutData((Object)gridData);
        this.selectAllButton = this.createButton(composite2, 1028, WorkbenchMessages.SelectionDialog_selectLabel, false);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractWorkingSetDialog.this.selectAllSets();
            }
        });
        this.deselectAllButton = this.createButton(composite2, 1029, WorkbenchMessages.SelectionDialog_deselectLabel, false);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractWorkingSetDialog.this.deselectAllSets();
            }
        });
    }

    protected abstract void selectAllSets();

    protected abstract void deselectAllSets();

    void editSelectedWorkingSet() {
        boolean bl;
        IWorkingSetManager iWorkingSetManager = WorkbenchPlugin.getDefault().getWorkingSetManager();
        IWorkingSet iWorkingSet = (IWorkingSet)this.getSelectedWorkingSets().get(0);
        IWorkingSetEditWizard iWorkingSetEditWizard = iWorkingSetManager.createWorkingSetEditWizard(iWorkingSet);
        WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)iWorkingSetEditWizard);
        IWorkingSet iWorkingSet2 = (IWorkingSet)this.editedWorkingSets.get(iWorkingSet);
        boolean bl2 = bl = iWorkingSet2 == null;
        if (bl) {
            iWorkingSet2 = new WorkingSet(iWorkingSet.getName(), iWorkingSet.getLabel(), iWorkingSet.getElements());
        } else {
            this.editedWorkingSets.remove(iWorkingSet);
        }
        wizardDialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)wizardDialog.getShell(), "org.eclipse.ui.working_set_edit_wizard_context");
        if (wizardDialog.open() == 0) {
            iWorkingSet = iWorkingSetEditWizard.getSelection();
            this.availableWorkingSetsChanged();
            this.updateButtonAvailability();
        }
        this.editedWorkingSets.put(iWorkingSet, iWorkingSet2);
    }

    void createWorkingSet() {
        IWorkingSetManager iWorkingSetManager = WorkbenchPlugin.getDefault().getWorkingSetManager();
        String[] stringArray = null;
        if (this.workingSetIds != null) {
            stringArray = this.workingSetIds.toArray(new String[this.workingSetIds.size()]);
        }
        IWorkingSetNewWizard iWorkingSetNewWizard = iWorkingSetManager.createWorkingSetNewWizard(stringArray);
        WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)iWorkingSetNewWizard);
        wizardDialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)wizardDialog.getShell(), "org.eclipse.ui.working_set_new_wizard_context");
        if (wizardDialog.open() == 0) {
            IWorkingSet iWorkingSet = iWorkingSetNewWizard.getSelection();
            iWorkingSetManager.addWorkingSet(iWorkingSet);
            this.addedWorkingSets.add(iWorkingSet);
            this.availableWorkingSetsChanged();
        }
    }

    protected abstract List getSelectedWorkingSets();

    protected void availableWorkingSetsChanged() {
        boolean bl;
        boolean bl2 = bl = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets().length > 0;
        if (this.selectAllButton != null && !this.selectAllButton.isDisposed()) {
            this.selectAllButton.setEnabled(bl);
        }
        if (this.deselectAllButton != null && !this.deselectAllButton.isDisposed()) {
            this.deselectAllButton.setEnabled(bl);
        }
    }

    @Override
    public IWorkingSet[] getSelection() {
        return this.result;
    }

    @Override
    public void setSelection(IWorkingSet[] iWorkingSetArray) {
        this.result = iWorkingSetArray;
    }

    @Override
    public int open() {
        this.addedWorkingSets = new ArrayList();
        this.removedWorkingSets = new ArrayList();
        this.editedWorkingSets = new HashMap();
        this.removedMRUWorkingSets = new ArrayList();
        return super.open();
    }

    protected final List getAddedWorkingSets() {
        return this.addedWorkingSets;
    }

    protected final Map getEditedWorkingSets() {
        return this.editedWorkingSets;
    }

    protected final List getRemovedMRUWorkingSets() {
        return this.removedMRUWorkingSets;
    }

    protected final List getRemovedWorkingSets() {
        return this.removedWorkingSets;
    }

    protected void updateButtonAvailability() {
        boolean bl;
        List list = this.getSelectedWorkingSets();
        boolean bl2 = bl = list != null && !list.isEmpty();
        WorkingSetRegistry workingSetRegistry = WorkbenchPlugin.getDefault().getWorkingSetRegistry();
        this.newButton.setEnabled(workingSetRegistry.hasNewPageWorkingSetDescriptor());
        if (this.canEdit) {
            this.removeButton.setEnabled(bl);
        }
        IWorkingSet iWorkingSet = null;
        if (bl) {
            boolean bl3 = bl2 = list.size() == 1;
            if (bl2) {
                iWorkingSet = (IWorkingSet)list.get(0);
            }
        }
        if (this.canEdit) {
            this.detailsButton.setEnabled(bl2 && iWorkingSet.isEditable());
        }
        this.getOkButton().setEnabled(true);
    }

    protected void removeSelectedWorkingSets() {
        List list = this.getSelectedWorkingSets();
        this.removeSelectedWorkingSets(list);
    }

    protected void removeSelectedWorkingSets(List list) {
        IWorkingSetManager iWorkingSetManager = WorkbenchPlugin.getDefault().getWorkingSetManager();
        for (IWorkingSet iWorkingSet : list) {
            if (this.getAddedWorkingSets().contains(iWorkingSet)) {
                this.getAddedWorkingSets().remove(iWorkingSet);
            } else {
                IWorkingSet[] iWorkingSetArray = iWorkingSetManager.getRecentWorkingSets();
                int n = 0;
                while (n < iWorkingSetArray.length) {
                    if (iWorkingSet.equals(iWorkingSetArray[n])) {
                        this.getRemovedMRUWorkingSets().add(iWorkingSet);
                        break;
                    }
                    ++n;
                }
                this.getRemovedWorkingSets().add(iWorkingSet);
            }
            iWorkingSetManager.removeWorkingSet(iWorkingSet);
        }
        this.availableWorkingSetsChanged();
    }
}

