/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ProductProperties;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.about.AboutBundleGroupData;
import org.eclipse.ui.internal.about.AboutFeaturesButtonManager;
import org.eclipse.ui.internal.about.AboutItem;
import org.eclipse.ui.internal.about.AboutTextManager;
import org.eclipse.ui.internal.about.InstallationDialog;
import org.eclipse.ui.internal.dialogs.AboutFeaturesDialog;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;

public class AboutDialog
extends TrayDialog {
    private static final int MAX_IMAGE_WIDTH_FOR_TEXT = 250;
    private static final int TEXT_MARGIN = 5;
    private static final int DETAILS_ID = 1025;
    private String productName;
    private IProduct product;
    private AboutBundleGroupData[] bundleGroupInfos;
    private ArrayList images = new ArrayList();
    private AboutFeaturesButtonManager buttonManager = new AboutFeaturesButtonManager();
    private StyledText text;
    private AboutTextManager aboutTextManager;
    private AboutItem item;

    public AboutDialog(Shell shell) {
        super(shell);
        this.product = Platform.getProduct();
        if (this.product != null) {
            this.productName = this.product.getName();
        }
        if (this.productName == null) {
            this.productName = WorkbenchMessages.AboutDialog_defaultProductName;
        }
        IBundleGroupProvider[] iBundleGroupProviderArray = Platform.getBundleGroupProviders();
        LinkedList<AboutBundleGroupData> linkedList = new LinkedList<AboutBundleGroupData>();
        if (iBundleGroupProviderArray != null) {
            int n = 0;
            while (n < iBundleGroupProviderArray.length) {
                IBundleGroup[] iBundleGroupArray = iBundleGroupProviderArray[n].getBundleGroups();
                int n2 = 0;
                while (n2 < iBundleGroupArray.length) {
                    linkedList.add(new AboutBundleGroupData(iBundleGroupArray[n2]));
                    ++n2;
                }
                ++n;
            }
        }
        this.bundleGroupInfos = linkedList.toArray(new AboutBundleGroupData[0]);
    }

    protected void buttonPressed(int n) {
        switch (n) {
            case 1025: {
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        InstallationDialog installationDialog = new InstallationDialog(AboutDialog.this.getShell(), iWorkbenchWindow);
                        installationDialog.setModalParent((Dialog)AboutDialog.this);
                        installationDialog.open();
                    }
                });
                break;
            }
            default: {
                super.buttonPressed(n);
            }
        }
    }

    public boolean close() {
        int n = 0;
        while (n < this.images.size()) {
            Image image = (Image)this.images.get(n);
            image.dispose();
            ++n;
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NLS.bind((String)WorkbenchMessages.AboutDialog_shellTitle, (Object)this.productName));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.about_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite composite) {
        composite.setLayoutData((Object)new GridData(768));
        this.createButton(composite, 1025, WorkbenchMessages.AboutDialog_DetailsButton, false);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        ++gridLayout.numColumns;
        gridLayout.makeColumnsEqualWidth = false;
        Button button = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        button.setFocus();
    }

    protected Control createDialogArea(Composite composite) {
        GridData gridData;
        Label label;
        Object object;
        ImageDescriptor imageDescriptor;
        Image image = null;
        this.item = null;
        if (this.product != null) {
            imageDescriptor = ProductProperties.getAboutImage(this.product);
            if (imageDescriptor != null) {
                image = imageDescriptor.createImage();
            }
            if ((image == null || image.getBounds().width <= 250) && (object = ProductProperties.getAboutText(this.product)) != null) {
                this.item = AboutTextManager.scan((String)object);
            }
            if (image != null) {
                this.images.add(image);
            }
        }
        imageDescriptor = new Composite(composite, 0);
        object = new GridLayout();
        object.marginHeight = 0;
        object.marginWidth = 0;
        object.verticalSpacing = 0;
        object.horizontalSpacing = 0;
        imageDescriptor.setLayout((Layout)object);
        imageDescriptor.setLayoutData((Object)new GridData(1808));
        Color color = JFaceColors.getBannerBackground((Display)composite.getDisplay());
        Color color2 = JFaceColors.getBannerForeground((Display)composite.getDisplay());
        Composite composite2 = (Composite)super.createDialogArea((Composite)imageDescriptor);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setBackground(color);
        composite2.setForeground(color2);
        final Composite composite3 = new Composite(composite2, 0);
        composite3.setBackground(color);
        composite3.setForeground(color2);
        gridLayout = new GridLayout();
        gridLayout.numColumns = image == null || this.item == null ? 1 : 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite3.setLayout((Layout)gridLayout);
        GC gC = new GC((Drawable)composite);
        int n = gC.getFontMetrics().getHeight();
        gC.dispose();
        int n2 = 100;
        n2 = Math.max(n2, n * 6);
        if (image != null) {
            label = new Label(composite3, 0);
            label.setBackground(color);
            label.setForeground(color2);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 1;
            gridData.grabExcessHorizontalSpace = false;
            label.setLayoutData((Object)gridData);
            label.setImage(image);
            n2 = Math.max(n2, image.getBounds().height);
        }
        label = new GridData(4, 4, true, true);
        composite3.setLayoutData((Object)label);
        composite3.setSize(432, n2);
        if (this.item != null) {
            this.text = new StyledText(composite3, 74);
            this.configureText(composite3);
            gridData = this.text.computeTrim(0, 0, 100, 100);
            final int n3 = gridData.width - 100;
            final int n4 = gridData.height - 100;
            composite3.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent controlEvent) {
                    AboutDialog.this.text.setSize(-1, -1);
                    composite3.layout(true);
                    Point point = AboutDialog.this.text.getSize();
                    int n = point.y - n4;
                    int n2 = point.x - n3 - 10;
                    Point point2 = AboutDialog.this.text.computeSize(n2, -1, true);
                    int n32 = AboutDialog.this.text.getStyle();
                    if (point2.y > n) {
                        if ((n32 & 0x200) == 0) {
                            AboutDialog.this.recreateWrappedText(composite3, true);
                        }
                    } else if ((n32 & 0x200) != 0) {
                        AboutDialog.this.recreateWrappedText(composite3, false);
                    }
                    composite3.layout(true);
                }
            });
        }
        gridData = new Label((Composite)imageDescriptor, 258);
        label = new GridData();
        label.horizontalAlignment = 4;
        gridData.setLayoutData((Object)label);
        Composite composite4 = (Composite)super.createDialogArea((Composite)imageDescriptor);
        gridLayout = new GridLayout();
        composite4.setLayout((Layout)gridLayout);
        label = new GridData();
        label.horizontalAlignment = 4;
        label.verticalAlignment = 4;
        label.grabExcessHorizontalSpace = true;
        composite4.setLayoutData((Object)label);
        this.createFeatureImageButtonRow(composite4);
        gridData = new Label(composite4, 0);
        label = new GridData();
        label.horizontalAlignment = 4;
        gridData.setLayoutData((Object)label);
        return imageDescriptor;
    }

    void recreateWrappedText(Composite composite, boolean bl) {
        int n = this.text.getStyle();
        n = bl ? (n |= 0x200) : (n ^= 0x200);
        boolean bl2 = this.text.isFocusControl();
        Point point = this.text.getSelection();
        this.text.dispose();
        this.text = new StyledText(composite, n);
        this.configureText(composite);
        if (bl2) {
            this.text.setFocus();
        }
        this.text.setSelection(point);
    }

    void configureText(Composite composite) {
        Color color = JFaceColors.getBannerBackground((Display)composite.getDisplay());
        Color color2 = JFaceColors.getBannerForeground((Display)composite.getDisplay());
        this.text.setFont(composite.getFont());
        this.text.setText(this.item.getText());
        this.text.setCursor(null);
        this.text.setBackground(color);
        this.text.setForeground(color2);
        this.text.setMargins(5, 5, 5, 0);
        this.aboutTextManager = new AboutTextManager(this.text);
        this.aboutTextManager.setItem(this.item);
        this.createTextMenu();
        GridData gridData = new GridData(4, 4, true, true);
        this.text.setLayoutData((Object)gridData);
    }

    private void createTextMenu() {
        final MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter(PlatformUI.getWorkbench(), null, "org.eclipse.ui.edit.copy", 8)));
        menuManager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter(PlatformUI.getWorkbench(), null, "org.eclipse.ui.edit.selectAll", 8)));
        this.text.setMenu(menuManager.createContextMenu((Control)this.text));
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                menuManager.dispose();
            }
        });
    }

    private void createFeatureImageButtonRow(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        composite2.setLayout((Layout)rowLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        int n = 0;
        while (n < this.bundleGroupInfos.length) {
            this.createFeatureButton(composite2, this.bundleGroupInfos[n]);
            ++n;
        }
    }

    private Button createFeatureButton(Composite composite, final AboutBundleGroupData aboutBundleGroupData) {
        if (!this.buttonManager.add(aboutBundleGroupData)) {
            return null;
        }
        ImageDescriptor imageDescriptor = aboutBundleGroupData.getFeatureImage();
        Image image = null;
        Button button = new Button(composite, 0x800008);
        button.setData((Object)aboutBundleGroupData);
        image = imageDescriptor.createImage();
        this.images.add(image);
        button.setImage(image);
        button.setToolTipText(aboutBundleGroupData.getProviderName());
        button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = aboutBundleGroupData.getProviderName();
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AboutBundleGroupData[] aboutBundleGroupDataArray = AboutDialog.this.buttonManager.getRelatedInfos(aboutBundleGroupData);
                AboutBundleGroupData aboutBundleGroupData2 = (AboutBundleGroupData)selectionEvent.widget.getData();
                AboutFeaturesDialog aboutFeaturesDialog = new AboutFeaturesDialog(AboutDialog.this.getShell(), AboutDialog.this.productName, aboutBundleGroupDataArray, aboutBundleGroupData2);
                aboutFeaturesDialog.open();
            }
        });
        return button;
    }

    protected boolean isResizable() {
        return true;
    }
}

