/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ObjectContributorManager;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecorationBuilder;
import org.eclipse.ui.internal.decorators.DecorationResult;
import org.eclipse.ui.internal.decorators.DecoratorDefinition;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.internal.decorators.LightweightDecoratorDefinition;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.Util;

public class LightweightDecoratorManager
extends ObjectContributorManager {
    private LightweightRunnable runnable = new LightweightRunnable();
    private LightweightDecoratorDefinition[] lightweightDefinitions;
    private static final LightweightDecoratorDefinition[] EMPTY_LIGHTWEIGHT_DEF = new LightweightDecoratorDefinition[0];

    LightweightDecoratorManager(LightweightDecoratorDefinition[] lightweightDecoratorDefinitionArray) {
        this.lightweightDefinitions = lightweightDecoratorDefinitionArray;
        this.buildContributors();
    }

    LightweightDecoratorDefinition[] getDefinitions() {
        return this.lightweightDefinitions;
    }

    private void buildContributors() {
        int n = 0;
        while (n < this.lightweightDefinitions.length) {
            LightweightDecoratorDefinition lightweightDecoratorDefinition = this.lightweightDefinitions[n];
            String[] stringArray = this.getTargetTypes(lightweightDecoratorDefinition);
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.registerContributor(lightweightDecoratorDefinition, stringArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public boolean addDecorator(LightweightDecoratorDefinition lightweightDecoratorDefinition) {
        if (this.getLightweightDecoratorDefinition(lightweightDecoratorDefinition.getId()) == null) {
            LightweightDecoratorDefinition[] lightweightDecoratorDefinitionArray = this.lightweightDefinitions;
            this.lightweightDefinitions = new LightweightDecoratorDefinition[this.lightweightDefinitions.length + 1];
            System.arraycopy(lightweightDecoratorDefinitionArray, 0, this.lightweightDefinitions, 0, lightweightDecoratorDefinitionArray.length);
            this.lightweightDefinitions[lightweightDecoratorDefinitionArray.length] = lightweightDecoratorDefinition;
            String[] stringArray = this.getTargetTypes(lightweightDecoratorDefinition);
            int n = 0;
            while (n < stringArray.length) {
                this.registerContributor(lightweightDecoratorDefinition, stringArray[n]);
                ++n;
            }
            return true;
        }
        return false;
    }

    private String[] getTargetTypes(LightweightDecoratorDefinition lightweightDecoratorDefinition) {
        return lightweightDecoratorDefinition.getObjectClasses();
    }

    public boolean removeDecorator(LightweightDecoratorDefinition lightweightDecoratorDefinition) {
        int n = this.getLightweightDecoratorDefinitionIdx(lightweightDecoratorDefinition.getId());
        if (n != -1) {
            Object[] objectArray = this.lightweightDefinitions;
            this.lightweightDefinitions = new LightweightDecoratorDefinition[this.lightweightDefinitions.length - 1];
            Util.arrayCopyWithRemoval(objectArray, this.lightweightDefinitions, n);
            String[] stringArray = this.getTargetTypes(lightweightDecoratorDefinition);
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.unregisterContributor(lightweightDecoratorDefinition, stringArray[n2]);
                ++n2;
            }
            return true;
        }
        return false;
    }

    private LightweightDecoratorDefinition getLightweightDecoratorDefinition(String string) {
        int n = this.getLightweightDecoratorDefinitionIdx(string);
        if (n != -1) {
            return this.lightweightDefinitions[n];
        }
        return null;
    }

    private int getLightweightDecoratorDefinitionIdx(String string) {
        int n = 0;
        while (n < this.lightweightDefinitions.length) {
            if (this.lightweightDefinitions[n].getId().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    LightweightDecoratorDefinition[] enabledDefinitions() {
        ArrayList<LightweightDecoratorDefinition> arrayList = new ArrayList<LightweightDecoratorDefinition>();
        int n = 0;
        while (n < this.lightweightDefinitions.length) {
            if (this.lightweightDefinitions[n].isEnabled()) {
                arrayList.add(this.lightweightDefinitions[n]);
            }
            ++n;
        }
        LightweightDecoratorDefinition[] lightweightDecoratorDefinitionArray = new LightweightDecoratorDefinition[arrayList.size()];
        arrayList.toArray(lightweightDecoratorDefinitionArray);
        return lightweightDecoratorDefinitionArray;
    }

    boolean hasEnabledDefinitions() {
        int n = 0;
        while (n < this.lightweightDefinitions.length) {
            if (this.lightweightDefinitions[n].isEnabled()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void reset() {
        this.runnable.clearReferences();
    }

    void shutdown() {
        int n = 0;
        while (n < this.lightweightDefinitions.length) {
            if (this.lightweightDefinitions[n].isEnabled()) {
                this.lightweightDefinitions[n].setEnabled(false);
            }
            ++n;
        }
    }

    LightweightDecoratorDefinition getDecoratorDefinition(String string) {
        int n = 0;
        while (n < this.lightweightDefinitions.length) {
            if (this.lightweightDefinitions[n].getId().equals(string)) {
                return this.lightweightDefinitions[n];
            }
            ++n;
        }
        return null;
    }

    LightweightDecoratorDefinition[] getDecoratorsFor(Object object) {
        Collection collection;
        if (object == null) {
            return EMPTY_LIGHTWEIGHT_DEF;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(object);
        LightweightDecoratorDefinition[] lightweightDecoratorDefinitionArray = EMPTY_LIGHTWEIGHT_DEF;
        List list = this.getContributors(arrayList);
        if (!list.isEmpty() && (collection = DecoratorManager.getDecoratorsFor(object, list.toArray(new DecoratorDefinition[list.size()]))).size() > 0) {
            lightweightDecoratorDefinitionArray = new LightweightDecoratorDefinition[collection.size()];
            collection.toArray(lightweightDecoratorDefinitionArray);
        }
        return lightweightDecoratorDefinitionArray;
    }

    public void getDecorations(Object object, DecorationBuilder decorationBuilder) {
        LightweightDecoratorDefinition[] lightweightDecoratorDefinitionArray = this.getDecoratorsFor(object);
        int n = 0;
        while (n < lightweightDecoratorDefinitionArray.length) {
            LightweightDecoratorDefinition lightweightDecoratorDefinition = lightweightDecoratorDefinitionArray[n];
            decorationBuilder.setCurrentDefinition(lightweightDecoratorDefinition);
            this.decorate(object, decorationBuilder, lightweightDecoratorDefinition);
            ++n;
        }
    }

    private void decorate(Object object, DecorationBuilder decorationBuilder, LightweightDecoratorDefinition lightweightDecoratorDefinition) {
        this.runnable.setValues(object, decorationBuilder, lightweightDecoratorDefinition);
        SafeRunner.run((ISafeRunnable)this.runnable);
    }

    public DecorationResult getDecorationResult(Object object) {
        DecorationBuilder decorationBuilder = new DecorationBuilder();
        this.getDecorations(object, decorationBuilder);
        return decorationBuilder.createResult();
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
    }

    private class LightweightRunnable
    implements ISafeRunnable {
        private Object element;
        private DecorationBuilder decoration;
        private LightweightDecoratorDefinition decorator;

        private LightweightRunnable() {
        }

        void setValues(Object object, DecorationBuilder decorationBuilder, LightweightDecoratorDefinition lightweightDecoratorDefinition) {
            this.element = object;
            this.decoration = decorationBuilder;
            this.decorator = lightweightDecoratorDefinition;
        }

        public void handleException(Throwable throwable) {
            IStatus iStatus = StatusUtil.newStatus(4, throwable.getMessage(), throwable);
            String string = this.decorator == null ? WorkbenchMessages.DecoratorError : NLS.bind((String)WorkbenchMessages.DecoratorWillBeDisabled, (Object)this.decorator.getName());
            WorkbenchPlugin.log(string, iStatus);
            if (this.decorator != null) {
                this.decorator.crashDisable();
            }
            this.clearReferences();
        }

        public void run() throws Exception {
            this.decorator.decorate(this.element, this.decoration);
            this.clearReferences();
        }

        void clearReferences() {
            this.decorator = null;
            this.element = null;
            this.decoration = null;
        }
    }
}

