/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LightweightActionDescriptor
implements IAdaptable,
IWorkbenchAdapter {
    private static final Object[] NO_CHILDREN = new Object[0];
    private String id;
    private String label;
    private String description;
    private ImageDescriptor image;

    public LightweightActionDescriptor(IConfigurationElement iConfigurationElement) {
        this.id = iConfigurationElement.getAttribute("id");
        this.label = iConfigurationElement.getAttribute("label");
        this.description = iConfigurationElement.getAttribute("description");
        String string = iConfigurationElement.getAttribute("icon");
        if (string != null) {
            IExtension iExtension = iConfigurationElement.getDeclaringExtension();
            this.image = AbstractUIPlugin.imageDescriptorFromPlugin(iExtension.getNamespace(), string);
        }
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IWorkbenchAdapter.class) {
            return this;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.image;
    }

    @Override
    public ImageDescriptor getImageDescriptor(Object object) {
        if (object == this) {
            return this.getImageDescriptor();
        }
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public String getLabel(Object object) {
        if (object == this) {
            String string = this.getLabel();
            int n = string.lastIndexOf(64);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            return DialogUtil.removeAccel(string);
        }
        return object == null ? "" : object.toString();
    }

    @Override
    public Object[] getChildren(Object object) {
        return NO_CHILDREN;
    }

    @Override
    public Object getParent(Object object) {
        return null;
    }
}

