/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecoratorDefinition;

class FullDecoratorDefinition
extends DecoratorDefinition {
    ILabelDecorator decorator;

    FullDecoratorDefinition(String string, IConfigurationElement iConfigurationElement) {
        super(string, iConfigurationElement);
    }

    protected ILabelDecorator internalGetDecorator() throws CoreException {
        if (this.labelProviderCreationFailed) {
            return null;
        }
        final CoreException[] coreExceptionArray = new CoreException[1];
        if (this.decorator != null) {
            return this.decorator;
        }
        Platform.run((ISafeRunnable)new SafeRunnable(NLS.bind((String)WorkbenchMessages.DecoratorManager_ErrorActivatingDecorator, (Object)this.getName())){

            public void run() {
                try {
                    FullDecoratorDefinition.this.decorator = (ILabelDecorator)WorkbenchPlugin.createExtension(FullDecoratorDefinition.this.definingElement, "class");
                    FullDecoratorDefinition.this.decorator.addListener((ILabelProviderListener)WorkbenchPlugin.getDefault().getDecoratorManager());
                }
                catch (CoreException coreException) {
                    coreExceptionArray[0] = coreException;
                }
            }
        });
        if (this.decorator == null) {
            this.labelProviderCreationFailed = true;
            this.setEnabled(false);
        }
        if (coreExceptionArray[0] != null) {
            throw coreExceptionArray[0];
        }
        return this.decorator;
    }

    @Override
    protected void refreshDecorator() {
        if (!this.enabled && this.decorator != null) {
            ILabelDecorator iLabelDecorator = this.decorator;
            this.decorator = null;
            this.disposeCachedDecorator((IBaseLabelProvider)iLabelDecorator);
        }
    }

    Image decorateImage(Image image, Object object) {
        try {
            ILabelDecorator iLabelDecorator = this.internalGetDecorator();
            if (iLabelDecorator != null) {
                return iLabelDecorator.decorateImage(image, object);
            }
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException);
        }
        return null;
    }

    String decorateText(String string, Object object) {
        try {
            ILabelDecorator iLabelDecorator = this.internalGetDecorator();
            if (iLabelDecorator != null) {
                return iLabelDecorator.decorateText(string, object);
            }
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException);
        }
        return null;
    }

    public ILabelDecorator getDecorator() {
        return this.decorator;
    }

    @Override
    protected IBaseLabelProvider internalGetLabelProvider() throws CoreException {
        return this.internalGetDecorator();
    }

    @Override
    public boolean isFull() {
        return true;
    }
}

