/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.decorators.DecoratorDefinition;
import org.eclipse.ui.internal.decorators.FullDecoratorDefinition;
import org.eclipse.ui.internal.decorators.LightweightDecoratorDefinition;
import org.eclipse.ui.internal.registry.RegistryReader;

public class DecoratorRegistryReader
extends RegistryReader {
    private Collection values = new ArrayList();
    private Collection ids = new HashSet();

    @Override
    public boolean readElement(IConfigurationElement iConfigurationElement) {
        DecoratorDefinition decoratorDefinition = this.getDecoratorDefinition(iConfigurationElement);
        if (decoratorDefinition == null) {
            return false;
        }
        this.values.add(decoratorDefinition);
        return true;
    }

    DecoratorDefinition getDecoratorDefinition(IConfigurationElement iConfigurationElement) {
        boolean bl;
        String string = iConfigurationElement.getAttribute("id");
        if (this.ids.contains(string)) {
            this.logDuplicateId(iConfigurationElement);
            return null;
        }
        this.ids.add(string);
        boolean bl2 = bl = iConfigurationElement.getAttribute("class") == null;
        if (Boolean.valueOf(iConfigurationElement.getAttribute("lightweight")).booleanValue() || bl) {
            String string2 = iConfigurationElement.getAttribute("icon");
            if (bl && string2 == null) {
                DecoratorRegistryReader.logMissingElement(iConfigurationElement, "icon");
                return null;
            }
            return new LightweightDecoratorDefinition(string, iConfigurationElement);
        }
        return new FullDecoratorDefinition(string, iConfigurationElement);
    }

    Collection readRegistry(IExtensionRegistry iExtensionRegistry) {
        this.values.clear();
        this.ids.clear();
        this.readRegistry(iExtensionRegistry, "org.eclipse.ui", "decorators");
        return this.values;
    }

    public Collection getValues() {
        return this.values;
    }

    protected void logDuplicateId(IConfigurationElement iConfigurationElement) {
        DecoratorRegistryReader.logError(iConfigurationElement, "Duplicate id found: " + iConfigurationElement.getAttribute("id"));
    }
}

