/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IDelayedLabelDecorator;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecorationScheduler;
import org.eclipse.ui.internal.decorators.DecoratorDefinition;
import org.eclipse.ui.internal.decorators.DecoratorRegistryReader;
import org.eclipse.ui.internal.decorators.FullDecoratorDefinition;
import org.eclipse.ui.internal.decorators.FullImageDecoratorRunnable;
import org.eclipse.ui.internal.decorators.FullTextDecoratorRunnable;
import org.eclipse.ui.internal.decorators.LightweightDecoratorDefinition;
import org.eclipse.ui.internal.decorators.LightweightDecoratorManager;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.progress.WorkbenchJob;

public class DecoratorManager
implements ILabelProviderListener,
IDecoratorManager,
IExtensionChangeHandler {
    private static String EXTENSIONPOINT_UNIQUE_ID = String.valueOf(WorkbenchPlugin.PI_WORKBENCH) + "." + "decorators";
    public static final Object FAMILY_DECORATE = new Object();
    private DecorationScheduler scheduler;
    private LightweightDecoratorManager lightweightManager;
    private ListenerList listeners = new ListenerList();
    private FullDecoratorDefinition[] fullDefinitions;
    private FullTextDecoratorRunnable fullTextRunnable = new FullTextDecoratorRunnable();
    private FullImageDecoratorRunnable fullImageRunnable = new FullImageDecoratorRunnable();
    private static final FullDecoratorDefinition[] EMPTY_FULL_DEF = new FullDecoratorDefinition[0];
    private final String PREFERENCE_SEPARATOR = ",";
    private final String VALUE_SEPARATOR = ":";
    private final String P_TRUE = "true";
    private final String P_FALSE = "false";
    private LocalResourceManager resourceManager;

    public DecoratorManager() {
        this.scheduler = new DecorationScheduler(this);
        IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
        iExtensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
        this.resourceManager = null;
    }

    private void initializeDecoratorDefinitions() {
        LightweightDecoratorDefinition[] lightweightDecoratorDefinitionArray;
        DecoratorRegistryReader decoratorRegistryReader = new DecoratorRegistryReader();
        Collection collection = decoratorRegistryReader.readRegistry(Platform.getExtensionRegistry());
        ArrayList<LightweightDecoratorDefinition[]> arrayList = new ArrayList<LightweightDecoratorDefinition[]>();
        ArrayList<LightweightDecoratorDefinition[]> arrayList2 = new ArrayList<LightweightDecoratorDefinition[]>();
        Iterator iterator = collection.iterator();
        IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
        while (iterator.hasNext()) {
            lightweightDecoratorDefinitionArray = (LightweightDecoratorDefinition[])iterator.next();
            if (lightweightDecoratorDefinitionArray.isFull()) {
                arrayList.add(lightweightDecoratorDefinitionArray);
            } else {
                arrayList2.add(lightweightDecoratorDefinitionArray);
            }
            iExtensionTracker.registerObject(lightweightDecoratorDefinitionArray.getConfigurationElement().getDeclaringExtension(), (Object)lightweightDecoratorDefinitionArray, 2);
        }
        this.fullDefinitions = new FullDecoratorDefinition[arrayList.size()];
        arrayList.toArray(this.fullDefinitions);
        lightweightDecoratorDefinitionArray = new LightweightDecoratorDefinition[arrayList2.size()];
        arrayList2.toArray(lightweightDecoratorDefinitionArray);
        this.lightweightManager = new LightweightDecoratorManager(lightweightDecoratorDefinitionArray);
        this.applyDecoratorsPreference();
    }

    public void addDecorator(DecoratorDefinition decoratorDefinition) {
        if (decoratorDefinition.isFull()) {
            if (this.getFullDecoratorDefinition(decoratorDefinition.getId()) == null) {
                FullDecoratorDefinition[] fullDecoratorDefinitionArray = this.getFullDefinitions();
                this.fullDefinitions = new FullDecoratorDefinition[this.fullDefinitions.length + 1];
                System.arraycopy(fullDecoratorDefinitionArray, 0, this.fullDefinitions, 0, fullDecoratorDefinitionArray.length);
                this.fullDefinitions[fullDecoratorDefinitionArray.length] = (FullDecoratorDefinition)decoratorDefinition;
                this.clearCaches();
                this.updateForEnablementChange();
            }
        } else if (this.getLightweightManager().addDecorator((LightweightDecoratorDefinition)decoratorDefinition)) {
            this.clearCaches();
            this.updateForEnablementChange();
        }
        ((Workbench)PlatformUI.getWorkbench()).getExtensionTracker().registerObject(decoratorDefinition.getConfigurationElement().getDeclaringExtension(), (Object)decoratorDefinition, 2);
    }

    static Collection getDecoratorsFor(Object object, DecoratorDefinition[] decoratorDefinitionArray) {
        ArrayList<DecoratorDefinition> arrayList = new ArrayList<DecoratorDefinition>();
        int n = 0;
        while (n < decoratorDefinitionArray.length) {
            if (decoratorDefinitionArray[n].isEnabledFor(object)) {
                arrayList.add(decoratorDefinitionArray[n]);
            }
            ++n;
        }
        return arrayList;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        this.listeners.add((Object)iLabelProviderListener);
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        this.listeners.remove((Object)iLabelProviderListener);
        this.scheduler.listenerRemoved(iLabelProviderListener);
    }

    ILabelProviderListener[] getListeners() {
        Object[] objectArray = this.listeners.getListeners();
        ILabelProviderListener[] iLabelProviderListenerArray = new ILabelProviderListener[objectArray.length];
        System.arraycopy(objectArray, 0, iLabelProviderListenerArray, 0, iLabelProviderListenerArray.length);
        return iLabelProviderListenerArray;
    }

    void fireListener(final LabelProviderChangedEvent labelProviderChangedEvent, final ILabelProviderListener iLabelProviderListener) {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                iLabelProviderListener.labelProviderChanged(labelProviderChangedEvent);
            }
        });
    }

    void fireListeners(final LabelProviderChangedEvent labelProviderChangedEvent) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            final ILabelProviderListener iLabelProviderListener = (ILabelProviderListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    iLabelProviderListener.labelProviderChanged(labelProviderChangedEvent);
                }
            });
            ++n;
        }
    }

    void fireListenersInUIThread(final LabelProviderChangedEvent labelProviderChangedEvent) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        if (Thread.currentThread() == PlatformUI.getWorkbench().getDisplay().getThread()) {
            this.fireListeners(labelProviderChangedEvent);
            return;
        }
        WorkbenchJob workbenchJob = new WorkbenchJob(WorkbenchMessages.DecorationScheduler_UpdateJobName){

            @Override
            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                DecoratorManager.this.fireListeners(labelProviderChangedEvent);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object object) {
                return FAMILY_DECORATE == object;
            }
        };
        workbenchJob.setSystem(true);
        workbenchJob.schedule();
    }

    public String decorateText(String string, Object object, IDecorationContext iDecorationContext) {
        String string2;
        Object object2 = this.getResourceAdapter(object);
        String string3 = this.scheduler.decorateWithText(string, object, object2, iDecorationContext);
        FullDecoratorDefinition[] fullDecoratorDefinitionArray = this.getDecoratorsFor(object);
        int n = 0;
        while (n < fullDecoratorDefinitionArray.length) {
            if (fullDecoratorDefinitionArray[n].isEnabledFor(object) && (string2 = this.safeDecorateText(object, string3, fullDecoratorDefinitionArray[n])) != null) {
                string3 = string2;
            }
            ++n;
        }
        if (object2 != null) {
            fullDecoratorDefinitionArray = this.getDecoratorsFor(object2);
            n = 0;
            while (n < fullDecoratorDefinitionArray.length) {
                if (fullDecoratorDefinitionArray[n].isAdaptable() && fullDecoratorDefinitionArray[n].isEnabledFor(object2) && (string2 = this.safeDecorateText(object2, string3, fullDecoratorDefinitionArray[n])) != null) {
                    string3 = string2;
                }
                ++n;
            }
        }
        return string3;
    }

    public String decorateText(String string, Object object) {
        return this.decorateText(string, object, DecorationContext.DEFAULT_CONTEXT);
    }

    private String safeDecorateText(Object object, String string, FullDecoratorDefinition fullDecoratorDefinition) {
        this.fullTextRunnable.setValues(string, object, fullDecoratorDefinition);
        SafeRunner.run((ISafeRunnable)this.fullTextRunnable);
        String string2 = this.fullTextRunnable.getResult();
        return string2;
    }

    public Image decorateImage(Image image, Object object, IDecorationContext iDecorationContext, ResourceManager resourceManager) {
        Image image2;
        Object object2 = this.getResourceAdapter(object);
        Image image3 = this.scheduler.decorateWithOverlays(image, object, object2, iDecorationContext, resourceManager);
        FullDecoratorDefinition[] fullDecoratorDefinitionArray = this.getDecoratorsFor(object);
        int n = 0;
        while (n < fullDecoratorDefinitionArray.length) {
            if (fullDecoratorDefinitionArray[n].isEnabledFor(object) && (image2 = this.safeDecorateImage(object, image3, fullDecoratorDefinitionArray[n])) != null) {
                image3 = image2;
            }
            ++n;
        }
        if (object2 != null) {
            fullDecoratorDefinitionArray = this.getDecoratorsFor(object2);
            n = 0;
            while (n < fullDecoratorDefinitionArray.length) {
                if (fullDecoratorDefinitionArray[n].isAdaptable() && fullDecoratorDefinitionArray[n].isEnabledFor(object2) && (image2 = this.safeDecorateImage(object2, image3, fullDecoratorDefinitionArray[n])) != null) {
                    image3 = image2;
                }
                ++n;
            }
        }
        return image3;
    }

    public Image decorateImage(Image image, Object object) {
        return this.decorateImage(image, object, DecorationContext.DEFAULT_CONTEXT, this.getResourceManager());
    }

    private Image safeDecorateImage(Object object, Image image, FullDecoratorDefinition fullDecoratorDefinition) {
        this.fullImageRunnable.setValues(image, object, fullDecoratorDefinition);
        SafeRunner.run((ISafeRunnable)this.fullImageRunnable);
        Image image2 = this.fullImageRunnable.getResult();
        return image2;
    }

    private Object getResourceAdapter(Object object) {
        Object object2 = LegacyResourceSupport.getAdaptedContributorResource(object);
        if (object2 != object) {
            return object2;
        }
        return null;
    }

    public boolean isLabelProperty(Object object, String string) {
        return this.isLabelProperty(object, string, true);
    }

    public boolean isLabelProperty(Object object, String string, boolean bl) {
        boolean bl2 = this.isLabelProperty(object, string, this.getDecoratorsFor(object));
        if (bl2) {
            return bl2;
        }
        boolean bl3 = this.isLabelProperty(object, string, this.getLightweightManager().getDecoratorsFor(object));
        if (bl3) {
            return true;
        }
        if (bl) {
            Object object2 = this.getResourceAdapter(object);
            if (object2 == null || object2 == object) {
                return false;
            }
            bl2 = this.isLabelProperty(object2, string, this.getDecoratorsFor(object2));
            if (bl2) {
                return bl2;
            }
            return this.isLabelProperty(object2, string, this.lightweightManager.getDecoratorsFor(object2));
        }
        return false;
    }

    private boolean isLabelProperty(Object object, String string, DecoratorDefinition[] decoratorDefinitionArray) {
        int n = 0;
        while (n < decoratorDefinitionArray.length) {
            if (decoratorDefinitionArray[n].isEnabledFor(object) && decoratorDefinitionArray[n].isLabelProperty(object, string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private FullDecoratorDefinition[] enabledFullDefinitions() {
        FullDecoratorDefinition[] fullDecoratorDefinitionArray = this.getFullDefinitions();
        if (fullDecoratorDefinitionArray.length == 0) {
            return fullDecoratorDefinitionArray;
        }
        ArrayList<FullDecoratorDefinition> arrayList = new ArrayList<FullDecoratorDefinition>();
        int n = 0;
        while (n < fullDecoratorDefinitionArray.length) {
            if (fullDecoratorDefinitionArray[n].isEnabled()) {
                arrayList.add(fullDecoratorDefinitionArray[n]);
            }
            ++n;
        }
        FullDecoratorDefinition[] fullDecoratorDefinitionArray2 = new FullDecoratorDefinition[arrayList.size()];
        arrayList.toArray(fullDecoratorDefinitionArray2);
        return fullDecoratorDefinitionArray2;
    }

    public void dispose() {
    }

    public void clearCaches() {
        this.getLightweightManager().reset();
        this.fullTextRunnable.clearReferences();
        this.fullImageRunnable.clearReferences();
    }

    public void updateForEnablementChange() {
        this.scheduler.clearResults();
        this.fireListenersInUIThread(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        this.writeDecoratorsPreference();
    }

    public DecoratorDefinition[] getAllDecoratorDefinitions() {
        LightweightDecoratorDefinition[] lightweightDecoratorDefinitionArray = this.getLightweightManager().getDefinitions();
        DecoratorDefinition[] decoratorDefinitionArray = new DecoratorDefinition[this.fullDefinitions.length + lightweightDecoratorDefinitionArray.length];
        System.arraycopy(this.fullDefinitions, 0, decoratorDefinitionArray, 0, this.fullDefinitions.length);
        System.arraycopy(lightweightDecoratorDefinitionArray, 0, decoratorDefinitionArray, this.fullDefinitions.length, lightweightDecoratorDefinitionArray.length);
        return decoratorDefinitionArray;
    }

    public void labelProviderChanged(LabelProviderChangedEvent labelProviderChangedEvent) {
        Object[] objectArray = labelProviderChangedEvent.getElements();
        this.scheduler.clearResults();
        if (objectArray == null) {
            this.fireListeners(labelProviderChangedEvent);
        } else {
            int n = 0;
            while (n < objectArray.length) {
                Object object = this.getResourceAdapter(objectArray[n]);
                this.scheduler.queueForDecoration(objectArray[n], object, true, null, DecorationContext.DEFAULT_CONTEXT);
                ++n;
            }
        }
    }

    private void writeDecoratorsPreference() {
        StringBuffer stringBuffer = new StringBuffer();
        this.writeDecoratorsPreference(stringBuffer, this.getFullDefinitions());
        this.writeDecoratorsPreference(stringBuffer, this.getLightweightManager().getDefinitions());
        WorkbenchPlugin.getDefault().getPreferenceStore().setValue("ENABLED_DECORATORS", stringBuffer.toString());
        PrefUtil.savePrefs();
    }

    private void writeDecoratorsPreference(StringBuffer stringBuffer, DecoratorDefinition[] decoratorDefinitionArray) {
        int n = 0;
        while (n < decoratorDefinitionArray.length) {
            stringBuffer.append(decoratorDefinitionArray[n].getId());
            stringBuffer.append(":");
            if (decoratorDefinitionArray[n].isEnabled()) {
                stringBuffer.append("true");
            } else {
                stringBuffer.append("false");
            }
            stringBuffer.append(",");
            ++n;
        }
    }

    public void applyDecoratorsPreference() {
        Object object;
        String string = WorkbenchPlugin.getDefault().getPreferenceStore().getString("ENABLED_DECORATORS");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            String string2 = ((String)object).substring(0, ((String)object).indexOf(":"));
            if (((String)object).endsWith("true")) {
                hashSet.add(string2);
                continue;
            }
            hashSet2.add(string2);
        }
        object = this.getFullDefinitions();
        int n = 0;
        while (n < ((Object)object).length) {
            String string3 = ((DecoratorDefinition)object[n]).getId();
            if (hashSet.contains(string3)) {
                ((DecoratorDefinition)object[n]).setEnabled(true);
            } else if (hashSet2.contains(string3)) {
                ((DecoratorDefinition)object[n]).setEnabled(false);
            }
            ++n;
        }
        LightweightDecoratorDefinition[] lightweightDecoratorDefinitionArray = this.getLightweightManager().getDefinitions();
        int n2 = 0;
        while (n2 < lightweightDecoratorDefinitionArray.length) {
            String string4 = lightweightDecoratorDefinitionArray[n2].getId();
            if (hashSet.contains(string4)) {
                lightweightDecoratorDefinitionArray[n2].setEnabled(true);
            } else if (hashSet2.contains(string4)) {
                lightweightDecoratorDefinitionArray[n2].setEnabled(false);
            }
            ++n2;
        }
    }

    public void shutdown() {
        FullDecoratorDefinition[] fullDecoratorDefinitionArray = this.getFullDefinitions();
        int n = 0;
        while (n < fullDecoratorDefinitionArray.length) {
            if (fullDecoratorDefinitionArray[n].isEnabled()) {
                fullDecoratorDefinitionArray[n].setEnabled(false);
            }
            ++n;
        }
        if (this.lightweightManager != null) {
            this.getLightweightManager().shutdown();
        }
        this.scheduler.shutdown();
        this.dispose();
    }

    @Override
    public boolean getEnabled(String string) {
        DecoratorDefinition decoratorDefinition = this.getDecoratorDefinition(string);
        if (decoratorDefinition == null) {
            return false;
        }
        return decoratorDefinition.isEnabled();
    }

    @Override
    public ILabelDecorator getLabelDecorator() {
        return new ManagedWorkbenchLabelDecorator(this);
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)PlatformUI.getWorkbench().getDisplay()));
        }
        return this.resourceManager;
    }

    @Override
    public void setEnabled(String string, boolean bl) {
        DecoratorDefinition decoratorDefinition = this.getDecoratorDefinition(string);
        if (decoratorDefinition != null) {
            decoratorDefinition.setEnabled(bl);
            this.clearCaches();
            this.updateForEnablementChange();
        }
    }

    @Override
    public IBaseLabelProvider getBaseLabelProvider(String string) {
        ILabelDecorator iLabelDecorator = this.getLabelDecorator(string);
        if (iLabelDecorator == null) {
            return this.getLightweightLabelDecorator(string);
        }
        return iLabelDecorator;
    }

    @Override
    public ILabelDecorator getLabelDecorator(String string) {
        FullDecoratorDefinition fullDecoratorDefinition = this.getFullDecoratorDefinition(string);
        if (fullDecoratorDefinition != null && fullDecoratorDefinition.isEnabled()) {
            ILabelDecorator iLabelDecorator = fullDecoratorDefinition.getDecorator();
            if (iLabelDecorator == null) {
                try {
                    iLabelDecorator = fullDecoratorDefinition.internalGetDecorator();
                }
                catch (CoreException coreException) {
                    WorkbenchPlugin.log(coreException);
                }
            }
            return iLabelDecorator;
        }
        return null;
    }

    @Override
    public ILightweightLabelDecorator getLightweightLabelDecorator(String string) {
        LightweightDecoratorDefinition lightweightDecoratorDefinition = this.getLightweightManager().getDecoratorDefinition(string);
        if (lightweightDecoratorDefinition != null && lightweightDecoratorDefinition.isEnabled()) {
            return lightweightDecoratorDefinition.getDecorator();
        }
        return null;
    }

    private DecoratorDefinition getDecoratorDefinition(String string) {
        FullDecoratorDefinition fullDecoratorDefinition = this.getFullDecoratorDefinition(string);
        if (fullDecoratorDefinition == null) {
            return this.getLightweightManager().getDecoratorDefinition(string);
        }
        return fullDecoratorDefinition;
    }

    private FullDecoratorDefinition getFullDecoratorDefinition(String string) {
        int n = this.getFullDecoratorDefinitionIdx(string);
        if (n != -1) {
            return this.getFullDefinitions()[n];
        }
        return null;
    }

    private int getFullDecoratorDefinitionIdx(String string) {
        FullDecoratorDefinition[] fullDecoratorDefinitionArray = this.getFullDefinitions();
        int n = 0;
        while (n < fullDecoratorDefinitionArray.length) {
            if (fullDecoratorDefinitionArray[n].getId().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private FullDecoratorDefinition[] getDecoratorsFor(Object object) {
        if (object == null) {
            return EMPTY_FULL_DEF;
        }
        Collection collection = DecoratorManager.getDecoratorsFor(object, this.enabledFullDefinitions());
        FullDecoratorDefinition[] fullDecoratorDefinitionArray = EMPTY_FULL_DEF;
        if (collection.size() > 0) {
            fullDecoratorDefinitionArray = new FullDecoratorDefinition[collection.size()];
            collection.toArray(fullDecoratorDefinitionArray);
        }
        return fullDecoratorDefinitionArray;
    }

    public LightweightDecoratorManager getLightweightManager() {
        if (this.lightweightManager == null) {
            this.initializeDecoratorDefinitions();
        }
        return this.lightweightManager;
    }

    @Override
    public void update(String string) {
        IBaseLabelProvider iBaseLabelProvider = this.getBaseLabelProvider(string);
        if (iBaseLabelProvider != null) {
            this.scheduler.clearResults();
            this.fireListeners(new LabelProviderChangedEvent(iBaseLabelProvider));
        }
    }

    public boolean prepareDecoration(Object object, String string, IDecorationContext iDecorationContext) {
        if (this.scheduler.isDecorationReady(object, iDecorationContext) || !this.getLightweightManager().hasEnabledDefinitions()) {
            return true;
        }
        boolean bl = true;
        if (string == null || string.length() == 0) {
            bl = false;
        }
        this.scheduler.queueForDecoration(object, this.getResourceAdapter(object), bl, string, iDecorationContext);
        return !bl;
    }

    public boolean prepareDecoration(Object object, String string) {
        return this.prepareDecoration(object, string, DecorationContext.DEFAULT_CONTEXT);
    }

    public Font decorateFont(Object object) {
        return this.scheduler.getFont(object, this.getResourceAdapter(object));
    }

    public Color decorateBackground(Object object) {
        return this.scheduler.getBackgroundColor(object, this.getResourceAdapter(object));
    }

    public Color decorateForeground(Object object) {
        return this.scheduler.getForegroundColor(object, this.getResourceAdapter(object));
    }

    private FullDecoratorDefinition[] getFullDefinitions() {
        if (this.fullDefinitions == null) {
            this.initializeDecoratorDefinitions();
        }
        return this.fullDefinitions;
    }

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint(EXTENSIONPOINT_UNIQUE_ID);
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            DecoratorRegistryReader decoratorRegistryReader = new DecoratorRegistryReader();
            decoratorRegistryReader.readElement(iConfigurationElementArray[n]);
            Iterator iterator = decoratorRegistryReader.getValues().iterator();
            while (iterator.hasNext()) {
                this.addDecorator((DecoratorDefinition)iterator.next());
            }
            ++n;
        }
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        boolean bl = false;
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof DecoratorDefinition) {
                DecoratorDefinition decoratorDefinition = (DecoratorDefinition)objectArray[n];
                if (decoratorDefinition.isFull()) {
                    int n2 = this.getFullDecoratorDefinitionIdx(decoratorDefinition.getId());
                    if (n2 != -1) {
                        Object[] objectArray2 = this.getFullDefinitions();
                        this.fullDefinitions = new FullDecoratorDefinition[this.fullDefinitions.length - 1];
                        Util.arrayCopyWithRemoval(objectArray2, this.fullDefinitions, n2);
                        bl = true;
                    }
                } else {
                    bl |= this.getLightweightManager().removeDecorator((LightweightDecoratorDefinition)decoratorDefinition);
                }
            }
            ++n;
        }
        if (bl) {
            this.clearCaches();
            this.updateForEnablementChange();
        }
    }

    private static class ManagedWorkbenchLabelDecorator
    extends LabelDecorator
    implements ILabelDecorator,
    IDelayedLabelDecorator,
    IColorDecorator,
    IFontDecorator {
        private final DecoratorManager decoratorManager;
        private LocalResourceManager resourceManager;

        public ManagedWorkbenchLabelDecorator(DecoratorManager decoratorManager) {
            this.decoratorManager = decoratorManager;
            this.resourceManager = null;
        }

        private LocalResourceManager getResourceManager() {
            if (this.resourceManager == null) {
                this.resourceManager = new LocalResourceManager(this.decoratorManager.getResourceManager());
            }
            return this.resourceManager;
        }

        public Image decorateImage(Image image, Object object, IDecorationContext iDecorationContext) {
            return this.decoratorManager.decorateImage(image, object, iDecorationContext, (ResourceManager)this.getResourceManager());
        }

        public String decorateText(String string, Object object, IDecorationContext iDecorationContext) {
            return this.decoratorManager.decorateText(string, object, iDecorationContext);
        }

        public boolean prepareDecoration(Object object, String string, IDecorationContext iDecorationContext) {
            return this.decoratorManager.prepareDecoration(object, string, iDecorationContext);
        }

        public boolean prepareDecoration(Object object, String string) {
            return this.prepareDecoration(object, string, DecorationContext.DEFAULT_CONTEXT);
        }

        public Font decorateFont(Object object) {
            return this.decoratorManager.decorateFont(object);
        }

        public Color decorateBackground(Object object) {
            return this.decoratorManager.decorateBackground(object);
        }

        public Color decorateForeground(Object object) {
            return this.decoratorManager.decorateForeground(object);
        }

        public Image decorateImage(Image image, Object object) {
            return this.decorateImage(image, object, DecorationContext.DEFAULT_CONTEXT);
        }

        public String decorateText(String string, Object object) {
            return this.decorateText(string, object, DecorationContext.DEFAULT_CONTEXT);
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
            this.decoratorManager.addListener(iLabelProviderListener);
        }

        public void dispose() {
            if (this.resourceManager != null) {
                this.resourceManager.dispose();
                this.resourceManager = null;
            }
        }

        public boolean isLabelProperty(Object object, String string) {
            return this.decoratorManager.isLabelProperty(object, string);
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
            this.decoratorManager.removeListener(iLabelProviderListener);
        }
    }
}

