/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;

public abstract class DecoratorDefinition
implements IPluginContribution {
    private static final String ATT_LABEL = "label";
    private static final String ATT_OBJECT_CLASS = "objectClass";
    static final String CHILD_ENABLEMENT = "enablement";
    private static final String ATT_ADAPTABLE = "adaptable";
    private static final String ATT_ENABLED = "state";
    private ActionExpression enablement;
    protected boolean enabled;
    private boolean defaultEnabled;
    private String id;
    protected IConfigurationElement definingElement;
    protected boolean labelProviderCreationFailed = false;
    private boolean hasReadEnablement;
    static final String ATT_CLASS = "class";

    DecoratorDefinition(String string, IConfigurationElement iConfigurationElement) {
        this.id = string;
        this.definingElement = iConfigurationElement;
        this.enabled = this.defaultEnabled = Boolean.valueOf(iConfigurationElement.getAttribute(ATT_ENABLED)).booleanValue();
    }

    public String getName() {
        return this.definingElement.getAttribute(ATT_LABEL);
    }

    public String getDescription() {
        return RegistryReader.getDescription(this.definingElement);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            try {
                this.refreshDecorator();
            }
            catch (CoreException coreException) {
                this.handleCoreException(coreException);
            }
        }
    }

    protected abstract void refreshDecorator() throws CoreException;

    protected void disposeCachedDecorator(IBaseLabelProvider iBaseLabelProvider) {
        iBaseLabelProvider.removeListener((ILabelProviderListener)WorkbenchPlugin.getDefault().getDecoratorManager());
        iBaseLabelProvider.dispose();
    }

    public boolean isAdaptable() {
        return Boolean.valueOf(this.definingElement.getAttribute(ATT_ADAPTABLE));
    }

    public String getId() {
        return this.id;
    }

    public boolean getDefaultValue() {
        return this.defaultEnabled;
    }

    protected ActionExpression getEnablement() {
        if (!this.hasReadEnablement) {
            this.hasReadEnablement = true;
            this.initializeEnablement();
        }
        return this.enablement;
    }

    protected void initializeEnablement() {
        IConfigurationElement[] iConfigurationElementArray = this.definingElement.getChildren(CHILD_ENABLEMENT);
        if (iConfigurationElementArray.length == 0) {
            String string = this.definingElement.getAttribute(ATT_OBJECT_CLASS);
            if (string != null) {
                this.enablement = new ActionExpression(ATT_OBJECT_CLASS, string);
            }
        } else {
            this.enablement = new ActionExpression(iConfigurationElementArray[0]);
        }
    }

    void addListener(ILabelProviderListener iLabelProviderListener) {
        try {
            IBaseLabelProvider iBaseLabelProvider = this.internalGetLabelProvider();
            if (iBaseLabelProvider != null) {
                iBaseLabelProvider.addListener(iLabelProviderListener);
            }
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException);
        }
    }

    boolean isLabelProperty(Object object, String string) {
        try {
            IBaseLabelProvider iBaseLabelProvider = this.internalGetLabelProvider();
            if (iBaseLabelProvider != null) {
                return iBaseLabelProvider.isLabelProperty(object, string);
            }
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException);
            return false;
        }
        return false;
    }

    protected abstract IBaseLabelProvider internalGetLabelProvider() throws CoreException;

    protected void handleCoreException(CoreException coreException) {
        WorkbenchPlugin.log(coreException);
        this.crashDisable();
    }

    public void crashDisable() {
        this.enabled = false;
    }

    public abstract boolean isFull();

    public IConfigurationElement getConfigurationElement() {
        return this.definingElement;
    }

    public boolean isEnabledFor(Object object) {
        if (this.isEnabled()) {
            ActionExpression actionExpression = this.getEnablement();
            if (actionExpression != null) {
                return actionExpression.isEnabledFor(object);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getPluginId() {
        return this.getConfigurationElement().getContributor().getName();
    }

    @Override
    public String getLocalId() {
        return this.getId();
    }
}

