/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.decorators.DecorationBuilder;
import org.eclipse.ui.internal.decorators.DecorationReference;
import org.eclipse.ui.internal.decorators.DecorationResult;
import org.eclipse.ui.internal.decorators.DecoratorManager;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class DecorationScheduler {
    static final ILabelProviderListener[] EMPTY_LISTENER_LIST = new ILabelProviderListener[0];
    Map resultCache = new HashMap();
    List awaitingDecoration = new ArrayList();
    Set pendingUpdate = new HashSet();
    Object pendingKey = new Object();
    Map awaitingDecorationValues = new HashMap();
    DecoratorManager decoratorManager;
    boolean shutdown = false;
    Job decorationJob;
    UIJob updateJob;
    private Collection removedListeners = Collections.synchronizedSet(new HashSet());
    private Job clearJob;
    static final int NEEDS_INIT = -1;
    static final int UPDATE_DELAY = 100;

    DecorationScheduler(DecoratorManager decoratorManager) {
        this.decoratorManager = decoratorManager;
        this.createDecorationJob();
    }

    public String decorateWithText(String string, Object object, Object object2, IDecorationContext iDecorationContext) {
        DecorationResult decorationResult = this.getResult(object, object2, iDecorationContext);
        if (decorationResult == null) {
            return string;
        }
        return decorationResult.decorateWithText(string);
    }

    synchronized void queueForDecoration(Object object, Object object2, boolean bl, String string, IDecorationContext iDecorationContext) {
        Assert.isNotNull((Object)iDecorationContext);
        DecorationReference decorationReference = (DecorationReference)this.awaitingDecorationValues.get(object);
        if (decorationReference != null) {
            if (bl) {
                decorationReference.setForceUpdate(bl);
            }
            decorationReference.addContext(iDecorationContext);
        } else {
            decorationReference = new DecorationReference(object, object2, iDecorationContext);
            decorationReference.setForceUpdate(bl);
            decorationReference.setUndecoratedText(string);
            this.awaitingDecorationValues.put(object, decorationReference);
            this.awaitingDecoration.add(object);
            if (this.shutdown) {
                return;
            }
            this.decorationJob.schedule();
        }
    }

    public Image decorateWithOverlays(Image image, Object object, Object object2, IDecorationContext iDecorationContext, ResourceManager resourceManager) {
        DecorationResult decorationResult = this.getResult(object, object2, iDecorationContext);
        if (decorationResult == null) {
            return image;
        }
        return decorationResult.decorateWithOverlays(image, resourceManager);
    }

    private DecorationResult getResult(Object object, Object object2, IDecorationContext iDecorationContext) {
        if (object == null) {
            return null;
        }
        DecorationResult decorationResult = this.internalGetResult(object, iDecorationContext);
        if (decorationResult == null) {
            this.queueForDecoration(object, object2, false, null, iDecorationContext);
            return null;
        }
        return decorationResult;
    }

    private DecorationResult internalGetResult(Object object, IDecorationContext iDecorationContext) {
        Map map = (Map)this.resultCache.get(iDecorationContext);
        if (map != null) {
            return (DecorationResult)map.get(object);
        }
        return null;
    }

    protected void internalPutResult(Object object, IDecorationContext iDecorationContext, DecorationResult decorationResult) {
        HashMap<Object, DecorationResult> hashMap = (HashMap<Object, DecorationResult>)this.resultCache.get(iDecorationContext);
        if (hashMap == null) {
            hashMap = new HashMap<Object, DecorationResult>();
            this.resultCache.put(iDecorationContext, hashMap);
        }
        hashMap.put(object, decorationResult);
    }

    synchronized void decorated() {
        if (this.shutdown) {
            return;
        }
        if (this.updateJob == null) {
            this.updateJob = this.getUpdateJob();
        }
        this.updateJob.schedule(100L);
    }

    synchronized void shutdown() {
        this.shutdown = true;
    }

    synchronized DecorationReference nextElement() {
        if (this.shutdown || this.awaitingDecoration.isEmpty()) {
            return null;
        }
        Object e = this.awaitingDecoration.remove(0);
        return (DecorationReference)this.awaitingDecorationValues.remove(e);
    }

    private void createDecorationJob() {
        this.decorationJob = new Job(WorkbenchMessages.DecorationScheduler_CalculationJobName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public IStatus run(IProgressMonitor var1_1) {
                var2_2 = DecorationScheduler.this;
                synchronized (var2_2) {
                    if (DecorationScheduler.this.shutdown) {
                        return Status.CANCEL_STATUS;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 3] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (true) ** GOTO lbl17
                }
                do {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException v1) {
                        this.schedule();
                        return Status.CANCEL_STATUS;
                    }
lbl17:
                    // 2 sources

                } while (DecorationScheduler.this.updatesPending());
                var1_1.beginTask(WorkbenchMessages.DecorationScheduler_CalculatingTask, 100);
                var1_1.worked(5);
                var3_3 = 5;
                while ((var2_2 = DecorationScheduler.this.nextElement()) != null) {
                    if (var3_3 < 90) {
                        var1_1.worked(1);
                        ++var3_3;
                    }
                    var1_1.subTask(var2_2.getSubTask());
                    var4_4 = var2_2.getElement();
                    var5_5 = var2_2.shouldForceUpdate();
                    var6_6 = var2_2.getContexts();
                    var7_8 = 0;
                    while (var7_8 < var6_6.length) {
                        var8_9 = var6_6[var7_8];
                        this.ensureResultCached(var4_4, var5_5, var8_9);
                        ++var7_8;
                    }
                    var7_7 = DecorationScheduler.this;
                    synchronized (var7_7) {
                        if (DecorationScheduler.this.awaitingDecoration.isEmpty()) {
                            DecorationScheduler.this.decorated();
                        }
                    }
                }
                var1_1.worked(100 - var3_3);
                var1_1.done();
                return Status.OK_STATUS;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void ensureResultCached(Object object, boolean bl, IDecorationContext iDecorationContext) {
                Object object2;
                boolean bl2;
                boolean bl3 = bl2 = DecorationScheduler.this.internalGetResult(object, iDecorationContext) != null;
                if (bl2) {
                    object2 = DecorationScheduler.this.pendingKey;
                    synchronized (object2) {
                        DecorationScheduler.this.pendingUpdate.add(object);
                    }
                }
                if (!bl2) {
                    object2 = new DecorationBuilder(iDecorationContext);
                    DecorationScheduler.this.decoratorManager.getLightweightManager().getDecorations(object, (DecorationBuilder)object2);
                    if (((DecorationBuilder)object2).hasValue() || bl) {
                        DecorationScheduler.this.internalPutResult(object, iDecorationContext, ((DecorationBuilder)object2).createResult());
                        Object object3 = DecorationScheduler.this.pendingKey;
                        synchronized (object3) {
                            DecorationScheduler.this.pendingUpdate.add(object);
                        }
                    }
                }
            }

            public boolean belongsTo(Object object) {
                return DecoratorManager.FAMILY_DECORATE == object;
            }

            public boolean shouldRun() {
                return PlatformUI.isWorkbenchRunning();
            }
        };
        this.decorationJob.setSystem(true);
        this.decorationJob.setPriority(50);
        this.decorationJob.schedule();
    }

    protected boolean updatesPending() {
        if (this.updateJob != null && this.updateJob.getState() != 0) {
            return true;
        }
        return this.clearJob != null && this.clearJob.getState() != 0;
    }

    void clearResults() {
        if (this.clearJob == null) {
            this.clearJob = this.getClearJob();
        }
        this.clearJob.schedule();
    }

    private Job getClearJob() {
        Job job = new Job(WorkbenchMessages.DecorationScheduler_ClearResultsJob){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                DecorationScheduler.this.resultCache.clear();
                return Status.OK_STATUS;
            }

            public boolean shouldRun() {
                return PlatformUI.isWorkbenchRunning();
            }
        };
        job.setSystem(true);
        return job;
    }

    private WorkbenchJob getUpdateJob() {
        WorkbenchJob workbenchJob = new WorkbenchJob(WorkbenchMessages.DecorationScheduler_UpdateJobName){
            int currentIndex;
            LabelProviderChangedEvent labelProviderChangedEvent;
            ILabelProviderListener[] listeners;
            {
                this.currentIndex = -1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                DecorationScheduler decorationScheduler = DecorationScheduler.this;
                synchronized (decorationScheduler) {
                    if (DecorationScheduler.this.shutdown) {
                        return Status.CANCEL_STATUS;
                    }
                }
                if (this.currentIndex == -1) {
                    if (DecorationScheduler.this.hasPendingUpdates()) {
                        this.resetState();
                        return Status.OK_STATUS;
                    }
                    this.setUpUpdates();
                }
                if (this.listeners.length == 0) {
                    this.resetState();
                    return Status.OK_STATUS;
                }
                iProgressMonitor.beginTask(WorkbenchMessages.DecorationScheduler_UpdatingTask, -1);
                long l = System.currentTimeMillis();
                while (this.currentIndex < this.listeners.length) {
                    ILabelProviderListener iLabelProviderListener = this.listeners[this.currentIndex];
                    ++this.currentIndex;
                    if (!DecorationScheduler.this.removedListeners.contains(iLabelProviderListener)) {
                        DecorationScheduler.this.decoratorManager.fireListener(this.labelProviderChangedEvent, iLabelProviderListener);
                    }
                    if (System.currentTimeMillis() - l >= 50L) break;
                }
                iProgressMonitor.done();
                if (this.currentIndex >= this.listeners.length) {
                    this.resetState();
                    if (!DecorationScheduler.this.hasPendingUpdates()) {
                        DecorationScheduler.this.decorated();
                    }
                    this.labelProviderChangedEvent = null;
                    this.listeners = EMPTY_LISTENER_LIST;
                } else {
                    this.schedule(100L);
                }
                return Status.OK_STATUS;
            }

            private void resetState() {
                this.currentIndex = -1;
                DecorationScheduler.this.removedListeners.clear();
                if (DecorationScheduler.this.awaitingDecoration.isEmpty()) {
                    DecorationScheduler.this.resultCache.clear();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void setUpUpdates() {
                DecorationScheduler.this.removedListeners.clear();
                this.currentIndex = 0;
                Object object = DecorationScheduler.this.pendingKey;
                synchronized (object) {
                    Object[] objectArray = DecorationScheduler.this.pendingUpdate.toArray(new Object[DecorationScheduler.this.pendingUpdate.size()]);
                    DecorationScheduler.this.pendingUpdate.clear();
                    this.labelProviderChangedEvent = new LabelProviderChangedEvent((IBaseLabelProvider)DecorationScheduler.this.decoratorManager, objectArray);
                }
                this.listeners = DecorationScheduler.this.decoratorManager.getListeners();
            }

            public boolean belongsTo(Object object) {
                return DecoratorManager.FAMILY_DECORATE == object;
            }

            @Override
            public boolean shouldRun() {
                return PlatformUI.isWorkbenchRunning();
            }
        };
        workbenchJob.setSystem(true);
        return workbenchJob;
    }

    public boolean isDecorationReady(Object object, IDecorationContext iDecorationContext) {
        return this.internalGetResult(object, iDecorationContext) != null;
    }

    public Color getBackgroundColor(Object object, Object object2) {
        DecorationResult decorationResult = this.getResult(object, object2, DecorationContext.DEFAULT_CONTEXT);
        if (decorationResult == null) {
            return null;
        }
        return decorationResult.getBackgroundColor();
    }

    public Font getFont(Object object, Object object2) {
        DecorationResult decorationResult = this.getResult(object, object2, DecorationContext.DEFAULT_CONTEXT);
        if (decorationResult == null) {
            return null;
        }
        return decorationResult.getFont();
    }

    public Color getForegroundColor(Object object, Object object2) {
        DecorationResult decorationResult = this.getResult(object, object2, DecorationContext.DEFAULT_CONTEXT);
        if (decorationResult == null) {
            return null;
        }
        return decorationResult.getForegroundColor();
    }

    public boolean processingUpdates() {
        return !this.hasPendingUpdates() && !this.awaitingDecoration.isEmpty();
    }

    void listenerRemoved(ILabelProviderListener iLabelProviderListener) {
        if (this.updatesPending()) {
            this.removedListeners.add(iLabelProviderListener);
        }
        if (!this.updatesPending()) {
            this.removedListeners.remove(iLabelProviderListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasPendingUpdates() {
        Object object = this.pendingKey;
        synchronized (object) {
            return this.pendingUpdate.isEmpty();
        }
    }
}

