/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class DecorationResult {
    private List prefixes;
    private List suffixes;
    private ImageDescriptor[] descriptors;
    private Color foregroundColor;
    private Color backgroundColor;
    private Font font;

    DecorationResult(List list, List list2, ImageDescriptor[] imageDescriptorArray, Color color, Color color2, Font font) {
        this.prefixes = list;
        this.suffixes = list2;
        if (this.hasOverlays(imageDescriptorArray)) {
            this.descriptors = imageDescriptorArray;
        }
        this.foregroundColor = color;
        this.backgroundColor = color2;
        this.font = font;
    }

    private boolean hasOverlays(ImageDescriptor[] imageDescriptorArray) {
        int n = 0;
        while (n < imageDescriptorArray.length) {
            if (imageDescriptorArray[n] != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    Image decorateWithOverlays(Image image, ResourceManager resourceManager) {
        if (image == null || this.descriptors == null) {
            return image;
        }
        Rectangle rectangle = image.getBounds();
        Point point = new Point(rectangle.width, rectangle.height);
        DecorationOverlayIcon decorationOverlayIcon = new DecorationOverlayIcon(image, this.descriptors, point);
        return resourceManager.createImage((ImageDescriptor)decorationOverlayIcon);
    }

    public String decorateWithText(String string) {
        if (this.prefixes.isEmpty() && this.suffixes.isEmpty()) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        ListIterator listIterator = this.prefixes.listIterator();
        while (listIterator.hasNext()) {
            stringBuffer.append(listIterator.next());
        }
        stringBuffer.append(string);
        ListIterator listIterator2 = this.suffixes.listIterator();
        while (listIterator2.hasNext()) {
            stringBuffer.append(listIterator2.next());
        }
        return stringBuffer.toString();
    }

    ImageDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    List getPrefixes() {
        return this.prefixes;
    }

    List getSuffixes() {
        return this.suffixes;
    }

    Color getBackgroundColor() {
        return this.backgroundColor;
    }

    Font getFont() {
        return this.font;
    }

    Color getForegroundColor() {
        return this.foregroundColor;
    }
}

