/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.WorkbenchMessages;

class DecorationReference {
    Object element;
    Object adaptedElement;
    String undecoratedText;
    boolean forceUpdate = false;
    IDecorationContext[] contexts;

    DecorationReference(Object object, Object object2, IDecorationContext iDecorationContext) {
        this.contexts = new IDecorationContext[]{iDecorationContext};
        Assert.isNotNull((Object)object);
        this.element = object;
        this.adaptedElement = object2;
    }

    Object getAdaptedElement() {
        return this.adaptedElement;
    }

    Object getElement() {
        return this.element;
    }

    boolean shouldForceUpdate() {
        return this.forceUpdate;
    }

    void setForceUpdate(boolean bl) {
        this.forceUpdate = bl;
    }

    void setUndecoratedText(String string) {
        this.undecoratedText = string;
    }

    String getSubTask() {
        if (this.undecoratedText == null) {
            return WorkbenchMessages.DecorationReference_EmptyReference;
        }
        return NLS.bind((String)WorkbenchMessages.DecorationScheduler_DecoratingSubtask, (Object)this.undecoratedText);
    }

    IDecorationContext[] getContexts() {
        return this.contexts;
    }

    void addContext(IDecorationContext iDecorationContext) {
        IDecorationContext[] iDecorationContextArray = new IDecorationContext[this.contexts.length + 1];
        System.arraycopy(this.contexts, 0, iDecorationContextArray, 0, this.contexts.length);
        iDecorationContextArray[this.contexts.length] = iDecorationContext;
        this.contexts = iDecorationContextArray;
    }
}

