/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

class DecorationImageBuilder {
    private static final int TOP_LEFT = 0;
    private static final int TOP_RIGHT = 1;
    private static final int BOTTOM_LEFT = 2;
    private static final int BOTTOM_RIGHT = 3;
    private static final int UNDERLAY = 4;
    private static final PaletteData ALPHA_PALETTE;
    private static final PaletteData BW_PALETTE;

    static {
        RGB[] rGBArray = new RGB[256];
        int n = 0;
        while (n < rGBArray.length) {
            rGBArray[n] = new RGB(n, n, n);
            ++n;
        }
        ALPHA_PALETTE = new PaletteData(rGBArray);
        BW_PALETTE = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
    }

    DecorationImageBuilder() {
    }

    private static int getTransparencyDepth(ImageData imageData) {
        if (imageData.maskData != null && imageData.depth == 32) {
            int n = 0;
            while (n < imageData.data.length) {
                if (imageData.data[n] != 0) {
                    return 8;
                }
                n += 4;
            }
        }
        if (imageData.maskData != null || imageData.transparentPixel != -1) {
            return 1;
        }
        if (imageData.alpha != -1 || imageData.alphaData != null) {
            return 8;
        }
        return 0;
    }

    private static ImageData getTransparency(ImageData imageData, int n) {
        if (imageData == null) {
            return null;
        }
        if (n == 1) {
            return imageData.getTransparencyMask();
        }
        ImageData imageData2 = null;
        if (imageData.maskData != null && imageData.depth == 32) {
            ImageData imageData3 = imageData.getTransparencyMask();
            imageData2 = new ImageData(imageData.width, imageData.height, 8, ALPHA_PALETTE, imageData.width, new byte[imageData.width * imageData.height]);
            int n2 = 0;
            while (n2 < imageData.height) {
                int n3 = 0;
                while (n3 < imageData.width) {
                    int n4 = imageData.getPixel(n3, n2) & 0xFF;
                    if (n4 == 0 && imageData3.getPixel(n3, n2) != 0) {
                        n4 = 255;
                    }
                    imageData2.setPixel(n3, n2, n4);
                    ++n3;
                }
                ++n2;
            }
        } else if (imageData.maskData != null || imageData.transparentPixel != -1) {
            ImageData imageData4 = imageData.getTransparencyMask();
            imageData2 = new ImageData(imageData.width, imageData.height, 8, ALPHA_PALETTE, imageData.width, new byte[imageData.width * imageData.height]);
            int n5 = 0;
            while (n5 < imageData2.height) {
                int n6 = 0;
                while (n6 < imageData2.width) {
                    imageData2.setPixel(n6, n5, imageData4.getPixel(n6, n5) != 0 ? -1 : 0);
                    ++n6;
                }
                ++n5;
            }
        } else if (imageData.alpha != -1) {
            imageData2 = new ImageData(imageData.width, imageData.height, 8, ALPHA_PALETTE, imageData.width, new byte[imageData.width * imageData.height]);
            int n7 = 0;
            while (n7 < imageData2.data.length) {
                imageData2.data[n7] = (byte)imageData.alpha;
                ++n7;
            }
        } else if (imageData.alphaData != null) {
            imageData2 = new ImageData(imageData.width, imageData.height, 8, ALPHA_PALETTE, imageData.width, imageData.alphaData);
        } else {
            imageData2 = new ImageData(imageData.width, imageData.height, 8, ALPHA_PALETTE, imageData.width, new byte[imageData.width * imageData.height]);
            int n8 = 0;
            while (n8 < imageData2.data.length) {
                imageData2.data[n8] = -1;
                ++n8;
            }
        }
        return imageData2;
    }

    private static void composite(ImageData imageData, ImageData imageData2, int n, int n2) {
        block7: {
            block6: {
                if (imageData.depth != 1) break block6;
                int n3 = 0;
                int n4 = n3 + n2;
                while (n3 < imageData2.height) {
                    int n5 = 0;
                    int n6 = n5 + n;
                    while (n5 < imageData2.width) {
                        if (n6 >= 0 && n6 < imageData.width && n4 >= 0 && n4 < imageData.height && imageData2.getPixel(n5, n3) != 0) {
                            imageData.setPixel(n6, n4, 1);
                        }
                        ++n5;
                        ++n6;
                    }
                    ++n3;
                    ++n4;
                }
                break block7;
            }
            if (imageData.depth != 8) break block7;
            int n7 = 0;
            int n8 = n7 + n2;
            while (n7 < imageData2.height) {
                int n9 = 0;
                int n10 = n9 + n;
                while (n9 < imageData2.width) {
                    if (n10 >= 0 && n10 < imageData.width && n8 >= 0 && n8 < imageData.height) {
                        int n11 = imageData2.getPixel(n9, n7);
                        int n12 = imageData.getPixel(n10, n8);
                        n12 += (n11 - n12) * n11 / 255;
                        imageData.setPixel(n10, n8, n12);
                    }
                    ++n9;
                    ++n10;
                }
                ++n7;
                ++n8;
            }
        }
    }

    static Image compositeImage(Device device, ImageData imageData, ImageData[] imageDataArray) {
        ImageData imageData2;
        ImageData imageData3;
        ImageData imageData4;
        ImageData imageData5;
        ImageData imageData6;
        if (imageData == null) {
            return null;
        }
        Image image = new Image(device, new ImageData(imageData.width, imageData.height, 24, new PaletteData(255, 65280, 0xFF00000)));
        GC gC = new GC((Drawable)image);
        int n = 0;
        int n2 = 0;
        ImageData imageData7 = imageDataArray.length > 4 ? imageDataArray[4] : null;
        ImageData imageData8 = imageData7;
        if (imageData7 != null) {
            n = Math.max(n, DecorationImageBuilder.getTransparencyDepth(imageData7));
            imageData6 = new Image(device, imageData7);
            gC.drawImage((Image)imageData6, 0, 0);
            imageData6.dispose();
        }
        imageData7 = imageData;
        if (imageData != null) {
            n2 = DecorationImageBuilder.getTransparencyDepth(imageData7);
            n = Math.max(n, n2);
            imageData6 = new Image(device, imageData7);
            gC.drawImage((Image)imageData6, 0, 0);
            imageData6.dispose();
        }
        imageData6 = imageData7 = imageDataArray[0];
        if (imageData7 != null) {
            n = Math.max(n, DecorationImageBuilder.getTransparencyDepth(imageData7));
            imageData5 = new Image(device, imageData7);
            gC.drawImage((Image)imageData5, 0, 0);
            imageData5.dispose();
        }
        imageData5 = imageData7 = imageDataArray[1];
        if (imageData7 != null) {
            n = Math.max(n, DecorationImageBuilder.getTransparencyDepth(imageData7));
            imageData4 = new Image(device, imageData7);
            gC.drawImage((Image)imageData4, imageData.width - imageData7.width, 0);
            imageData4.dispose();
        }
        imageData4 = imageData7 = imageDataArray[2];
        if (imageData7 != null) {
            n = Math.max(n, DecorationImageBuilder.getTransparencyDepth(imageData7));
            imageData3 = new Image(device, imageData7);
            gC.drawImage((Image)imageData3, 0, imageData.height - imageData7.height);
            imageData3.dispose();
        }
        imageData3 = imageData7 = imageDataArray[3];
        if (imageData7 != null) {
            n = Math.max(n, DecorationImageBuilder.getTransparencyDepth(imageData7));
            imageData2 = new Image(device, imageData7);
            gC.drawImage((Image)imageData2, imageData.width - imageData7.width, imageData.height - imageData7.height);
            imageData2.dispose();
        }
        gC.dispose();
        if (n2 > 0) {
            imageData2 = image.getImageData();
            image.dispose();
            ImageData imageData9 = null;
            switch (n) {
                case 1: {
                    imageData9 = new ImageData(imageData.width, imageData.height, n, BW_PALETTE);
                    break;
                }
                case 8: {
                    imageData9 = new ImageData(imageData.width, imageData.height, n, ALPHA_PALETTE, imageData.width, new byte[imageData.width * imageData.height]);
                }
            }
            imageData7 = DecorationImageBuilder.getTransparency(imageData8, n);
            if (imageData7 != null) {
                DecorationImageBuilder.composite(imageData9, imageData7, 0, 0);
            }
            if ((imageData7 = DecorationImageBuilder.getTransparency(imageData, n)) != null) {
                DecorationImageBuilder.composite(imageData9, imageData7, 0, 0);
            }
            if ((imageData7 = DecorationImageBuilder.getTransparency(imageData6, n)) != null) {
                DecorationImageBuilder.composite(imageData9, imageData7, 0, 0);
            }
            if ((imageData7 = DecorationImageBuilder.getTransparency(imageData5, n)) != null) {
                DecorationImageBuilder.composite(imageData9, imageData7, imageData9.width - imageData7.width, 0);
            }
            if ((imageData7 = DecorationImageBuilder.getTransparency(imageData4, n)) != null) {
                DecorationImageBuilder.composite(imageData9, imageData7, 0, imageData9.height - imageData7.height);
            }
            if ((imageData7 = DecorationImageBuilder.getTransparency(imageData3, n)) != null) {
                DecorationImageBuilder.composite(imageData9, imageData7, imageData9.width - imageData7.width, imageData9.height - imageData7.height);
            }
            switch (n) {
                case 1: {
                    imageData2.maskData = imageData9.data;
                    imageData2.maskPad = imageData9.scanlinePad;
                    break;
                }
                case 8: {
                    imageData2.alphaData = imageData9.data;
                }
            }
            image = new Image(device, imageData2);
        }
        return image;
    }
}

