/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.decorators.DecorationResult;
import org.eclipse.ui.internal.decorators.LightweightDecoratorDefinition;

public class DecorationBuilder
implements IDecoration {
    private static int DECORATOR_ARRAY_SIZE = 6;
    private List prefixes = new ArrayList();
    private List suffixes = new ArrayList();
    private ImageDescriptor[] descriptors = new ImageDescriptor[DECORATOR_ARRAY_SIZE];
    private Color foregroundColor;
    private Color backgroundColor;
    private Font font;
    LightweightDecoratorDefinition currentDefinition;
    private boolean valueSet = false;
    private final IDecorationContext context;

    DecorationBuilder() {
        this(DecorationContext.DEFAULT_CONTEXT);
    }

    public DecorationBuilder(IDecorationContext iDecorationContext) {
        this.context = iDecorationContext;
    }

    void setCurrentDefinition(LightweightDecoratorDefinition lightweightDecoratorDefinition) {
        this.currentDefinition = lightweightDecoratorDefinition;
    }

    public void addOverlay(ImageDescriptor imageDescriptor) {
        int n = this.currentDefinition.getQuadrant();
        if (this.descriptors[n] == null) {
            this.descriptors[n] = imageDescriptor;
        }
        this.valueSet = true;
    }

    public void addOverlay(ImageDescriptor imageDescriptor, int n) {
        if (n >= 0 && n < DECORATOR_ARRAY_SIZE) {
            if (this.descriptors[n] == null) {
                this.descriptors[n] = imageDescriptor;
            }
            this.valueSet = true;
        } else {
            WorkbenchPlugin.log("Unable to apply decoration for " + this.currentDefinition.getId() + " invalid quadrant: " + n);
        }
    }

    public void addPrefix(String string) {
        this.prefixes.add(string);
        this.valueSet = true;
    }

    public void addSuffix(String string) {
        this.suffixes.add(string);
        this.valueSet = true;
    }

    DecorationResult createResult() {
        Object object;
        boolean bl = true;
        if (this.context != null && (object = this.context.getProperty("org.eclipse.jface.viewers.IDecoration.disableReplace")) instanceof Boolean && ((Boolean)object).booleanValue()) {
            bl = false;
        }
        if (bl) {
            this.descriptors[5] = null;
        }
        object = new DecorationResult(new ArrayList(this.prefixes), new ArrayList(this.suffixes), this.descriptors, this.foregroundColor, this.backgroundColor, this.font);
        return object;
    }

    void clearContents() {
        this.prefixes.clear();
        this.suffixes.clear();
        this.descriptors = new ImageDescriptor[DECORATOR_ARRAY_SIZE];
        this.valueSet = false;
    }

    boolean hasValue() {
        return this.valueSet;
    }

    void applyResult(DecorationResult decorationResult) {
        this.prefixes.addAll(decorationResult.getPrefixes());
        this.suffixes.addAll(decorationResult.getSuffixes());
        ImageDescriptor[] imageDescriptorArray = decorationResult.getDescriptors();
        if (imageDescriptorArray != null) {
            int n = 0;
            while (n < this.descriptors.length) {
                if (imageDescriptorArray[n] != null) {
                    this.descriptors[n] = imageDescriptorArray[n];
                }
                ++n;
            }
        }
        this.setForegroundColor(decorationResult.getForegroundColor());
        this.setBackgroundColor(decorationResult.getBackgroundColor());
        this.setFont(decorationResult.getFont());
        this.valueSet = true;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
        this.valueSet = true;
    }

    public void setFont(Font font) {
        this.font = font;
        this.valueSet = true;
    }

    public void setForegroundColor(Color color) {
        this.foregroundColor = color;
        this.valueSet = true;
    }

    public IDecorationContext getDecorationContext() {
        return this.context;
    }
}

