/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.LegacyHandlerSubmissionExpression;
import org.eclipse.ui.contexts.EnabledSubmission;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextManager;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.contexts.IWorkbenchContextSupport;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.contexts.ContextManagerFactory;
import org.eclipse.ui.internal.contexts.ContextManagerLegacyWrapper;
import org.eclipse.ui.keys.IBindingService;

public class WorkbenchContextSupport
implements IWorkbenchContextSupport {
    private Map activationsBySubmission = null;
    private IBindingService bindingService;
    private IContextService contextService;
    private ContextManagerLegacyWrapper contextManagerWrapper;
    private final Workbench workbench;

    public WorkbenchContextSupport(Workbench workbench, ContextManager contextManager) {
        this.workbench = workbench;
        this.contextService = (IContextService)this.workbench.getService(IContextService.class);
        this.bindingService = (IBindingService)this.workbench.getService(IBindingService.class);
        this.contextManagerWrapper = ContextManagerFactory.getContextManagerWrapper(contextManager);
    }

    @Override
    public final void addEnabledSubmission(EnabledSubmission enabledSubmission) {
        IContextActivation iContextActivation = this.contextService.activateContext(enabledSubmission.getContextId(), new LegacyHandlerSubmissionExpression(enabledSubmission.getActivePartId(), enabledSubmission.getActiveShell(), enabledSubmission.getActiveWorkbenchPartSite()));
        if (this.activationsBySubmission == null) {
            this.activationsBySubmission = new HashMap();
        }
        this.activationsBySubmission.put(enabledSubmission, iContextActivation);
    }

    @Override
    public final void addEnabledSubmissions(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addEnabledSubmission((EnabledSubmission)iterator.next());
        }
    }

    @Override
    public final IContextManager getContextManager() {
        return this.contextManagerWrapper;
    }

    @Override
    public final int getShellType(Shell shell) {
        return this.contextService.getShellType(shell);
    }

    @Override
    public final boolean isKeyFilterEnabled() {
        return this.bindingService.isKeyFilterEnabled();
    }

    @Override
    public final void openKeyAssistDialog() {
        this.bindingService.openKeyAssistDialog();
    }

    @Override
    public final boolean registerShell(Shell shell, int n) {
        return this.contextService.registerShell(shell, n);
    }

    @Override
    public final void removeEnabledSubmission(EnabledSubmission enabledSubmission) {
        if (this.activationsBySubmission == null) {
            return;
        }
        Object v = this.activationsBySubmission.remove(enabledSubmission);
        if (v instanceof IContextActivation) {
            IContextActivation iContextActivation = (IContextActivation)v;
            this.contextService.deactivateContext(iContextActivation);
        }
    }

    @Override
    public final void removeEnabledSubmissions(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeEnabledSubmission((EnabledSubmission)iterator.next());
        }
    }

    @Override
    public final void setKeyFilterEnabled(boolean bl) {
        this.bindingService.setKeyFilterEnabled(bl);
    }

    @Override
    public final boolean unregisterShell(Shell shell) {
        return this.contextService.unregisterShell(shell);
    }
}

