/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.core.expressions.Expression;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.contexts.ContextActivation;
import org.eclipse.ui.internal.expressions.AndExpression;
import org.eclipse.ui.internal.expressions.CompositeExpression;

public class SlaveContextService
implements IContextService {
    protected IContextService fParentService;
    protected Expression fDefaultExpression;
    protected Set fParentActivations;
    protected Map fLocalActivations;
    private Collection fContextManagerListeners;
    private Collection fSourceProviders;
    private Collection fRegisteredShells;

    public SlaveContextService(IContextService iContextService, Expression expression) {
        if (iContextService == null) {
            throw new NullPointerException("The parent context service must not be null");
        }
        this.fParentService = iContextService;
        this.fDefaultExpression = expression;
        this.fParentActivations = new HashSet();
        this.fLocalActivations = new HashMap();
        this.fContextManagerListeners = new ArrayList();
        this.fSourceProviders = new ArrayList();
        this.fRegisteredShells = new ArrayList();
    }

    @Override
    public void deferUpdates(boolean bl) {
        this.fParentService.deferUpdates(bl);
    }

    @Override
    public IContextActivation activateContext(String string) {
        ContextActivation contextActivation = new ContextActivation(string, this.fDefaultExpression, this);
        return this.doActivateContext(contextActivation);
    }

    @Override
    public IContextActivation activateContext(String string, Expression expression) {
        return this.activateContext(string, expression, false);
    }

    @Override
    public IContextActivation activateContext(String string, Expression expression, boolean bl) {
        Object object;
        if (bl) {
            IContextActivation iContextActivation = this.fParentService.activateContext(string, expression, bl);
            this.fParentActivations.add(iContextActivation);
            return iContextActivation;
        }
        Object object2 = this.fDefaultExpression;
        if (expression != null && this.fDefaultExpression != null) {
            object = new AndExpression();
            ((CompositeExpression)((Object)object)).add(expression);
            ((CompositeExpression)((Object)object)).add(this.fDefaultExpression);
            object2 = object;
        } else if (expression != null) {
            object2 = expression;
        }
        object = new ContextActivation(string, (Expression)object2, this);
        return this.doActivateContext((IContextActivation)object);
    }

    @Override
    public IContextActivation activateContext(String string, Expression expression, int n) {
        return this.activateContext(string, expression);
    }

    @Override
    public void addContextManagerListener(IContextManagerListener iContextManagerListener) {
        if (!this.fContextManagerListeners.contains(iContextManagerListener)) {
            this.fContextManagerListeners.add(iContextManagerListener);
        }
        this.fParentService.addContextManagerListener(iContextManagerListener);
    }

    @Override
    public void addSourceProvider(ISourceProvider iSourceProvider) {
        if (!this.fSourceProviders.contains(iSourceProvider)) {
            this.fSourceProviders.add(iSourceProvider);
        }
        this.fParentService.addSourceProvider(iSourceProvider);
    }

    @Override
    public void deactivateContext(IContextActivation iContextActivation) {
        IContextActivation iContextActivation2 = null;
        iContextActivation2 = this.fLocalActivations.containsKey(iContextActivation) ? (IContextActivation)this.fLocalActivations.remove(iContextActivation) : iContextActivation;
        if (iContextActivation2 != null) {
            this.fParentService.deactivateContext(iContextActivation2);
            this.fParentActivations.remove(iContextActivation2);
        }
    }

    @Override
    public void deactivateContexts(Collection collection) {
        Object[] objectArray = collection.toArray();
        int n = 0;
        while (n < objectArray.length) {
            this.deactivateContext((IContextActivation)objectArray[n]);
            objectArray[n] = null;
            ++n;
        }
    }

    @Override
    public void dispose() {
        int n;
        Object[] objectArray;
        this.fParentService.deactivateContexts(this.fParentActivations);
        this.fParentActivations.clear();
        this.fLocalActivations.clear();
        if (!this.fContextManagerListeners.isEmpty()) {
            objectArray = this.fContextManagerListeners.toArray();
            n = 0;
            while (n < objectArray.length) {
                this.removeContextManagerListener((IContextManagerListener)objectArray[n]);
                ++n;
            }
            this.fContextManagerListeners.clear();
        }
        if (!this.fSourceProviders.isEmpty()) {
            objectArray = this.fSourceProviders.toArray();
            n = 0;
            while (n < objectArray.length) {
                this.removeSourceProvider((ISourceProvider)objectArray[n]);
                ++n;
            }
            this.fSourceProviders.clear();
        }
        if (!this.fRegisteredShells.isEmpty()) {
            objectArray = this.fRegisteredShells.toArray();
            n = 0;
            while (n < objectArray.length) {
                this.unregisterShell((Shell)objectArray[n]);
                ++n;
            }
            this.fRegisteredShells.clear();
        }
    }

    protected IContextActivation doActivateContext(IContextActivation iContextActivation) {
        IContextActivation iContextActivation2 = this.fParentService.activateContext(iContextActivation.getContextId(), iContextActivation.getExpression());
        this.fParentActivations.add(iContextActivation2);
        this.fLocalActivations.put(iContextActivation, iContextActivation2);
        return iContextActivation;
    }

    @Override
    public Collection getActiveContextIds() {
        return this.fParentService.getActiveContextIds();
    }

    @Override
    public Context getContext(String string) {
        return this.fParentService.getContext(string);
    }

    @Override
    public Collection getDefinedContextIds() {
        return this.fParentService.getDefinedContextIds();
    }

    @Override
    public Context[] getDefinedContexts() {
        return this.fParentService.getDefinedContexts();
    }

    @Override
    public int getShellType(Shell shell) {
        return this.fParentService.getShellType(shell);
    }

    @Override
    public void readRegistry() {
        this.fParentService.readRegistry();
    }

    @Override
    public boolean registerShell(Shell shell, int n) {
        if (!this.fRegisteredShells.contains(shell)) {
            this.fRegisteredShells.add(shell);
        }
        return this.fParentService.registerShell(shell, n);
    }

    @Override
    public void removeContextManagerListener(IContextManagerListener iContextManagerListener) {
        this.fContextManagerListeners.remove(iContextManagerListener);
        this.fParentService.removeContextManagerListener(iContextManagerListener);
    }

    @Override
    public void removeSourceProvider(ISourceProvider iSourceProvider) {
        this.fSourceProviders.remove(iSourceProvider);
        this.fParentService.removeSourceProvider(iSourceProvider);
    }

    @Override
    public boolean unregisterShell(Shell shell) {
        this.fRegisteredShells.remove(shell);
        return this.fParentService.unregisterShell(shell);
    }
}

