/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.Iterator;
import org.eclipse.core.expressions.Expression;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.contexts.SlaveContextService;
import org.eclipse.ui.internal.services.INestable;

public class NestableContextService
extends SlaveContextService
implements INestable {
    private boolean fActive = false;

    public NestableContextService(IContextService iContextService, Expression expression) {
        super(iContextService, expression);
    }

    @Override
    protected IContextActivation doActivateContext(IContextActivation iContextActivation) {
        if (this.fActive) {
            return super.doActivateContext(iContextActivation);
        }
        this.fLocalActivations.put(iContextActivation, null);
        return iContextActivation;
    }

    @Override
    public void activate() {
        if (this.fActive) {
            return;
        }
        for (IContextActivation iContextActivation : this.fLocalActivations.keySet()) {
            super.doActivateContext(iContextActivation);
        }
        this.fActive = true;
    }

    @Override
    public void deactivate() {
        if (!this.fActive) {
            return;
        }
        this.deactivateContexts(this.fParentActivations);
        this.fParentActivations.clear();
        Iterator iterator = this.fLocalActivations.keySet().iterator();
        while (iterator.hasNext()) {
            this.fLocalActivations.put(iterator.next(), null);
        }
        this.fActive = false;
    }
}

