/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.Set;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.ui.contexts.ContextEvent;
import org.eclipse.ui.contexts.IContext;
import org.eclipse.ui.contexts.IContextListener;
import org.eclipse.ui.internal.contexts.ContextLegacyWrapper;

public class LegacyContextListenerWrapper
implements org.eclipse.core.commands.contexts.IContextListener,
IContextManagerListener {
    private final IContext context;
    private final ContextManager contextManager;
    private final IContextListener wrappedListener;

    public LegacyContextListenerWrapper(IContextListener iContextListener, ContextManager contextManager, IContext iContext) {
        if (iContextListener == null) {
            throw new NullPointerException("Cannot create a listener wrapper on a null listener");
        }
        if (contextManager == null) {
            throw new NullPointerException("Cannot create a listener wrapper with a null context manager");
        }
        if (iContext == null) {
            throw new NullPointerException("Cannot create a listener wrapper with a null context");
        }
        this.wrappedListener = iContextListener;
        this.contextManager = contextManager;
        this.context = iContext;
    }

    public final void contextChanged(org.eclipse.core.commands.contexts.ContextEvent contextEvent) {
        this.wrappedListener.contextChanged(new ContextEvent(new ContextLegacyWrapper(contextEvent.getContext(), this.contextManager), contextEvent.isDefinedChanged(), false, contextEvent.isNameChanged(), contextEvent.isParentIdChanged()));
    }

    public final void contextManagerChanged(ContextManagerEvent contextManagerEvent) {
        boolean bl;
        String string = this.context.getId();
        if (contextManagerEvent.isActiveContextsChanged()) {
            Set set = contextManagerEvent.getPreviouslyActiveContextIds();
            Set set2 = this.contextManager.getActiveContextIds();
            bl = set != null && set.contains(string) && (set2 == null || set2.contains(string)) ? true : set2 != null && set2.contains(string) && (set == null || set.contains(string));
        } else {
            bl = false;
        }
        this.wrappedListener.contextChanged(new ContextEvent(this.context, false, bl, false, false));
    }

    public final boolean equals(Object object) {
        if (object instanceof LegacyContextListenerWrapper) {
            LegacyContextListenerWrapper legacyContextListenerWrapper = (LegacyContextListenerWrapper)object;
            return this.wrappedListener.equals(legacyContextListenerWrapper.wrappedListener);
        }
        if (object instanceof IContextListener) {
            IContextListener iContextListener = (IContextListener)object;
            return this.wrappedListener.equals(iContextListener);
        }
        return false;
    }

    public final int hashCode() {
        return this.wrappedListener.hashCode();
    }
}

