/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.Collection;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.core.expressions.Expression;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.contexts.ContextActivation;
import org.eclipse.ui.internal.contexts.ContextAuthority;
import org.eclipse.ui.internal.contexts.ContextPersistence;

public final class ContextService
implements IContextService {
    private final ContextAuthority contextAuthority;
    private final ContextManager contextManager;
    private final ContextPersistence contextPersistence;

    public ContextService(ContextManager contextManager) {
        if (contextManager == null) {
            throw new NullPointerException("Cannot create a context service with a null manager");
        }
        this.contextManager = contextManager;
        this.contextAuthority = new ContextAuthority(contextManager, this);
        this.contextPersistence = new ContextPersistence(contextManager);
    }

    @Override
    public void deferUpdates(boolean bl) {
        this.contextManager.deferUpdates(bl);
    }

    @Override
    public final IContextActivation activateContext(String string) {
        return this.activateContext(string, null);
    }

    @Override
    public final IContextActivation activateContext(String string, Expression expression) {
        ContextActivation contextActivation = new ContextActivation(string, expression, this);
        this.contextAuthority.activateContext(contextActivation);
        return contextActivation;
    }

    @Override
    public IContextActivation activateContext(String string, Expression expression, boolean bl) {
        return this.activateContext(string, expression);
    }

    @Override
    public final IContextActivation activateContext(String string, Expression expression, int n) {
        return this.activateContext(string, expression);
    }

    @Override
    public final void addContextManagerListener(IContextManagerListener iContextManagerListener) {
        this.contextManager.addContextManagerListener(iContextManagerListener);
    }

    @Override
    public final void addSourceProvider(ISourceProvider iSourceProvider) {
        this.contextAuthority.addSourceProvider(iSourceProvider);
    }

    @Override
    public final void deactivateContext(IContextActivation iContextActivation) {
        if (iContextActivation.getContextService() == this) {
            this.contextAuthority.deactivateContext(iContextActivation);
        }
    }

    @Override
    public final void deactivateContexts(Collection collection) {
        for (IContextActivation iContextActivation : collection) {
            this.deactivateContext(iContextActivation);
        }
    }

    @Override
    public final void dispose() {
        this.contextPersistence.dispose();
        this.contextAuthority.dispose();
    }

    @Override
    public final Collection getActiveContextIds() {
        return this.contextManager.getActiveContextIds();
    }

    @Override
    public final Context getContext(String string) {
        return this.contextManager.getContext(string);
    }

    @Override
    public final Collection getDefinedContextIds() {
        return this.contextManager.getDefinedContextIds();
    }

    @Override
    public final Context[] getDefinedContexts() {
        return this.contextManager.getDefinedContexts();
    }

    @Override
    public final int getShellType(Shell shell) {
        return this.contextAuthority.getShellType(shell);
    }

    @Override
    public final void readRegistry() {
        this.contextPersistence.read();
    }

    @Override
    public final boolean registerShell(Shell shell, int n) {
        return this.contextAuthority.registerShell(shell, n);
    }

    @Override
    public final void removeContextManagerListener(IContextManagerListener iContextManagerListener) {
        this.contextManager.removeContextManagerListener(iContextManagerListener);
    }

    @Override
    public final void removeSourceProvider(ISourceProvider iSourceProvider) {
        this.contextAuthority.removeSourceProvider(iSourceProvider);
    }

    @Override
    public final boolean unregisterShell(Shell shell) {
        return this.contextAuthority.unregisterShell(shell);
    }

    public final void updateShellKludge() {
        this.contextAuthority.updateShellKludge();
    }

    public final void updateShellKludge(Shell shell) {
        Shell shell2 = this.contextAuthority.getActiveShell();
        if (shell2 != shell) {
            this.contextAuthority.sourceChanged(1024, "activeShell", shell);
        }
    }
}

