/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.ArrayList;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.services.RegistryPersistence;

final class ContextPersistence
extends RegistryPersistence {
    private static final int INDEX_CONTEXT_DEFINITIONS = 0;
    private final ContextManager contextManager;

    private static final void readContextsFromRegistry(IConfigurationElement[] iConfigurationElementArray, int n, ContextManager contextManager) {
        Context[] contextArray = contextManager.getDefinedContexts();
        if (contextArray != null) {
            int n2 = 0;
            while (n2 < contextArray.length) {
                contextArray[n2].undefine();
                ++n2;
            }
        }
        ArrayList arrayList = new ArrayList(1);
        int n3 = 0;
        while (n3 < n) {
            String string;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n3];
            String string2 = ContextPersistence.readRequired(iConfigurationElement, "id", arrayList, "Contexts need an id");
            if (string2 != null && (string = ContextPersistence.readRequired(iConfigurationElement, "name", arrayList, "Contexts need a name", string2)) != null) {
                String string3 = ContextPersistence.readOptional(iConfigurationElement, "description");
                String string4 = iConfigurationElement.getAttribute("parentId");
                if (!(string4 != null && string4.length() != 0 || (string4 = iConfigurationElement.getAttribute("parent")) != null && string4.length() != 0)) {
                    string4 = iConfigurationElement.getAttribute("parentScope");
                }
                if (string4 != null && string4.length() == 0) {
                    string4 = null;
                }
                Context context = contextManager.getContext(string2);
                context.define(string, string3, string4);
            }
            ++n3;
        }
        ContextPersistence.logWarnings(arrayList, "Warnings while parsing the contexts from the 'org.eclipse.ui.contexts', 'org.eclipse.ui.commands' and 'org.eclipse.ui.acceleratorScopes' extension points.");
    }

    ContextPersistence(ContextManager contextManager) {
        if (contextManager == null) {
            throw new NullPointerException("The context manager must not be null");
        }
        this.contextManager = contextManager;
    }

    @Override
    protected final boolean isChangeImportant(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray;
        IExtensionDelta[] iExtensionDeltaArray2;
        IExtensionDelta[] iExtensionDeltaArray3 = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "acceleratorScopes");
        return iExtensionDeltaArray3.length != 0 || (iExtensionDeltaArray2 = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "contexts")).length != 0 || (iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "commands")).length != 0;
    }

    @Override
    protected final void read() {
        String string;
        String string2;
        super.read();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        int n = 0;
        IConfigurationElement[][] iConfigurationElementArrayArray = new IConfigurationElement[1][];
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.acceleratorScopes");
        int n2 = 0;
        while (n2 < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            string2 = iConfigurationElement.getName();
            if ("acceleratorScope".equals(string2)) {
                ContextPersistence.addElementToIndexedArray(iConfigurationElement, iConfigurationElementArrayArray, 0, n++);
            }
            ++n2;
        }
        IConfigurationElement[] iConfigurationElementArray2 = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.commands");
        int n3 = 0;
        while (n3 < iConfigurationElementArray2.length) {
            string2 = iConfigurationElementArray2[n3];
            string = string2.getName();
            if ("scope".equals(string)) {
                ContextPersistence.addElementToIndexedArray((IConfigurationElement)string2, iConfigurationElementArrayArray, 0, n++);
            } else if ("context".equals(string)) {
                ContextPersistence.addElementToIndexedArray((IConfigurationElement)string2, iConfigurationElementArrayArray, 0, n++);
            }
            ++n3;
        }
        IConfigurationElement[] iConfigurationElementArray3 = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.contexts");
        int n4 = 0;
        while (n4 < iConfigurationElementArray3.length) {
            string = iConfigurationElementArray3[n4];
            String string3 = string.getName();
            if ("context".equals(string3)) {
                ContextPersistence.addElementToIndexedArray((IConfigurationElement)string, iConfigurationElementArrayArray, 0, n++);
            }
            ++n4;
        }
        ContextPersistence.readContextsFromRegistry(iConfigurationElementArrayArray[0], n, this.contextManager);
    }
}

