/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.ui.contexts.IContext;
import org.eclipse.ui.contexts.IContextManager;
import org.eclipse.ui.contexts.IContextManagerListener;
import org.eclipse.ui.internal.contexts.ContextLegacyWrapper;

public final class ContextManagerLegacyWrapper
implements org.eclipse.core.commands.contexts.IContextManagerListener,
IContextManager {
    private final ContextManager contextManager;
    private List contextManagerListeners;

    public ContextManagerLegacyWrapper(ContextManager contextManager) {
        if (contextManager == null) {
            throw new NullPointerException("The context manager cannot be null");
        }
        this.contextManager = contextManager;
        this.contextManager.addContextManagerListener((org.eclipse.core.commands.contexts.IContextManagerListener)this);
    }

    @Override
    public void addContextManagerListener(IContextManagerListener iContextManagerListener) {
        if (iContextManagerListener == null) {
            throw new NullPointerException();
        }
        if (this.contextManagerListeners == null) {
            this.contextManagerListeners = new ArrayList();
        }
        if (!this.contextManagerListeners.contains(iContextManagerListener)) {
            this.contextManagerListeners.add(iContextManagerListener);
        }
    }

    public void contextManagerChanged(ContextManagerEvent contextManagerEvent) {
        HashSet<String> hashSet;
        boolean bl;
        String string = contextManagerEvent.getContextId();
        if (string == null) {
            bl = false;
            hashSet = null;
        } else {
            bl = true;
            hashSet = new HashSet<String>();
            hashSet.addAll(this.contextManager.getDefinedContextIds());
            if (contextManagerEvent.isContextDefined()) {
                hashSet.remove(string);
            } else {
                hashSet.add(string);
            }
        }
        this.fireContextManagerChanged(new org.eclipse.ui.contexts.ContextManagerEvent(this, bl, contextManagerEvent.isActiveContextsChanged(), hashSet, contextManagerEvent.getPreviouslyActiveContextIds()));
    }

    protected void fireContextManagerChanged(org.eclipse.ui.contexts.ContextManagerEvent contextManagerEvent) {
        if (contextManagerEvent == null) {
            throw new NullPointerException();
        }
        if (this.contextManagerListeners != null) {
            int n = 0;
            while (n < this.contextManagerListeners.size()) {
                ((IContextManagerListener)this.contextManagerListeners.get(n)).contextManagerChanged(contextManagerEvent);
                ++n;
            }
        }
    }

    @Override
    public IContext getContext(String string) {
        return new ContextLegacyWrapper(this.contextManager.getContext(string), this.contextManager);
    }

    @Override
    public SortedSet getDefinedContextIds() {
        return new DepthSortedContextIdSet(this.contextManager.getDefinedContextIds());
    }

    @Override
    public SortedSet getEnabledContextIds() {
        return new DepthSortedContextIdSet(this.contextManager.getActiveContextIds());
    }

    @Override
    public void removeContextManagerListener(IContextManagerListener iContextManagerListener) {
        if (iContextManagerListener == null) {
            throw new NullPointerException();
        }
        if (this.contextManagerListeners != null) {
            this.contextManagerListeners.remove(iContextManagerListener);
        }
    }

    public void setEnabledContextIds(Set set) {
        this.contextManager.setActiveContextIds(set);
    }

    private class ContextIdDepthComparator
    implements Comparator {
        private ContextIdDepthComparator() {
        }

        public final int compare(Object object, Object object2) {
            String string;
            String string2 = (String)object;
            String string3 = (String)object2;
            int n = 0;
            Context context = ContextManagerLegacyWrapper.this.contextManager.getContext(string2);
            try {
                string = context.getParentId();
                while (string != null) {
                    ++n;
                    context = ContextManagerLegacyWrapper.this.contextManager.getContext(string);
                    string = context.getParentId();
                }
            }
            catch (NotDefinedException notDefinedException) {}
            int n2 = 0;
            context = ContextManagerLegacyWrapper.this.contextManager.getContext(string3);
            try {
                string = context.getParentId();
                while (string != null) {
                    ++n2;
                    context = ContextManagerLegacyWrapper.this.contextManager.getContext(string);
                    string = context.getParentId();
                }
            }
            catch (NotDefinedException notDefinedException) {}
            int n3 = n2 - n;
            if (n3 == 0) {
                n3 = string2.compareTo(string3);
            }
            return n3;
        }
    }

    private class DepthSortedContextIdSet
    extends TreeSet {
        private static final long serialVersionUID = 3257291326872892465L;

        private DepthSortedContextIdSet(Set set) {
            super(new ContextIdDepthComparator());
            this.addAll(set);
        }
    }
}

