/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.ui.contexts.IContext;
import org.eclipse.ui.contexts.IContextListener;
import org.eclipse.ui.contexts.NotDefinedException;
import org.eclipse.ui.internal.contexts.LegacyContextListenerWrapper;
import org.eclipse.ui.internal.util.Util;

public class ContextLegacyWrapper
implements IContext {
    private final ContextManager contextManager;
    private final Context wrappedContext;

    public ContextLegacyWrapper(Context context, ContextManager contextManager) {
        if (context == null) {
            throw new NullPointerException("A wrapper cannot be created on a null context");
        }
        if (contextManager == null) {
            throw new NullPointerException("A wrapper cannot be created with a null manager");
        }
        this.wrappedContext = context;
        this.contextManager = contextManager;
    }

    @Override
    public void addContextListener(IContextListener iContextListener) {
        LegacyContextListenerWrapper legacyContextListenerWrapper = new LegacyContextListenerWrapper(iContextListener, this.contextManager, this);
        this.wrappedContext.addContextListener((org.eclipse.core.commands.contexts.IContextListener)legacyContextListenerWrapper);
        this.contextManager.addContextManagerListener((IContextManagerListener)legacyContextListenerWrapper);
    }

    public int compareTo(Object object) {
        return Util.compare((Comparable)this.wrappedContext, (Comparable)((ContextLegacyWrapper)object).wrappedContext);
    }

    @Override
    public String getId() {
        return this.wrappedContext.getId();
    }

    @Override
    public String getName() throws NotDefinedException {
        try {
            return this.wrappedContext.getName();
        }
        catch (org.eclipse.core.commands.common.NotDefinedException notDefinedException) {
            throw new NotDefinedException(notDefinedException);
        }
    }

    @Override
    public String getParentId() throws NotDefinedException {
        try {
            return this.wrappedContext.getParentId();
        }
        catch (org.eclipse.core.commands.common.NotDefinedException notDefinedException) {
            throw new NotDefinedException(notDefinedException);
        }
    }

    @Override
    public boolean isDefined() {
        return this.wrappedContext.isDefined();
    }

    @Override
    public boolean isEnabled() {
        return this.contextManager.getActiveContextIds().contains(this.wrappedContext.getId());
    }

    @Override
    public void removeContextListener(IContextListener iContextListener) {
        LegacyContextListenerWrapper legacyContextListenerWrapper = new LegacyContextListenerWrapper(iContextListener, this.contextManager, this);
        this.wrappedContext.removeContextListener((org.eclipse.core.commands.contexts.IContextListener)legacyContextListenerWrapper);
        this.contextManager.removeContextManagerListener((IContextManagerListener)legacyContextListenerWrapper);
    }
}

