/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.contexts.ContextActivation;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.services.ExpressionAuthority;
import org.eclipse.ui.internal.services.IEvaluationResultCache;

public final class ContextAuthority
extends ExpressionAuthority {
    private static final int ACTIVATIONS_TO_RECOMPUTE_SIZE = 4;
    private static final boolean DEBUG = Policy.DEBUG_CONTEXTS;
    private static final boolean DEBUG_PERFORMANCE = Policy.DEBUG_CONTEXTS_PERFORMANCE;
    private static final String DISPOSE_LISTENER = "org.eclipse.ui.internal.contexts.ContextAuthority";
    private static final String TRACING_COMPONENT = "CONTEXTS";
    private final Set[] activationsBySourcePriority = new Set[33];
    private final Map contextActivationsByContextId = new HashMap();
    private final ContextManager contextManager;
    private final IContextService contextService;
    private final Map registeredWindows = new WeakHashMap();

    ContextAuthority(ContextManager contextManager, IContextService iContextService) {
        if (contextManager == null) {
            throw new NullPointerException("The context authority needs a context manager");
        }
        if (iContextService == null) {
            throw new NullPointerException("The context authority needs an evaluation context");
        }
        this.contextManager = contextManager;
        this.contextService = iContextService;
    }

    final void activateContext(IContextActivation iContextActivation) {
        ArrayList<IContextActivation> arrayList;
        String string = iContextActivation.getContextId();
        Object v = this.contextActivationsByContextId.get(string);
        if (v instanceof Collection) {
            arrayList = (ArrayList<IContextActivation>)v;
            if (!arrayList.contains(iContextActivation)) {
                arrayList.add(iContextActivation);
                this.updateContext(string, this.containsActive(arrayList));
            }
        } else if (v instanceof IContextActivation) {
            if (v != iContextActivation) {
                arrayList = new ArrayList<IContextActivation>(2);
                arrayList.add((IContextActivation)v);
                arrayList.add(iContextActivation);
                this.contextActivationsByContextId.put(string, arrayList);
                this.updateContext(string, this.containsActive(arrayList));
            }
        } else {
            this.contextActivationsByContextId.put(string, iContextActivation);
            this.updateContext(string, this.evaluate(iContextActivation));
        }
        int n = iContextActivation.getSourcePriority();
        int n2 = 1;
        while (n2 <= 32) {
            if ((n & 1 << n2) != 0) {
                HashSet<IContextActivation> hashSet = this.activationsBySourcePriority[n2];
                if (hashSet == null) {
                    this.activationsBySourcePriority[n2] = hashSet = new HashSet<IContextActivation>(1);
                }
                hashSet.add(iContextActivation);
            }
            ++n2;
        }
    }

    private final void checkWindowType(final Shell shell, Shell shell2) {
        Collection collection = (Collection)this.registeredWindows.get(shell2);
        if (collection == null && (collection = (Collection)this.registeredWindows.get(null)) != null) {
            for (Object object2 : collection) {
                this.deactivateContext((IContextActivation)object2);
            }
        }
        if (shell != null && !shell.isDisposed()) {
            Object object;
            if (shell.getParent() != null && this.registeredWindows.get(shell) == null) {
                Object object2;
                object = new ArrayList();
                object2 = new ActiveShellExpression(shell);
                ContextActivation contextActivation = new ContextActivation("org.eclipse.ui.contexts.dialogAndWindow", (Expression)object2, this.contextService);
                this.activateContext(contextActivation);
                object.add(contextActivation);
                ContextActivation contextActivation2 = new ContextActivation("org.eclipse.ui.contexts.dialog", (Expression)object2, this.contextService);
                this.activateContext(contextActivation2);
                object.add(contextActivation2);
                this.registeredWindows.put(null, object);
                shell.addDisposeListener(new DisposeListener((Collection)object){
                    private final /* synthetic */ Collection val$newActivations;
                    {
                        this.val$newActivations = collection;
                    }

                    public void widgetDisposed(DisposeEvent disposeEvent) {
                        ContextAuthority.this.registeredWindows.remove(null);
                        if (!shell.isDisposed()) {
                            shell.removeDisposeListener((DisposeListener)this);
                        }
                        Iterator iterator = this.val$newActivations.iterator();
                        while (iterator.hasNext()) {
                            ContextAuthority.this.deactivateContext((IContextActivation)iterator.next());
                        }
                    }
                });
            } else {
                object = null;
            }
        }
    }

    private final boolean containsActive(Collection collection) {
        for (IContextActivation iContextActivation : collection) {
            if (!this.evaluate(iContextActivation)) continue;
            return true;
        }
        return false;
    }

    final void deactivateContext(IContextActivation iContextActivation) {
        String string = iContextActivation.getContextId();
        Object v = this.contextActivationsByContextId.get(string);
        if (v instanceof Collection) {
            Collection collection = (Collection)v;
            if (collection.contains(iContextActivation)) {
                collection.remove(iContextActivation);
                if (collection.isEmpty()) {
                    this.contextActivationsByContextId.remove(string);
                    this.updateContext(string, false);
                } else if (collection.size() == 1) {
                    IContextActivation iContextActivation2 = (IContextActivation)collection.iterator().next();
                    this.contextActivationsByContextId.put(string, iContextActivation2);
                    this.updateContext(string, this.evaluate(iContextActivation2));
                } else {
                    this.updateContext(string, this.containsActive(collection));
                }
            }
        } else if (v instanceof IContextActivation && v == iContextActivation) {
            this.contextActivationsByContextId.remove(string);
            this.updateContext(string, false);
        }
        int n = iContextActivation.getSourcePriority();
        int n2 = 1;
        while (n2 <= 32) {
            Set set;
            if ((n & 1 << n2) != 0 && (set = this.activationsBySourcePriority[n2]) != null) {
                set.remove(iContextActivation);
                if (set.isEmpty()) {
                    this.activationsBySourcePriority[n2] = null;
                }
            }
            ++n2;
        }
    }

    final Shell getActiveShell() {
        return (Shell)this.getVariable("activeShell");
    }

    public final int getShellType(Shell shell) {
        if (shell == null) {
            return 1;
        }
        Collection collection = (Collection)this.registeredWindows.get(shell);
        if (collection != null) {
            if (collection.isEmpty()) {
                return 1;
            }
            for (IContextActivation iContextActivation : collection) {
                String string = iContextActivation.getContextId();
                if (string == "org.eclipse.ui.contexts.dialog") {
                    return 0;
                }
                if (string != "org.eclipse.ui.contexts.window") continue;
                return 2;
            }
            Assert.isTrue((boolean)false, (String)"A registered shell should have at least one submission matching TYPE_WINDOW or TYPE_DIALOG");
            return 1;
        }
        if (shell.getParent() != null) {
            return 0;
        }
        return 1;
    }

    public final boolean registerShell(final Shell shell, int n) {
        Object object;
        Object object2;
        Serializable serializable;
        if (shell == null) {
            throw new NullPointerException("The shell was null");
        }
        if (DEBUG) {
            serializable = new StringBuffer("register shell '");
            ((StringBuffer)serializable).append(shell);
            ((StringBuffer)serializable).append("' as ");
            switch (n) {
                case 0: {
                    ((StringBuffer)serializable).append("dialog");
                    break;
                }
                case 2: {
                    ((StringBuffer)serializable).append("window");
                    break;
                }
                case 1: {
                    ((StringBuffer)serializable).append("none");
                    break;
                }
                default: {
                    ((StringBuffer)serializable).append("unknown");
                }
            }
            Tracing.printTrace((String)TRACING_COMPONENT, (String)((StringBuffer)serializable).toString());
        }
        serializable = new ArrayList();
        switch (n) {
            case 0: {
                ActiveShellExpression activeShellExpression = new ActiveShellExpression(shell);
                ContextActivation contextActivation = new ContextActivation("org.eclipse.ui.contexts.dialogAndWindow", activeShellExpression, this.contextService);
                this.activateContext(contextActivation);
                serializable.add(contextActivation);
                ContextActivation contextActivation2 = new ContextActivation("org.eclipse.ui.contexts.dialog", activeShellExpression, this.contextService);
                this.activateContext(contextActivation2);
                serializable.add(contextActivation2);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                ActiveShellExpression activeShellExpression = new ActiveShellExpression(shell);
                ContextActivation contextActivation = new ContextActivation("org.eclipse.ui.contexts.dialogAndWindow", activeShellExpression, this.contextService);
                this.activateContext(contextActivation);
                serializable.add(contextActivation);
                object2 = new ContextActivation("org.eclipse.ui.contexts.window", activeShellExpression, this.contextService);
                this.activateContext((IContextActivation)object2);
                serializable.add(object2);
                break;
            }
            default: {
                throw new IllegalArgumentException("The type is not recognized: " + n);
            }
        }
        boolean bl = false;
        object2 = (Collection)this.registeredWindows.get(shell);
        if (object2 != null) {
            bl = true;
            object = object2.iterator();
            while (object.hasNext()) {
                IContextActivation iContextActivation = (IContextActivation)object.next();
                this.deactivateContext(iContextActivation);
            }
        }
        this.registeredWindows.put(shell, serializable);
        object = new DisposeListener((List)((Object)serializable)){
            private final /* synthetic */ List val$activations;
            {
                this.val$activations = list;
            }

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ContextAuthority.this.registeredWindows.remove(shell);
                if (!shell.isDisposed()) {
                    shell.removeDisposeListener((DisposeListener)this);
                }
                Iterator iterator = this.val$activations.iterator();
                while (iterator.hasNext()) {
                    ContextAuthority.this.deactivateContext((IContextActivation)iterator.next());
                }
            }
        };
        shell.addDisposeListener((DisposeListener)object);
        shell.setData(DISPOSE_LISTENER, object);
        return bl;
    }

    @Override
    protected final void sourceChanged(int n) {
        long l = 0L;
        if (DEBUG_PERFORMANCE) {
            l = System.currentTimeMillis();
        }
        HashSet hashSet = new HashSet(4);
        int n2 = 1;
        while (n2 <= 32) {
            Object object;
            if ((n & 1 << n2) != 0 && (object = this.activationsBySourcePriority[n2]) != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    hashSet.add(iterator.next());
                }
            }
            ++n2;
        }
        ArrayList<String> arrayList = new ArrayList<String>(hashSet.size());
        for (Iterator iterator : hashSet) {
            boolean bl = this.evaluate((IEvaluationResultCache)((Object)iterator));
            iterator.clearResult();
            boolean bl2 = this.evaluate((IEvaluationResultCache)((Object)iterator));
            if (bl2 == bl) continue;
            arrayList.add(iterator.getContextId());
        }
        try {
            this.contextManager.deferUpdates(true);
            for (String string : arrayList) {
                Object v = this.contextActivationsByContextId.get(string);
                if (v instanceof IContextActivation) {
                    IContextActivation iContextActivation = (IContextActivation)v;
                    this.updateContext(string, this.evaluate(iContextActivation));
                    continue;
                }
                if (v instanceof Collection) {
                    this.updateContext(string, this.containsActive((Collection)v));
                    continue;
                }
                this.updateContext(string, false);
            }
        }
        finally {
            this.contextManager.deferUpdates(false);
        }
        if (DEBUG_PERFORMANCE) {
            long l2 = System.currentTimeMillis() - l;
            int n3 = hashSet.size();
            if (n3 > 0) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)(String.valueOf(n3) + " activations recomputed in " + l2 + "ms"));
            }
        }
    }

    public final boolean unregisterShell(Shell shell) {
        Object object;
        if (shell == null) {
            return false;
        }
        if (!shell.isDisposed() && (object = (DisposeListener)shell.getData(DISPOSE_LISTENER)) != null) {
            shell.removeDisposeListener((DisposeListener)object);
        }
        if ((object = (Collection)this.registeredWindows.get(shell)) != null) {
            this.registeredWindows.remove(shell);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                IContextActivation iContextActivation = (IContextActivation)iterator.next();
                this.deactivateContext(iContextActivation);
            }
            return true;
        }
        return false;
    }

    private final void updateContext(String string, boolean bl) {
        if (bl) {
            this.contextManager.addActiveContext(string);
        } else {
            this.contextManager.removeActiveContext(string);
        }
    }

    @Override
    protected final void updateEvaluationContext(String string, Object object) {
        if (string != null && !"activeWorkbenchWindowShell".equals(string)) {
            if ("activeShell".equals(string)) {
                this.checkWindowType((Shell)object, (Shell)this.getVariable("activeShell"));
            }
            this.changeVariable(string, object);
        }
    }

    final void updateShellKludge() {
        this.updateCurrentState();
        this.sourceChanged(1024);
    }
}

