/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.services.EvaluationResultCache;

final class ContextActivation
extends EvaluationResultCache
implements IContextActivation {
    private final String contextId;
    private final IContextService contextService;

    public ContextActivation(String string, Expression expression, IContextService iContextService) {
        super(expression);
        if (string == null) {
            throw new NullPointerException("The context identifier for a context activation cannot be null");
        }
        if (iContextService == null) {
            throw new NullPointerException("The context service for an activation cannot be null");
        }
        this.contextId = string;
        this.contextService = iContextService;
    }

    @Override
    public final void clearActive() {
        this.clearResult();
    }

    @Override
    public final String getContextId() {
        return this.contextId;
    }

    @Override
    public final IContextService getContextService() {
        return this.contextService;
    }

    @Override
    public final boolean isActive(IEvaluationContext iEvaluationContext) {
        return this.evaluate(iEvaluationContext);
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContextActivation(contextId=");
        stringBuffer.append(this.contextId);
        stringBuffer.append(",sourcePriority=");
        stringBuffer.append(this.getSourcePriority());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

