/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.services.IServiceLocator;

public final class ActiveContextSourceProvider
extends AbstractSourceProvider
implements IContextManagerListener {
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"activeContexts"};
    private IContextService contextService;

    public final void contextManagerChanged(ContextManagerEvent contextManagerEvent) {
        if (contextManagerEvent.isActiveContextsChanged()) {
            Map map = this.getCurrentState();
            if (DEBUG) {
                this.logDebuggingInfo("Contexts changed to " + map.get("activeContexts"));
            }
            this.fireSourceChanged(64, map);
        }
    }

    @Override
    public final void dispose() {
        this.contextService.removeContextManagerListener(this);
    }

    @Override
    public final Map getCurrentState() {
        TreeMap<String, Collection> treeMap = new TreeMap<String, Collection>();
        Collection collection = this.contextService.getActiveContextIds();
        treeMap.put("activeContexts", collection);
        return treeMap;
    }

    @Override
    public final String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    @Override
    public void initialize(IServiceLocator iServiceLocator) {
        this.contextService = (IContextService)iServiceLocator.getService(IContextService.class);
        this.contextService.addContextManagerListener(this);
    }
}

