/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.ui.LegacyHandlerSubmissionExpression;
import org.eclipse.ui.commands.HandlerSubmission;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IWorkbenchCommandSupport;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.commands.CommandManagerFactory;
import org.eclipse.ui.internal.commands.CommandManagerLegacyWrapper;
import org.eclipse.ui.internal.handlers.LegacyHandlerWrapper;
import org.eclipse.ui.keys.KeyFormatterFactory;
import org.eclipse.ui.keys.SWTKeySupport;

public class WorkbenchCommandSupport
implements IWorkbenchCommandSupport {
    private Map activationsBySubmission = null;
    private final CommandManagerLegacyWrapper commandManagerWrapper;
    private final IHandlerService handlerService;

    public WorkbenchCommandSupport(BindingManager bindingManager, CommandManager commandManager, ContextManager contextManager, IHandlerService iHandlerService) {
        if (iHandlerService == null) {
            throw new NullPointerException("The handler service cannot be null");
        }
        this.handlerService = iHandlerService;
        this.commandManagerWrapper = CommandManagerFactory.getCommandManagerWrapper(bindingManager, commandManager, contextManager);
        KeyFormatterFactory.setDefault(SWTKeySupport.getKeyFormatterForPlatform());
    }

    @Override
    public final void addHandlerSubmission(HandlerSubmission handlerSubmission) {
        IHandlerActivation iHandlerActivation = this.handlerService.activateHandler(handlerSubmission.getCommandId(), new LegacyHandlerWrapper(handlerSubmission.getHandler()), new LegacyHandlerSubmissionExpression(handlerSubmission.getActivePartId(), handlerSubmission.getActiveShell(), handlerSubmission.getActiveWorkbenchPartSite()));
        if (this.activationsBySubmission == null) {
            this.activationsBySubmission = new HashMap();
        }
        this.activationsBySubmission.put(handlerSubmission, iHandlerActivation);
    }

    @Override
    public final void addHandlerSubmissions(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addHandlerSubmission((HandlerSubmission)iterator.next());
        }
    }

    @Override
    public ICommandManager getCommandManager() {
        return this.commandManagerWrapper;
    }

    @Override
    public final void removeHandlerSubmission(HandlerSubmission handlerSubmission) {
        if (this.activationsBySubmission == null) {
            return;
        }
        Object v = this.activationsBySubmission.remove(handlerSubmission);
        if (v instanceof IHandlerActivation) {
            IHandlerActivation iHandlerActivation = (IHandlerActivation)v;
            this.handlerService.deactivateHandler(iHandlerActivation);
        }
    }

    @Override
    public final void removeHandlerSubmissions(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeHandlerSubmission((HandlerSubmission)iterator.next());
        }
    }
}

