/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.SerializationException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementReference;
import org.eclipse.ui.internal.commands.ElementReference;
import org.eclipse.ui.menus.UIElement;

public class SlaveCommandService
implements ICommandService {
    private Collection fExecutionListeners = new ArrayList();
    private Set fCallbackCache = new HashSet();
    private ICommandService fParentService;
    private String fScopingName;
    private Object fScopingValue;

    public SlaveCommandService(ICommandService iCommandService, String string, Object object) {
        if (iCommandService == null) {
            throw new NullPointerException("The parent command service must not be null");
        }
        this.fParentService = iCommandService;
        this.fScopingName = string;
        this.fScopingValue = object;
    }

    @Override
    public void addExecutionListener(IExecutionListener iExecutionListener) {
        if (!this.fExecutionListeners.contains(iExecutionListener)) {
            this.fExecutionListeners.add(iExecutionListener);
        }
        this.fParentService.addExecutionListener(iExecutionListener);
    }

    @Override
    public void defineUncategorizedCategory(String string, String string2) {
        this.fParentService.defineUncategorizedCategory(string, string2);
    }

    @Override
    public ParameterizedCommand deserialize(String string) throws NotDefinedException, SerializationException {
        return this.fParentService.deserialize(string);
    }

    @Override
    public void dispose() {
        int n;
        Object[] objectArray;
        if (!this.fExecutionListeners.isEmpty()) {
            objectArray = this.fExecutionListeners.toArray();
            n = 0;
            while (n < objectArray.length) {
                this.removeExecutionListener((IExecutionListener)objectArray[n]);
                ++n;
            }
            this.fExecutionListeners.clear();
        }
        if (!this.fCallbackCache.isEmpty()) {
            objectArray = this.fCallbackCache.toArray();
            n = 0;
            while (n < objectArray.length) {
                this.unregisterElement((IElementReference)objectArray[n]);
                ++n;
            }
        }
    }

    @Override
    public Category getCategory(String string) {
        return this.fParentService.getCategory(string);
    }

    @Override
    public Command getCommand(String string) {
        return this.fParentService.getCommand(string);
    }

    @Override
    public Category[] getDefinedCategories() {
        return this.fParentService.getDefinedCategories();
    }

    @Override
    public Collection getDefinedCategoryIds() {
        return this.fParentService.getDefinedCategoryIds();
    }

    @Override
    public Collection getDefinedCommandIds() {
        return this.fParentService.getDefinedCommandIds();
    }

    @Override
    public Command[] getDefinedCommands() {
        return this.fParentService.getDefinedCommands();
    }

    @Override
    public Collection getDefinedParameterTypeIds() {
        return this.fParentService.getDefinedParameterTypeIds();
    }

    @Override
    public ParameterType[] getDefinedParameterTypes() {
        return this.fParentService.getDefinedParameterTypes();
    }

    @Override
    public final String getHelpContextId(Command command) throws NotDefinedException {
        return this.fParentService.getHelpContextId(command);
    }

    @Override
    public final String getHelpContextId(String string) throws NotDefinedException {
        return this.fParentService.getHelpContextId(string);
    }

    @Override
    public ParameterType getParameterType(String string) {
        return this.fParentService.getParameterType(string);
    }

    @Override
    public void readRegistry() {
        this.fParentService.readRegistry();
    }

    @Override
    public void removeExecutionListener(IExecutionListener iExecutionListener) {
        this.fExecutionListeners.remove(iExecutionListener);
        this.fParentService.removeExecutionListener(iExecutionListener);
    }

    @Override
    public final void setHelpContextId(IHandler iHandler, String string) {
        this.fParentService.setHelpContextId(iHandler, string);
    }

    @Override
    public void refreshElements(String string, Map map) {
        this.fParentService.refreshElements(string, map);
    }

    @Override
    public IElementReference registerElementForCommand(ParameterizedCommand parameterizedCommand, UIElement uIElement) throws NotDefinedException {
        if (!parameterizedCommand.getCommand().isDefined()) {
            throw new NotDefinedException("Cannot define a callback for undefined command " + parameterizedCommand.getCommand().getId());
        }
        if (uIElement == null) {
            throw new NotDefinedException("No callback defined for command " + parameterizedCommand.getCommand().getId());
        }
        ElementReference elementReference = new ElementReference(parameterizedCommand.getId(), uIElement, parameterizedCommand.getParameterMap());
        this.registerElement(elementReference);
        return elementReference;
    }

    @Override
    public void registerElement(IElementReference iElementReference) {
        this.fCallbackCache.add(iElementReference);
        iElementReference.getParameters().put(this.fScopingName, this.fScopingValue);
        this.fParentService.registerElement(iElementReference);
    }

    @Override
    public void unregisterElement(IElementReference iElementReference) {
        this.fCallbackCache.remove(iElementReference);
        this.fParentService.unregisterElement(iElementReference);
    }
}

