/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.commands.PersistentState;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.internal.WorkbenchPlugin;

public final class CommandStateProxy
extends PersistentState {
    private IConfigurationElement configurationElement;
    private String preferenceKey;
    private IPreferenceStore preferenceStore;
    private State state = null;
    private final String stateAttributeName;

    public CommandStateProxy(IConfigurationElement iConfigurationElement, String string, IPreferenceStore iPreferenceStore, String string2) {
        if (iConfigurationElement == null) {
            throw new NullPointerException("The configuration element backing a state proxy cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("The attribute containing the state class must be known");
        }
        this.configurationElement = iConfigurationElement;
        this.stateAttributeName = string;
        this.preferenceKey = string2;
        this.preferenceStore = iPreferenceStore;
    }

    public final void addListener(IStateListener iStateListener) {
        if (this.state == null) {
            this.addListenerObject(iStateListener);
        } else {
            this.state.addListener(iStateListener);
        }
    }

    public final void dispose() {
        if (this.state != null) {
            PersistentState persistentState;
            this.state.dispose();
            if (this.state instanceof PersistentState && (persistentState = (PersistentState)this.state).shouldPersist() && this.preferenceStore != null && this.preferenceKey != null) {
                persistentState.save(this.preferenceStore, this.preferenceKey);
            }
        }
    }

    public final Object getValue() {
        if (this.loadState()) {
            return this.state.getValue();
        }
        return null;
    }

    public final void load(IPreferenceStore iPreferenceStore, String string) {
        PersistentState persistentState;
        if (this.loadState() && this.state instanceof PersistentState && (persistentState = (PersistentState)this.state).shouldPersist() && this.preferenceStore != null && string != null) {
            persistentState.load(this.preferenceStore, string);
        }
    }

    private final boolean loadState() {
        return this.loadState(false);
    }

    private final boolean loadState(boolean bl) {
        if (this.state == null) {
            try {
                Object[] objectArray;
                this.state = (State)this.configurationElement.createExecutableExtension(this.stateAttributeName);
                this.state.setId(this.getId());
                this.configurationElement = null;
                if (bl && this.state instanceof PersistentState) {
                    objectArray = (Object[])this.state;
                    objectArray.setShouldPersist(true);
                }
                this.load(this.preferenceStore, this.preferenceKey);
                objectArray = this.getListeners();
                int n = 0;
                while (n < objectArray.length) {
                    this.state.addListener((IStateListener)objectArray[n]);
                    ++n;
                }
                this.clearListeners();
                return true;
            }
            catch (ClassCastException classCastException) {
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "The proxied state was the wrong class", (Throwable)classCastException);
                WorkbenchPlugin.log("The proxied state was the wrong class", (IStatus)status);
                return false;
            }
            catch (CoreException coreException) {
                String string = "The proxied state for '" + this.configurationElement.getAttribute(this.stateAttributeName) + "' could not be loaded";
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, string, (Throwable)coreException);
                WorkbenchPlugin.log(string, (IStatus)status);
                return false;
            }
        }
        return true;
    }

    public final void removeListener(IStateListener iStateListener) {
        if (this.state == null) {
            this.removeListenerObject(iStateListener);
        } else {
            this.state.removeListener(iStateListener);
        }
    }

    public final void save(IPreferenceStore iPreferenceStore, String string) {
        if (this.loadState() && this.state instanceof PersistentState) {
            ((PersistentState)this.state).save(iPreferenceStore, string);
        }
    }

    public final void setId(String string) {
        super.setId(string);
        if (this.state != null) {
            this.state.setId(string);
        }
    }

    public final void setShouldPersist(boolean bl) {
        if (this.loadState(bl) && this.state instanceof PersistentState) {
            ((PersistentState)this.state).setShouldPersist(bl);
        }
    }

    public final void setValue(Object object) {
        if (this.loadState()) {
            this.state.setValue(object);
        }
    }

    public final boolean shouldPersist() {
        if (this.loadState() && this.state instanceof PersistentState) {
            return ((PersistentState)this.state).shouldPersist();
        }
        return false;
    }

    public final String toString() {
        if (this.state == null) {
            return this.configurationElement.getAttribute(this.stateAttributeName);
        }
        return this.state.toString();
    }
}

