/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.SerializationException;
import org.eclipse.core.commands.State;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.commands.PersistentState;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementReference;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.CommandPersistence;
import org.eclipse.ui.internal.commands.ElementReference;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.menus.UIElement;

public final class CommandService
implements ICommandService {
    private static final String PREFERENCE_KEY_PREFIX = "org.eclipse.ui.commands/state";
    private final CommandManager commandManager;
    private final CommandPersistence commandPersistence;
    private Map commandCallbacks = new HashMap();

    static final String createPreferenceKey(Command command, String string) {
        return "org.eclipse.ui.commands/state/" + command.getId() + '/' + string;
    }

    public CommandService(CommandManager commandManager) {
        if (commandManager == null) {
            throw new NullPointerException("Cannot create a command service with a null manager");
        }
        this.commandManager = commandManager;
        this.commandPersistence = new CommandPersistence(this);
    }

    @Override
    public final void addExecutionListener(IExecutionListener iExecutionListener) {
        this.commandManager.addExecutionListener(iExecutionListener);
    }

    @Override
    public final void defineUncategorizedCategory(String string, String string2) {
        this.commandManager.defineUncategorizedCategory(string, string2);
    }

    @Override
    public final ParameterizedCommand deserialize(String string) throws NotDefinedException, SerializationException {
        return this.commandManager.deserialize(string);
    }

    @Override
    public final void dispose() {
        this.commandPersistence.dispose();
        Command[] commandArray = this.commandManager.getAllCommands();
        int n = 0;
        while (n < commandArray.length) {
            Command command = commandArray[n];
            String[] stringArray = command.getStateIds();
            int n2 = 0;
            while (n2 < stringArray.length) {
                PersistentState persistentState;
                String string = stringArray[n2];
                State state = command.getState(string);
                if (state instanceof PersistentState && (persistentState = (PersistentState)state).shouldPersist()) {
                    persistentState.save(PrefUtil.getInternalPreferenceStore(), CommandService.createPreferenceKey(command, string));
                }
                ++n2;
            }
            ++n;
        }
        this.commandCallbacks = null;
    }

    @Override
    public final Category getCategory(String string) {
        return this.commandManager.getCategory(string);
    }

    @Override
    public final Command getCommand(String string) {
        return this.commandManager.getCommand(string);
    }

    @Override
    public final Category[] getDefinedCategories() {
        return this.commandManager.getDefinedCategories();
    }

    @Override
    public final Collection getDefinedCategoryIds() {
        return this.commandManager.getDefinedCategoryIds();
    }

    @Override
    public final Collection getDefinedCommandIds() {
        return this.commandManager.getDefinedCommandIds();
    }

    @Override
    public final Command[] getDefinedCommands() {
        return this.commandManager.getDefinedCommands();
    }

    @Override
    public Collection getDefinedParameterTypeIds() {
        return this.commandManager.getDefinedParameterTypeIds();
    }

    @Override
    public ParameterType[] getDefinedParameterTypes() {
        return this.commandManager.getDefinedParameterTypes();
    }

    @Override
    public final String getHelpContextId(Command command) throws NotDefinedException {
        return this.commandManager.getHelpContextId(command);
    }

    @Override
    public final String getHelpContextId(String string) throws NotDefinedException {
        Command command = this.getCommand(string);
        return this.commandManager.getHelpContextId(command);
    }

    @Override
    public ParameterType getParameterType(String string) {
        return this.commandManager.getParameterType(string);
    }

    @Override
    public final void readRegistry() {
        this.commandPersistence.read();
    }

    @Override
    public final void removeExecutionListener(IExecutionListener iExecutionListener) {
        this.commandManager.removeExecutionListener(iExecutionListener);
    }

    @Override
    public final void setHelpContextId(IHandler iHandler, String string) {
        this.commandManager.setHelpContextId(iHandler, string);
    }

    @Override
    public final void refreshElements(String string, Map map) {
        Command command = this.getCommand(string);
        if (!command.isDefined() || !(command.getHandler() instanceof IElementUpdater)) {
            return;
        }
        final IElementUpdater iElementUpdater = (IElementUpdater)command.getHandler();
        if (this.commandCallbacks == null) {
            return;
        }
        List list = (List)this.commandCallbacks.get(string);
        if (list == null) {
            return;
        }
        for (final IElementReference iElementReference : list) {
            final Map map2 = Collections.unmodifiableMap(iElementReference.getParameters());
            ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    WorkbenchPlugin.log("Failed to update callback: " + iElementReference.getCommandId(), throwable);
                }

                public void run() throws Exception {
                    iElementUpdater.updateElement(iElementReference.getElement(), map2);
                }
            };
            if (map == null) {
                SafeRunner.run((ISafeRunnable)iSafeRunnable);
                continue;
            }
            boolean bl = true;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext() && bl) {
                Map.Entry entry = iterator.next();
                Object v = map2.get(entry.getKey());
                if (entry.getValue().equals(v)) continue;
                bl = false;
            }
            if (!bl) continue;
            SafeRunner.run((ISafeRunnable)iSafeRunnable);
        }
    }

    @Override
    public final IElementReference registerElementForCommand(ParameterizedCommand parameterizedCommand, UIElement uIElement) throws NotDefinedException {
        if (!parameterizedCommand.getCommand().isDefined()) {
            throw new NotDefinedException("Cannot define a callback for undefined command " + parameterizedCommand.getCommand().getId());
        }
        if (uIElement == null) {
            throw new NotDefinedException("No callback defined for command " + parameterizedCommand.getCommand().getId());
        }
        ElementReference elementReference = new ElementReference(parameterizedCommand.getId(), uIElement, parameterizedCommand.getParameterMap());
        this.registerElement(elementReference);
        return elementReference;
    }

    @Override
    public void registerElement(IElementReference iElementReference) {
        ArrayList<IElementReference> arrayList = (ArrayList<IElementReference>)this.commandCallbacks.get(iElementReference.getCommandId());
        if (arrayList == null) {
            arrayList = new ArrayList<IElementReference>();
            this.commandCallbacks.put(iElementReference.getCommandId(), arrayList);
        }
        arrayList.add(iElementReference);
        Command command = this.getCommand(iElementReference.getCommandId());
        if (command.isDefined() && command.getHandler() instanceof IElementUpdater) {
            ((IElementUpdater)command.getHandler()).updateElement(iElementReference.getElement(), iElementReference.getParameters());
        }
    }

    @Override
    public void unregisterElement(IElementReference iElementReference) {
        List list = (List)this.commandCallbacks.get(iElementReference.getCommandId());
        if (list != null) {
            list.remove(iElementReference);
            if (list.isEmpty()) {
                this.commandCallbacks.remove(iElementReference.getCommandId());
            }
        }
    }

    public CommandPersistence getCommandPersistence() {
        return this.commandPersistence;
    }
}

