/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.commands.CommandService;
import org.eclipse.ui.internal.commands.CommandStateProxy;
import org.eclipse.ui.internal.commands.Parameter;
import org.eclipse.ui.internal.commands.ParameterValueConverterProxy;
import org.eclipse.ui.internal.services.RegistryPersistence;
import org.eclipse.ui.internal.util.PrefUtil;

public final class CommandPersistence
extends RegistryPersistence {
    private static final int INDEX_CATEGORY_DEFINITIONS = 0;
    private static final int INDEX_COMMAND_DEFINITIONS = 1;
    private static final int INDEX_PARAMETER_TYPE_DEFINITIONS = 2;
    private final ICommandService commandService;

    private static final void readCategoriesFromRegistry(IConfigurationElement[] iConfigurationElementArray, int n, ICommandService iCommandService) {
        Category[] categoryArray = iCommandService.getDefinedCategories();
        if (categoryArray != null) {
            int n2 = 0;
            while (n2 < categoryArray.length) {
                categoryArray[n2].undefine();
                ++n2;
            }
        }
        iCommandService.defineUncategorizedCategory(WorkbenchMessages.CommandService_AutogeneratedCategoryName, WorkbenchMessages.CommandService_AutogeneratedCategoryDescription);
        ArrayList arrayList = new ArrayList(1);
        int n3 = 0;
        while (n3 < n) {
            String string;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n3];
            String string2 = CommandPersistence.readRequired(iConfigurationElement, "id", arrayList, "Categories need an id");
            if (string2 != null && (string = CommandPersistence.readRequired(iConfigurationElement, "name", arrayList, "Categories need a name", string2)) != null) {
                String string3 = CommandPersistence.readOptional(iConfigurationElement, "description");
                Category category = iCommandService.getCategory(string2);
                category.define(string, string3);
            }
            ++n3;
        }
        CommandPersistence.logWarnings(arrayList, "Warnings while parsing the commands from the 'org.eclipse.ui.commands' and 'org.eclipse.ui.actionDefinitions' extension points.");
    }

    private static final void readCommandsFromRegistry(IConfigurationElement[] iConfigurationElementArray, int n, ICommandService iCommandService) {
        Command[] commandArray = iCommandService.getDefinedCommands();
        if (commandArray != null) {
            int n2 = 0;
            while (n2 < commandArray.length) {
                commandArray[n2].undefine();
                ++n2;
            }
        }
        ArrayList arrayList = new ArrayList(1);
        int n3 = 0;
        while (n3 < n) {
            String string;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n3];
            String string2 = CommandPersistence.readRequired(iConfigurationElement, "id", arrayList, "Commands need an id");
            if (string2 != null && (string = CommandPersistence.readRequired(iConfigurationElement, "name", arrayList, "Commands need a name")) != null) {
                String string3 = CommandPersistence.readOptional(iConfigurationElement, "description");
                String string4 = iConfigurationElement.getAttribute("categoryId");
                if ((string4 == null || string4.length() == 0) && (string4 = iConfigurationElement.getAttribute("category")) != null && string4.length() == 0) {
                    string4 = null;
                }
                IParameter[] iParameterArray = CommandPersistence.readParameters(iConfigurationElement, arrayList, iCommandService);
                String string5 = CommandPersistence.readOptional(iConfigurationElement, "returnTypeId");
                String string6 = CommandPersistence.readOptional(iConfigurationElement, "helpContextId");
                Command command = iCommandService.getCommand(string2);
                Category category = iCommandService.getCategory(string4);
                if (!category.isDefined()) {
                    CommandPersistence.addWarning(arrayList, "Commands should really have a category", iConfigurationElement, string2, "categoryId", string4);
                }
                ParameterType parameterType = string5 == null ? null : iCommandService.getParameterType(string5);
                command.define(string, string3, category, iParameterArray, parameterType, string6);
                CommandPersistence.readState(iConfigurationElement, arrayList, command);
            }
            ++n3;
        }
        CommandPersistence.logWarnings(arrayList, "Warnings while parsing the commands from the 'org.eclipse.ui.commands' and 'org.eclipse.ui.actionDefinitions' extension points.");
    }

    private static final Parameter[] readParameters(IConfigurationElement iConfigurationElement, List list, ICommandService iCommandService) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("commandParameter");
        if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
            return null;
        }
        int n = 0;
        Parameter[] parameterArray = new Parameter[iConfigurationElementArray.length];
        int n2 = 0;
        while (n2 < iConfigurationElementArray.length) {
            String string;
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n2];
            String string2 = CommandPersistence.readRequired(iConfigurationElement2, "id", list, "Parameters need an id");
            if (string2 != null && (string = CommandPersistence.readRequired(iConfigurationElement2, "name", list, "Parameters need a name")) != null) {
                String string3 = CommandPersistence.readOptional(iConfigurationElement2, "typeId");
                boolean bl = CommandPersistence.readBoolean(iConfigurationElement2, "optional", true);
                ParameterType parameterType = string3 == null ? null : iCommandService.getParameterType(string3);
                Parameter parameter = new Parameter(string2, string, iConfigurationElement2, parameterType, bl);
                parameterArray[n++] = parameter;
            }
            ++n2;
        }
        if (n != parameterArray.length) {
            Parameter[] parameterArray2 = new Parameter[n];
            System.arraycopy(parameterArray, 0, parameterArray2, 0, n);
            parameterArray = parameterArray2;
        }
        return parameterArray;
    }

    private static final void readParameterTypesFromRegistry(IConfigurationElement[] iConfigurationElementArray, int n, ICommandService iCommandService) {
        ParameterType[] parameterTypeArray = iCommandService.getDefinedParameterTypes();
        if (parameterTypeArray != null) {
            int n2 = 0;
            while (n2 < parameterTypeArray.length) {
                parameterTypeArray[n2].undefine();
                ++n2;
            }
        }
        ArrayList arrayList = new ArrayList(1);
        int n3 = 0;
        while (n3 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n3];
            String string = CommandPersistence.readRequired(iConfigurationElement, "id", arrayList, "Command parameter types need an id");
            if (string != null) {
                String string2 = CommandPersistence.readOptional(iConfigurationElement, "type");
                String string3 = CommandPersistence.readOptional(iConfigurationElement, "converter");
                ParameterValueConverterProxy parameterValueConverterProxy = string3 == null ? null : new ParameterValueConverterProxy(iConfigurationElement);
                ParameterType parameterType = iCommandService.getParameterType(string);
                parameterType.define(string2, (AbstractParameterValueConverter)parameterValueConverterProxy);
            }
            ++n3;
        }
        CommandPersistence.logWarnings(arrayList, "Warnings while parsing the commandParameterTypes from the 'org.eclipse.ui.commands' extension point.");
    }

    private static final void readState(IConfigurationElement iConfigurationElement, List list, Command command) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("state");
        if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
            String string = CommandPersistence.readRequired(iConfigurationElement2, "id", list, "State needs an id");
            if (string != null && CommandPersistence.checkClass(iConfigurationElement2, list, "State must have an associated class", string)) {
                CommandStateProxy commandStateProxy = new CommandStateProxy(iConfigurationElement2, "class", PrefUtil.getInternalPreferenceStore(), CommandService.createPreferenceKey(command, string));
                command.addState(string, (State)commandStateProxy);
            }
            ++n;
        }
    }

    CommandPersistence(ICommandService iCommandService) {
        if (iCommandService == null) {
            throw new NullPointerException("The command service cannot be null");
        }
        this.commandService = iCommandService;
    }

    @Override
    protected final boolean isChangeImportant(IRegistryChangeEvent iRegistryChangeEvent) {
        return false;
    }

    public boolean commandsNeedUpdating(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray;
        IExtensionDelta[] iExtensionDeltaArray2 = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "commands");
        return iExtensionDeltaArray2.length != 0 || (iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "actionDefinitions")).length != 0;
    }

    @Override
    protected final void read() {
        super.read();
        this.reRead();
    }

    public void reRead() {
        String string;
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        IConfigurationElement[][] iConfigurationElementArrayArray = new IConfigurationElement[3][];
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.commands");
        int n4 = 0;
        while (n4 < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n4];
            string = iConfigurationElement.getName();
            if ("command".equals(string)) {
                CommandPersistence.addElementToIndexedArray(iConfigurationElement, iConfigurationElementArrayArray, 1, n++);
            } else if ("category".equals(string)) {
                CommandPersistence.addElementToIndexedArray(iConfigurationElement, iConfigurationElementArrayArray, 0, n2++);
            } else if ("commandParameterType".equals(string)) {
                CommandPersistence.addElementToIndexedArray(iConfigurationElement, iConfigurationElementArrayArray, 2, n3++);
            }
            ++n4;
        }
        IConfigurationElement[] iConfigurationElementArray2 = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.actionDefinitions");
        int n5 = 0;
        while (n5 < iConfigurationElementArray2.length) {
            string = iConfigurationElementArray2[n5];
            String string2 = string.getName();
            if ("actionDefinition".equals(string2)) {
                CommandPersistence.addElementToIndexedArray((IConfigurationElement)string, iConfigurationElementArrayArray, 1, n++);
            }
            ++n5;
        }
        CommandPersistence.readCategoriesFromRegistry(iConfigurationElementArrayArray[0], n2, this.commandService);
        CommandPersistence.readCommandsFromRegistry(iConfigurationElementArrayArray[1], n, this.commandService);
        CommandPersistence.readParameterTypesFromRegistry(iConfigurationElementArrayArray[2], n3, this.commandService);
    }
}

