/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.CommandManagerEvent;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.ui.commands.ICategory;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.ICommandManagerListener;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.commands.IKeyConfiguration;
import org.eclipse.ui.internal.commands.CommandLegacyWrapper;
import org.eclipse.ui.internal.handlers.LegacyHandlerWrapper;
import org.eclipse.ui.internal.keys.SchemeLegacyWrapper;

public final class CommandManagerLegacyWrapper
implements ICommandManager,
org.eclipse.core.commands.ICommandManagerListener,
IBindingManagerListener,
IContextManagerListener {
    public static boolean DEBUG_COMMAND_EXECUTION = false;
    public static boolean DEBUG_HANDLERS = false;
    public static String DEBUG_HANDLERS_COMMAND_ID = null;
    private final BindingManager bindingManager;
    private final CommandManager commandManager;
    private List commandManagerListeners;
    private final ContextManager contextManager;

    static boolean validateKeySequence(org.eclipse.ui.keys.KeySequence keySequence) {
        if (keySequence == null) {
            return false;
        }
        List list = keySequence.getKeyStrokes();
        int n = list.size();
        return n != 0 && n <= 4 && keySequence.isComplete();
    }

    public CommandManagerLegacyWrapper(BindingManager bindingManager, CommandManager commandManager, ContextManager contextManager) {
        if (contextManager == null) {
            throw new NullPointerException("The context manager cannot be null.");
        }
        this.bindingManager = bindingManager;
        this.commandManager = commandManager;
        this.contextManager = contextManager;
    }

    @Override
    public final void addCommandManagerListener(ICommandManagerListener iCommandManagerListener) {
        if (iCommandManagerListener == null) {
            throw new NullPointerException("Cannot add a null listener.");
        }
        if (this.commandManagerListeners == null) {
            this.commandManagerListeners = new ArrayList();
            this.commandManager.addCommandManagerListener((org.eclipse.core.commands.ICommandManagerListener)this);
            this.bindingManager.addBindingManagerListener((IBindingManagerListener)this);
            this.contextManager.addContextManagerListener((IContextManagerListener)this);
        }
        if (!this.commandManagerListeners.contains(iCommandManagerListener)) {
            this.commandManagerListeners.add(iCommandManagerListener);
        }
    }

    public final void bindingManagerChanged(BindingManagerEvent bindingManagerEvent) {
        HashSet<String> hashSet;
        boolean bl;
        boolean bl2 = bl = bindingManagerEvent.getScheme() != null;
        if (bl) {
            hashSet = new HashSet<String>();
            Scheme scheme = bindingManagerEvent.getScheme();
            Scheme[] schemeArray = bindingManagerEvent.getManager().getDefinedSchemes();
            int n = schemeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Scheme scheme2 = schemeArray[0];
                if (scheme2 != scheme || !bindingManagerEvent.isSchemeDefined()) {
                    hashSet.add(schemeArray[0].getId());
                }
                ++n2;
            }
            if (!bindingManagerEvent.isSchemeDefined()) {
                hashSet.add(scheme.getId());
            }
        } else {
            hashSet = null;
        }
        this.fireCommandManagerChanged(new org.eclipse.ui.commands.CommandManagerEvent(this, false, bindingManagerEvent.isActiveSchemeChanged(), bindingManagerEvent.isLocaleChanged(), bindingManagerEvent.isPlatformChanged(), false, false, bl, null, null, hashSet));
    }

    public final void commandManagerChanged(CommandManagerEvent commandManagerEvent) {
        HashSet<String> hashSet;
        HashSet<String> hashSet2;
        boolean bl = commandManagerEvent.isCategoryChanged();
        if (bl) {
            hashSet2 = new HashSet<String>(this.commandManager.getDefinedCategoryIds());
            String string = commandManagerEvent.getCategoryId();
            if (commandManagerEvent.isCategoryDefined()) {
                hashSet2.remove(string);
            } else {
                hashSet2.add(string);
            }
        } else {
            hashSet2 = null;
        }
        boolean bl2 = commandManagerEvent.isCommandChanged();
        if (bl2) {
            hashSet = new HashSet<String>(this.commandManager.getDefinedCommandIds());
            String string = commandManagerEvent.getCommandId();
            if (commandManagerEvent.isCommandDefined()) {
                hashSet.remove(string);
            } else {
                hashSet.add(string);
            }
        } else {
            hashSet = null;
        }
        this.fireCommandManagerChanged(new org.eclipse.ui.commands.CommandManagerEvent(this, false, false, false, false, bl, bl2, false, hashSet2, hashSet, null));
    }

    public final void contextManagerChanged(ContextManagerEvent contextManagerEvent) {
        this.fireCommandManagerChanged(new org.eclipse.ui.commands.CommandManagerEvent(this, contextManagerEvent.isActiveContextsChanged(), false, false, false, false, false, false, null, null, null));
    }

    private void fireCommandManagerChanged(org.eclipse.ui.commands.CommandManagerEvent commandManagerEvent) {
        if (commandManagerEvent == null) {
            throw new NullPointerException();
        }
        if (this.commandManagerListeners != null) {
            int n = 0;
            while (n < this.commandManagerListeners.size()) {
                ((ICommandManagerListener)this.commandManagerListeners.get(n)).commandManagerChanged(commandManagerEvent);
                ++n;
            }
        }
    }

    @Override
    public Set getActiveContextIds() {
        return this.contextManager.getActiveContextIds();
    }

    @Override
    public String getActiveKeyConfigurationId() {
        Scheme scheme = this.bindingManager.getActiveScheme();
        if (scheme != null) {
            return scheme.getId();
        }
        return "";
    }

    @Override
    public String getActiveLocale() {
        return this.bindingManager.getLocale();
    }

    @Override
    public String getActivePlatform() {
        return this.bindingManager.getPlatform();
    }

    @Override
    public ICategory getCategory(String string) {
        return null;
    }

    @Override
    public ICommand getCommand(String string) {
        Command command = this.commandManager.getCommand(string);
        return new CommandLegacyWrapper(command, this.bindingManager);
    }

    @Override
    public Set getDefinedCategoryIds() {
        return this.commandManager.getDefinedCategoryIds();
    }

    @Override
    public Set getDefinedCommandIds() {
        return this.commandManager.getDefinedCommandIds();
    }

    @Override
    public Set getDefinedKeyConfigurationIds() {
        HashSet<String> hashSet = new HashSet<String>();
        Scheme[] schemeArray = this.bindingManager.getDefinedSchemes();
        int n = 0;
        while (n < schemeArray.length) {
            hashSet.add(schemeArray[n].getId());
            ++n;
        }
        return hashSet;
    }

    @Override
    public IKeyConfiguration getKeyConfiguration(String string) {
        Scheme scheme = this.bindingManager.getScheme(string);
        return new SchemeLegacyWrapper(scheme, this.bindingManager);
    }

    @Override
    public Map getPartialMatches(org.eclipse.ui.keys.KeySequence keySequence) {
        try {
            KeySequence keySequence2 = KeySequence.getInstance((String)keySequence.toString());
            Map map = this.bindingManager.getPartialMatches((TriggerSequence)keySequence2);
            HashMap hashMap = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                TriggerSequence triggerSequence = (TriggerSequence)entry.getKey();
                if (!(triggerSequence instanceof KeySequence)) continue;
                KeySequence keySequence3 = (KeySequence)triggerSequence;
                hashMap.put(org.eclipse.ui.keys.KeySequence.getInstance(keySequence3.toString()), entry.getValue());
            }
            return hashMap;
        }
        catch (ParseException parseException) {
            return new HashMap();
        }
        catch (org.eclipse.ui.keys.ParseException parseException) {
            return new HashMap();
        }
    }

    @Override
    public String getPerfectMatch(org.eclipse.ui.keys.KeySequence keySequence) {
        Binding binding;
        block3: {
            try {
                KeySequence keySequence2 = KeySequence.getInstance((String)keySequence.toString());
                binding = this.bindingManager.getPerfectMatch((TriggerSequence)keySequence2);
                if (binding != null) break block3;
                return null;
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return binding.getParameterizedCommand().getId();
    }

    @Override
    public boolean isPartialMatch(org.eclipse.ui.keys.KeySequence keySequence) {
        try {
            KeySequence keySequence2 = KeySequence.getInstance((String)keySequence.toString());
            return this.bindingManager.isPartialMatch((TriggerSequence)keySequence2);
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    @Override
    public boolean isPerfectMatch(org.eclipse.ui.keys.KeySequence keySequence) {
        try {
            KeySequence keySequence2 = KeySequence.getInstance((String)keySequence.toString());
            return this.bindingManager.isPerfectMatch((TriggerSequence)keySequence2);
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    @Override
    public void removeCommandManagerListener(ICommandManagerListener iCommandManagerListener) {
        if (iCommandManagerListener == null) {
            throw new NullPointerException("Cannot remove a null listener");
        }
        if (this.commandManagerListeners != null) {
            this.commandManagerListeners.remove(iCommandManagerListener);
            if (this.commandManagerListeners.isEmpty()) {
                this.commandManagerListeners = null;
                this.commandManager.removeCommandManagerListener((org.eclipse.core.commands.ICommandManagerListener)this);
                this.bindingManager.removeBindingManagerListener((IBindingManagerListener)this);
                this.contextManager.removeContextManagerListener((IContextManagerListener)this);
            }
        }
    }

    public final void setHandlersByCommandId(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            Object v = entry.getValue();
            if (!(v instanceof IHandler)) continue;
            String string = (String)entry.getKey();
            map.put(string, new LegacyHandlerWrapper((IHandler)v));
        }
        this.commandManager.setHandlersByCommandId(map);
    }
}

