/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.NotDefinedException;
import org.eclipse.ui.commands.NotHandledException;
import org.eclipse.ui.internal.commands.LegacyCommandListenerWrapper;
import org.eclipse.ui.internal.keys.KeySequenceBinding;

final class CommandLegacyWrapper
implements ICommand {
    private final BindingManager bindingManager;
    private final Command command;
    private ParameterizedCommand parameterizedCommand;

    CommandLegacyWrapper(Command command, BindingManager bindingManager) {
        if (command == null) {
            throw new NullPointerException("The wrapped command cannot be <code>null</code>.");
        }
        if (bindingManager == null) {
            throw new NullPointerException("A binding manager is required to wrap a command");
        }
        this.command = command;
        this.bindingManager = bindingManager;
    }

    @Override
    public final void addCommandListener(org.eclipse.ui.commands.ICommandListener iCommandListener) {
        this.command.addCommandListener((ICommandListener)new LegacyCommandListenerWrapper(iCommandListener, this.bindingManager));
    }

    @Override
    public final Object execute(Map map) throws ExecutionException, NotHandledException {
        try {
            return this.command.execute(new ExecutionEvent(this.command, map == null ? Collections.EMPTY_MAP : map, null, null));
        }
        catch (org.eclipse.core.commands.ExecutionException executionException) {
            throw new ExecutionException(executionException);
        }
        catch (org.eclipse.core.commands.NotHandledException notHandledException) {
            throw new NotHandledException(notHandledException);
        }
    }

    @Override
    public final Map getAttributeValuesByName() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("enabled", this.command.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put("handled", this.command.isHandled() ? Boolean.TRUE : Boolean.FALSE);
        return hashMap;
    }

    @Override
    public final String getCategoryId() throws NotDefinedException {
        try {
            return this.command.getCategory().getId();
        }
        catch (org.eclipse.core.commands.common.NotDefinedException notDefinedException) {
            throw new NotDefinedException(notDefinedException);
        }
    }

    @Override
    public final String getDescription() throws NotDefinedException {
        try {
            return this.command.getDescription();
        }
        catch (org.eclipse.core.commands.common.NotDefinedException notDefinedException) {
            throw new NotDefinedException(notDefinedException);
        }
    }

    @Override
    public final String getId() {
        return this.command.getId();
    }

    @Override
    public final List getKeySequenceBindings() {
        ArrayList<KeySequenceBinding> arrayList = new ArrayList<KeySequenceBinding>();
        if (this.parameterizedCommand == null) {
            this.parameterizedCommand = new ParameterizedCommand(this.command, null);
        }
        TriggerSequence[] triggerSequenceArray = this.bindingManager.getActiveBindingsFor(this.parameterizedCommand);
        int n = triggerSequenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            TriggerSequence triggerSequence = triggerSequenceArray[n2];
            if (triggerSequence instanceof KeySequence) {
                arrayList.add(new KeySequenceBinding(org.eclipse.ui.keys.KeySequence.getInstance((KeySequence)triggerSequence), 0));
            }
            ++n2;
        }
        return arrayList;
    }

    @Override
    public final String getName() throws NotDefinedException {
        try {
            return this.command.getName();
        }
        catch (org.eclipse.core.commands.common.NotDefinedException notDefinedException) {
            throw new NotDefinedException(notDefinedException);
        }
    }

    @Override
    public final boolean isDefined() {
        return this.command.isDefined();
    }

    @Override
    public final boolean isHandled() {
        return this.command.isHandled();
    }

    @Override
    public final void removeCommandListener(org.eclipse.ui.commands.ICommandListener iCommandListener) {
        this.command.removeCommandListener((ICommandListener)new LegacyCommandListenerWrapper(iCommandListener, this.bindingManager));
    }

    public final int compareTo(Object object) {
        return this.command.compareTo(object);
    }
}

