/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.commands.CommandImageManager;
import org.eclipse.ui.internal.services.RegistryPersistence;
import org.eclipse.ui.plugin.AbstractUIPlugin;

final class CommandImagePersistence
extends RegistryPersistence {
    private static final int INDEX_IMAGES = 0;
    private final CommandImageManager commandImageManager;
    private final ICommandService commandService;

    private static final void readImagesFromRegistry(IConfigurationElement[] iConfigurationElementArray, int n, CommandImageManager commandImageManager, ICommandService iCommandService) {
        commandImageManager.clear();
        ArrayList arrayList = new ArrayList(1);
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String string = CommandImagePersistence.readRequired(iConfigurationElement, "commandId", arrayList, "Image needs an id");
            if (string != null) {
                if (!iCommandService.getCommand(string).isDefined()) {
                    CommandImagePersistence.addWarning(arrayList, "Cannot bind to an undefined command", iConfigurationElement, string);
                } else {
                    String string2 = CommandImagePersistence.readOptional(iConfigurationElement, "style");
                    String string3 = CommandImagePersistence.readRequired(iConfigurationElement, "icon", arrayList, string);
                    if (string3 != null) {
                        ImageDescriptor imageDescriptor;
                        String string4 = CommandImagePersistence.readOptional(iConfigurationElement, "disabledIcon");
                        String string5 = CommandImagePersistence.readOptional(iConfigurationElement, "hoverIcon");
                        String string6 = iConfigurationElement.getNamespaceIdentifier();
                        ImageDescriptor imageDescriptor2 = AbstractUIPlugin.imageDescriptorFromPlugin(string6, string3);
                        commandImageManager.bind(string, 0, string2, imageDescriptor2);
                        if (string4 != null) {
                            imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(string6, string4);
                            commandImageManager.bind(string, 1, string2, imageDescriptor);
                        }
                        if (string5 != null) {
                            imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(string6, string5);
                            commandImageManager.bind(string, 2, string2, imageDescriptor);
                        }
                    }
                }
            }
            ++n2;
        }
        CommandImagePersistence.logWarnings(arrayList, "Warnings while parsing the images from the 'org.eclipse.ui.commandImages' extension point.");
    }

    CommandImagePersistence(CommandImageManager commandImageManager, ICommandService iCommandService) {
        this.commandImageManager = commandImageManager;
        this.commandService = iCommandService;
    }

    @Override
    protected final boolean isChangeImportant(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "commandImages");
        return iExtensionDeltaArray.length != 0;
    }

    @Override
    protected final void read() {
        super.read();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        int n = 0;
        IConfigurationElement[][] iConfigurationElementArrayArray = new IConfigurationElement[1][];
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.commandImages");
        int n2 = 0;
        while (n2 < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String string = iConfigurationElement.getName();
            if ("image".equals(string)) {
                CommandImagePersistence.addElementToIndexedArray(iConfigurationElement, iConfigurationElementArrayArray, 0, n++);
            }
            ++n2;
        }
        CommandImagePersistence.readImagesFromRegistry(iConfigurationElementArrayArray[0], n, this.commandImageManager, this.commandService);
    }
}

