/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import org.eclipse.ui.internal.commands.CommandImageManager;

public final class CommandImageManagerEvent {
    private final String[] changedCommandIds;
    private final CommandImageManager commandImageManager;
    private final String style;
    private final int type;

    CommandImageManagerEvent(CommandImageManager commandImageManager, String[] stringArray, int n, String string) {
        if (commandImageManager == null) {
            throw new NullPointerException("An event must refer to its manager");
        }
        if (stringArray == null || stringArray.length < 1) {
            throw new IllegalArgumentException("There must be at least one change command identifier");
        }
        this.commandImageManager = commandImageManager;
        this.changedCommandIds = stringArray;
        this.type = n;
        this.style = string;
    }

    public final String[] getChangedCommandIds() {
        String[] stringArray = new String[this.changedCommandIds.length];
        System.arraycopy(this.changedCommandIds, 0, stringArray, 0, this.changedCommandIds.length);
        return stringArray;
    }

    public final CommandImageManager getCommandImageManager() {
        return this.commandImageManager;
    }

    public final boolean isCommandIdChanged(String string) {
        int n = 0;
        while (n < this.changedCommandIds.length) {
            if (string.equals(this.changedCommandIds[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final boolean isCommandImageChanged(String string) {
        return this.isCommandIdChanged(string) && this.type == 0 && this.style == null;
    }

    public final boolean isCommandImageChanged(String string, int n) {
        return this.isCommandIdChanged(string) && (n == 0 || n == this.type) && this.style == null;
    }

    public final boolean isCommandImageChanged(String string, int n, String string2) {
        return !(!this.isCommandIdChanged(string) || n != 0 && n != this.type || string2 != null && !string2.equals(this.style));
    }

    public final boolean isCommandImageChanged(String string, String string2) {
        return this.isCommandIdChanged(string) && this.type == 0 && (string2 == null || string2.equals(this.style));
    }
}

