/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.commands.CommandImageManagerEvent;
import org.eclipse.ui.internal.commands.ICommandImageManagerListener;

public final class CommandImageManager
extends EventManager {
    public static final int TYPE_DEFAULT = 0;
    public static final int TYPE_DISABLED = 1;
    public static final int TYPE_HOVER = 2;
    private final Map imagesById = new HashMap();

    public final void addCommandImageManagerListener(ICommandImageManagerListener iCommandImageManagerListener) {
        this.addListenerObject(iCommandImageManagerListener);
    }

    public final void bind(String string, int n, String string2, URL uRL) {
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
        this.bind(string, n, string2, imageDescriptor);
    }

    public final void bind(String string, int n, String string2, ImageDescriptor imageDescriptor) {
        Object[] objectArray = (Object[])this.imagesById.get(string);
        if (objectArray == null) {
            objectArray = new Object[3];
            this.imagesById.put(string, objectArray);
        }
        if (n < 0 || n >= objectArray.length) {
            throw new IllegalArgumentException("The type must be one of TYPE_DEFAULT, TYPE_DISABLED and TYPE_HOVER.");
        }
        Object object = objectArray[n];
        if (string2 == null) {
            if (object == null || object instanceof ImageDescriptor) {
                objectArray[n] = imageDescriptor;
            } else if (object instanceof Map) {
                Map map = (Map)object;
                map.put(string2, imageDescriptor);
            }
        } else if (object instanceof Map) {
            Map map = (Map)object;
            map.put(string2, imageDescriptor);
        } else if (object instanceof ImageDescriptor || object == null) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(null, object);
            hashMap.put(string2, imageDescriptor);
            objectArray[n] = hashMap;
        }
        this.fireManagerChanged(new CommandImageManagerEvent(this, new String[]{string}, n, string2));
    }

    public final void clear() {
        this.imagesById.clear();
        if (this.isListenerAttached()) {
            String[] stringArray = this.imagesById.keySet().toArray(new String[this.imagesById.size()]);
            this.fireManagerChanged(new CommandImageManagerEvent(this, stringArray, 0, null));
        }
    }

    private final void fireManagerChanged(CommandImageManagerEvent commandImageManagerEvent) {
        if (commandImageManagerEvent == null) {
            throw new NullPointerException();
        }
        Object[] objectArray = this.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ICommandImageManagerListener iCommandImageManagerListener = (ICommandImageManagerListener)objectArray[n];
            iCommandImageManagerListener.commandImageManagerChanged(commandImageManagerEvent);
            ++n;
        }
    }

    public final String generateUnusedStyle(String string) {
        Object[] objectArray = (Object[])this.imagesById.get(string);
        if (objectArray == null) {
            return null;
        }
        HashSet hashSet = new HashSet(3);
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof ImageDescriptor) {
                hashSet.add(null);
            } else if (object instanceof Map) {
                Map map = (Map)object;
                hashSet.addAll(map.keySet());
            }
            ++n;
        }
        if (!hashSet.contains(null)) {
            return null;
        }
        String string2 = "AUTOGEN:::";
        int n2 = 0;
        while (hashSet.contains(string2)) {
            string2 = String.valueOf(string2) + n2++ % 10;
        }
        return string2;
    }

    public final ImageDescriptor getImageDescriptor(String string) {
        return this.getImageDescriptor(string, 0, null);
    }

    public final ImageDescriptor getImageDescriptor(String string, int n) {
        return this.getImageDescriptor(string, n, null);
    }

    public final ImageDescriptor getImageDescriptor(String string, int n, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        Object[] objectArray = (Object[])this.imagesById.get(string);
        if (objectArray == null) {
            return null;
        }
        if (n < 0 || n >= objectArray.length) {
            throw new IllegalArgumentException("The type must be one of TYPE_DEFAULT, TYPE_DISABLED and TYPE_HOVER.");
        }
        Object object = objectArray[n];
        if (object == null) {
            return null;
        }
        if (object instanceof ImageDescriptor) {
            return (ImageDescriptor)object;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Object v = map.get(string2);
            if (v instanceof ImageDescriptor) {
                return (ImageDescriptor)v;
            }
            if (string2 != null && (v = map.get(null)) instanceof ImageDescriptor) {
                return (ImageDescriptor)v;
            }
        }
        return null;
    }

    public final ImageDescriptor getImageDescriptor(String string, String string2) {
        return this.getImageDescriptor(string, 0, string2);
    }

    public final void removeCommandImageManagerListener(ICommandImageManagerListener iCommandImageManagerListener) {
        this.removeListenerObject(iCommandImageManagerListener);
    }
}

