/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.AbstractWorkbenchBrowserSupport;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.browser.DefaultWorkbenchBrowserSupport;

public class WorkbenchBrowserSupport
extends AbstractWorkbenchBrowserSupport {
    private static WorkbenchBrowserSupport instance;
    private IWorkbenchBrowserSupport activeSupport;
    private boolean initialized;
    private String desiredBrowserSupportId;
    private IExtensionChangeHandler handler = new IExtensionChangeHandler(){

        public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        }

        public void removeExtension(IExtension iExtension, Object[] objectArray) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] == WorkbenchBrowserSupport.this.activeSupport) {
                    WorkbenchBrowserSupport.this.dispose();
                    PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler(WorkbenchBrowserSupport.this.handler);
                }
                ++n;
            }
        }
    };

    private WorkbenchBrowserSupport() {
    }

    public static IWorkbenchBrowserSupport getInstance() {
        if (instance == null) {
            instance = new WorkbenchBrowserSupport();
        }
        return instance;
    }

    @Override
    public IWebBrowser createBrowser(int n, String string, String string2, String string3) throws PartInitException {
        return this.getActiveSupport().createBrowser(n, string, string2, string3);
    }

    @Override
    public IWebBrowser createBrowser(String string) throws PartInitException {
        return this.getActiveSupport().createBrowser(string);
    }

    @Override
    public boolean isInternalWebBrowserAvailable() {
        return this.getActiveSupport().isInternalWebBrowserAvailable();
    }

    private IWorkbenchBrowserSupport getActiveSupport() {
        if (!this.initialized) {
            this.loadActiveSupport();
        }
        if (this.activeSupport == null) {
            this.activeSupport = new DefaultWorkbenchBrowserSupport();
        }
        return this.activeSupport;
    }

    public boolean hasNonDefaultBrowser() {
        return !(this.getActiveSupport() instanceof DefaultWorkbenchBrowserSupport);
    }

    private void loadActiveSupport() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui", "browserSupport");
                IConfigurationElement iConfigurationElement = null;
                iConfigurationElement = WorkbenchBrowserSupport.this.desiredBrowserSupportId != null ? this.findDesiredElement(iConfigurationElementArray) : this.getElementToUse(iConfigurationElementArray);
                if (iConfigurationElement != null) {
                    WorkbenchBrowserSupport.this.initialized = this.initializePluggableBrowserSupport(iConfigurationElement);
                }
            }

            private IConfigurationElement findDesiredElement(IConfigurationElement[] iConfigurationElementArray) {
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    if (WorkbenchBrowserSupport.this.desiredBrowserSupportId.equals(iConfigurationElementArray[n].getDeclaringExtension().getUniqueIdentifier())) {
                        return iConfigurationElementArray[n];
                    }
                    ++n;
                }
                return null;
            }

            private IExtensionPoint getExtensionPoint() {
                return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "browserSupport");
            }

            private IConfigurationElement getElementToUse(IConfigurationElement[] iConfigurationElementArray) {
                if (iConfigurationElementArray.length == 0) {
                    return null;
                }
                IConfigurationElement iConfigurationElement = null;
                IConfigurationElement iConfigurationElement2 = null;
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement3 = iConfigurationElementArray[n];
                    if (iConfigurationElement3.getName().equals("support")) {
                        String string = iConfigurationElement3.getAttribute("default");
                        if (string != null && Boolean.valueOf(string).booleanValue()) {
                            if (iConfigurationElement == null) {
                                iConfigurationElement = iConfigurationElement3;
                            }
                        } else if (iConfigurationElement2 == null) {
                            iConfigurationElement2 = iConfigurationElement3;
                        }
                    }
                    ++n;
                }
                if (iConfigurationElement2 == null) {
                    iConfigurationElement2 = iConfigurationElement;
                }
                return iConfigurationElement2;
            }

            private boolean initializePluggableBrowserSupport(IConfigurationElement iConfigurationElement) {
                try {
                    WorkbenchBrowserSupport.this.activeSupport = (AbstractWorkbenchBrowserSupport)WorkbenchPlugin.createExtension(iConfigurationElement, "class");
                    IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
                    iExtensionTracker.registerHandler(WorkbenchBrowserSupport.this.handler, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPoint()));
                    iExtensionTracker.registerObject(iConfigurationElement.getDeclaringExtension(), (Object)WorkbenchBrowserSupport.this.activeSupport, 2);
                    return true;
                }
                catch (CoreException coreException) {
                    WorkbenchPlugin.log("Unable to instantiate browser support" + coreException.getStatus(), coreException);
                    return false;
                }
            }
        });
    }

    public void setDesiredBrowserSupportId(String string) {
        this.dispose();
        this.desiredBrowserSupportId = string;
    }

    protected void dispose() {
        this.activeSupport = null;
        this.initialized = false;
    }
}

