/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.util.Hashtable;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.AbstractWorkbenchBrowserSupport;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.DefaultWebBrowser;

public class DefaultWorkbenchBrowserSupport
extends AbstractWorkbenchBrowserSupport {
    private Hashtable browsers = new Hashtable();
    private static final String DEFAULT_BROWSER_ID_BASE = "org.eclipse.ui.defaultBrowser";

    void registerBrowser(IWebBrowser iWebBrowser) {
        this.browsers.put(iWebBrowser.getId(), iWebBrowser);
    }

    void unregisterBrowser(IWebBrowser iWebBrowser) {
        this.browsers.remove(iWebBrowser.getId());
    }

    IWebBrowser findBrowser(String string) {
        return (IWebBrowser)this.browsers.get(string);
    }

    protected IWebBrowser doCreateBrowser(int n, String string, String string2, String string3) throws PartInitException {
        return new DefaultWebBrowser(this, string);
    }

    @Override
    public IWebBrowser createBrowser(int n, String string, String string2, String string3) throws PartInitException {
        String string4 = string == null ? this.getDefaultId() : string;
        IWebBrowser iWebBrowser = this.findBrowser(string4);
        if (iWebBrowser != null) {
            return iWebBrowser;
        }
        iWebBrowser = this.doCreateBrowser(n, string4, string2, string3);
        this.registerBrowser(iWebBrowser);
        return iWebBrowser;
    }

    @Override
    public IWebBrowser createBrowser(String string) throws PartInitException {
        return this.createBrowser(128, string, null, null);
    }

    private String getDefaultId() {
        String string = null;
        int n = 0;
        while (n < Integer.MAX_VALUE) {
            string = DEFAULT_BROWSER_ID_BASE + n;
            if (this.browsers.get(string) == null) break;
            ++n;
        }
        return string;
    }
}

