/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.io.IOException;
import java.net.URL;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.AbstractWebBrowser;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.browser.DefaultWorkbenchBrowserSupport;

public class DefaultWebBrowser
extends AbstractWebBrowser {
    private DefaultWorkbenchBrowserSupport support;
    private String webBrowser;
    private boolean webBrowserOpened;

    public DefaultWebBrowser(DefaultWorkbenchBrowserSupport defaultWorkbenchBrowserSupport, String string) {
        super(string);
        this.support = defaultWorkbenchBrowserSupport;
    }

    @Override
    public void openURL(URL uRL) throws PartInitException {
        String string = uRL.toString();
        if (string.startsWith("file:")) {
            string = string.substring(5);
            while (string.startsWith("/")) {
                string = string.substring(1);
            }
            string = "file:///" + string;
        }
        final String string2 = string;
        final Display display = Display.getCurrent();
        if (!Program.launch((String)string2)) {
            Thread thread = new Thread("About Link Launcher"){

                @Override
                public void run() {
                    block9: {
                        try {
                            String string = DefaultWebBrowser.this.urlEncodeForSpaces(string2.toCharArray());
                            if (DefaultWebBrowser.this.webBrowserOpened) {
                                Runtime.getRuntime().exec(String.valueOf(DefaultWebBrowser.this.webBrowser) + " -remote openURL(" + string + ")");
                                break block9;
                            }
                            Process process = DefaultWebBrowser.this.openWebBrowser(string);
                            DefaultWebBrowser.this.webBrowserOpened = true;
                            try {
                                try {
                                    if (process != null) {
                                        process.waitFor();
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    DefaultWebBrowser.this.openWebBrowserError(display);
                                    DefaultWebBrowser.this.webBrowserOpened = false;
                                }
                            }
                            finally {
                                DefaultWebBrowser.this.webBrowserOpened = false;
                            }
                        }
                        catch (IOException iOException) {
                            DefaultWebBrowser.this.openWebBrowserError(display);
                        }
                    }
                }
            };
            thread.start();
        }
    }

    @Override
    public boolean close() {
        this.support.unregisterBrowser(this);
        return super.close();
    }

    private String urlEncodeForSpaces(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == ' ') {
                stringBuffer.append("%20");
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private Process openWebBrowser(String string) throws IOException {
        Process process = null;
        if (this.webBrowser == null) {
            try {
                this.webBrowser = "firefox";
                process = Runtime.getRuntime().exec(String.valueOf(this.webBrowser) + "  " + string);
            }
            catch (IOException iOException) {
                process = null;
                this.webBrowser = "mozilla";
            }
        }
        if (process == null) {
            try {
                process = Runtime.getRuntime().exec(String.valueOf(this.webBrowser) + " " + string);
            }
            catch (IOException iOException) {
                process = null;
                this.webBrowser = "netscape";
            }
        }
        if (process == null) {
            try {
                process = Runtime.getRuntime().exec(String.valueOf(this.webBrowser) + " " + string);
            }
            catch (IOException iOException) {
                process = null;
                throw iOException;
            }
        }
        return process;
    }

    private void openWebBrowserError(Display display) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError(null, (String)WorkbenchMessages.ProductInfoDialog_errorTitle, (String)WorkbenchMessages.ProductInfoDialog_unableToOpenWebBrowser);
            }
        });
    }
}

