/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.IMutableActivityManager;
import org.eclipse.ui.activities.ITriggerPointAdvisor;
import org.eclipse.ui.activities.ITriggerPointManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchTriggerPointAdvisor;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.activities.MutableActivityManager;
import org.eclipse.ui.internal.activities.ProxyActivityManager;
import org.eclipse.ui.internal.activities.ws.ActivityMessages;
import org.eclipse.ui.internal.activities.ws.ImageBindingRegistry;
import org.eclipse.ui.internal.activities.ws.TriggerPointAdvisorDescriptor;
import org.eclipse.ui.internal.activities.ws.TriggerPointAdvisorRegistry;
import org.eclipse.ui.internal.activities.ws.TriggerPointManager;
import org.eclipse.ui.internal.misc.StatusUtil;

public class WorkbenchActivitySupport
implements IWorkbenchActivitySupport,
IExtensionChangeHandler {
    private MutableActivityManager mutableActivityManager;
    private ProxyActivityManager proxyActivityManager;
    private ImageBindingRegistry activityImageBindingRegistry;
    private ImageBindingRegistry categoryImageBindingRegistry;
    private ITriggerPointManager triggerPointManager = new TriggerPointManager();
    private ITriggerPointAdvisor advisor;

    public WorkbenchActivitySupport() {
        IExtensionTracker iExtensionTracker = PlatformUI.getWorkbench().getExtensionTracker();
        iExtensionTracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getActivitySupportExtensionPoint()));
        this.mutableActivityManager = new MutableActivityManager(this.getTriggerPointAdvisor());
        this.proxyActivityManager = new ProxyActivityManager(this.mutableActivityManager);
        this.mutableActivityManager.addActivityManagerListener(new IActivityManagerListener(){
            private Set lastEnabled;
            {
                this.lastEnabled = new HashSet(WorkbenchActivitySupport.this.mutableActivityManager.getEnabledActivityIds());
            }

            @Override
            public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
                Set set = WorkbenchActivitySupport.this.mutableActivityManager.getEnabledActivityIds();
                if (!set.equals(this.lastEnabled)) {
                    this.lastEnabled = new HashSet(set);
                    if (!PlatformUI.isWorkbenchRunning()) {
                        return;
                    }
                    final IWorkbench iWorkbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
                    int n = 0;
                    while (n < iWorkbenchWindowArray.length) {
                        if (iWorkbenchWindowArray[n] instanceof WorkbenchWindow) {
                            final WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindowArray[n];
                            final ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(workbenchWindow.getShell());
                            final IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){
                                private long openTime;
                                private boolean dialogOpened = false;

                                public void run(IProgressMonitor iProgressMonitor) {
                                    this.openTime = System.currentTimeMillis() + (long)iWorkbench.getProgressService().getLongOperationTime();
                                    iProgressMonitor.beginTask(ActivityMessages.ManagerTask, 2);
                                    iProgressMonitor.subTask(ActivityMessages.ManagerWindowSubTask);
                                    this.updateWindowBars(workbenchWindow);
                                    iProgressMonitor.worked(1);
                                    iProgressMonitor.subTask(ActivityMessages.ManagerViewsSubTask);
                                    IWorkbenchPage[] iWorkbenchPageArray = workbenchWindow.getPages();
                                    int n = 0;
                                    while (n < iWorkbenchPageArray.length) {
                                        IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray[n];
                                        IViewReference[] iViewReferenceArray = iWorkbenchPage.getViewReferences();
                                        int n2 = 0;
                                        while (n2 < iViewReferenceArray.length) {
                                            IViewPart iViewPart = iViewReferenceArray[n2].getView(false);
                                            if (iViewPart != null) {
                                                this.updateViewBars(iViewPart);
                                            }
                                            ++n2;
                                        }
                                        ++n;
                                    }
                                    iProgressMonitor.worked(1);
                                    iProgressMonitor.done();
                                }

                                private void updateViewBars(IViewPart iViewPart) {
                                    IViewSite iViewSite = iViewPart.getViewSite();
                                    if (iViewSite == null) {
                                        return;
                                    }
                                    IActionBars iActionBars = iViewSite.getActionBars();
                                    IMenuManager iMenuManager = iActionBars.getMenuManager();
                                    if (iMenuManager != null) {
                                        this.updateManager((IContributionManager)iMenuManager);
                                    }
                                    if ((iMenuManager = iActionBars.getToolBarManager()) != null) {
                                        this.updateManager((IContributionManager)iMenuManager);
                                    }
                                    if ((iMenuManager = iActionBars.getStatusLineManager()) != null) {
                                        this.updateManager((IContributionManager)iMenuManager);
                                    }
                                }

                                private void updateWindowBars(WorkbenchWindow workbenchWindow2) {
                                    MenuManager menuManager = workbenchWindow2.getMenuBarManager();
                                    if (menuManager != null) {
                                        this.updateManager((IContributionManager)menuManager);
                                    }
                                    if ((menuManager = workbenchWindow2.getCoolBarManager2()) != null) {
                                        this.updateManager((IContributionManager)menuManager);
                                    }
                                    if ((menuManager = workbenchWindow2.getToolBarManager2()) != null) {
                                        this.updateManager((IContributionManager)menuManager);
                                    }
                                    if ((menuManager = workbenchWindow2.getStatusLineManager()) != null) {
                                        this.updateManager((IContributionManager)menuManager);
                                    }
                                }

                                private void updateManager(IContributionManager iContributionManager) {
                                    if (!this.dialogOpened && System.currentTimeMillis() > this.openTime) {
                                        progressMonitorDialog.open();
                                        this.dialogOpened = true;
                                    }
                                    iContributionManager.update(true);
                                }
                            };
                            progressMonitorDialog.setOpenOnRun(false);
                            iWorkbench.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    BusyIndicator.showWhile((Display)iWorkbench.getDisplay(), (Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                progressMonitorDialog.run(false, false, iRunnableWithProgress);
                                            }
                                            catch (InvocationTargetException invocationTargetException) {
                                                this.log(invocationTargetException);
                                            }
                                            catch (InterruptedException interruptedException) {
                                                this.log(interruptedException);
                                            }
                                        }
                                    });
                                }
                            });
                        }
                        ++n;
                    }
                }
            }

            private void log(Exception exception) {
                StatusUtil.newStatus(4, "Could not update contribution managers", (Throwable)exception);
            }
        });
    }

    @Override
    public IActivityManager getActivityManager() {
        return this.proxyActivityManager;
    }

    @Override
    public void setEnabledActivityIds(Set set) {
        this.mutableActivityManager.setEnabledActivityIds(set);
    }

    @Override
    public ImageDescriptor getImageDescriptor(IActivity iActivity) {
        ImageDescriptor imageDescriptor;
        if (iActivity.isDefined() && (imageDescriptor = this.getActivityImageBindingRegistry().getImageDescriptor(iActivity.getId())) != null) {
            return imageDescriptor;
        }
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_ACTIVITY");
    }

    @Override
    public ImageDescriptor getImageDescriptor(ICategory iCategory) {
        ImageDescriptor imageDescriptor;
        if (iCategory.isDefined() && (imageDescriptor = this.getCategoryImageBindingRegistry().getImageDescriptor(iCategory.getId())) != null) {
            return imageDescriptor;
        }
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_ACTIVITY_CATEGORY");
    }

    private ImageBindingRegistry getActivityImageBindingRegistry() {
        if (this.activityImageBindingRegistry == null) {
            this.activityImageBindingRegistry = new ImageBindingRegistry("activityImageBinding");
            PlatformUI.getWorkbench().getExtensionTracker().registerHandler((IExtensionChangeHandler)this.activityImageBindingRegistry, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getActivitySupportExtensionPoint()));
        }
        return this.activityImageBindingRegistry;
    }

    private ImageBindingRegistry getCategoryImageBindingRegistry() {
        if (this.categoryImageBindingRegistry == null) {
            this.categoryImageBindingRegistry = new ImageBindingRegistry("categoryImageBinding");
            PlatformUI.getWorkbench().getExtensionTracker().registerHandler((IExtensionChangeHandler)this.categoryImageBindingRegistry, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getActivitySupportExtensionPoint()));
        }
        return this.categoryImageBindingRegistry;
    }

    public void dispose() {
        if (this.activityImageBindingRegistry != null) {
            this.activityImageBindingRegistry.dispose();
            PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this.activityImageBindingRegistry);
        }
        if (this.categoryImageBindingRegistry != null) {
            this.categoryImageBindingRegistry.dispose();
            PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this.categoryImageBindingRegistry);
        }
        PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this);
    }

    public ITriggerPointAdvisor getTriggerPointAdvisor() {
        TriggerPointAdvisorDescriptor triggerPointAdvisorDescriptor;
        if (this.advisor != null) {
            return this.advisor;
        }
        IProduct iProduct = Platform.getProduct();
        if (iProduct != null && (triggerPointAdvisorDescriptor = TriggerPointAdvisorRegistry.getInstance().getAdvisorForProduct(iProduct.getId())) != null) {
            try {
                this.advisor = triggerPointAdvisorDescriptor.createAdvisor();
            }
            catch (CoreException coreException) {
                WorkbenchPlugin.log("could not create trigger point advisor", coreException);
            }
        }
        if (this.advisor == null) {
            this.advisor = new WorkbenchTriggerPointAdvisor();
        }
        return this.advisor;
    }

    @Override
    public ITriggerPointManager getTriggerPointManager() {
        return this.triggerPointManager;
    }

    public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        if (this.advisor != null && this.advisor.getClass().equals(WorkbenchTriggerPointAdvisor.class)) {
            this.advisor = null;
        }
    }

    private IExtensionPoint getActivitySupportExtensionPoint() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "activitySupport");
    }

    public void removeExtension(IExtension iExtension, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == this.advisor) {
                this.advisor = null;
                break;
            }
            ++n;
        }
    }

    @Override
    public IMutableActivityManager createWorkingCopy() {
        MutableActivityManager mutableActivityManager = (MutableActivityManager)this.mutableActivityManager.clone();
        mutableActivityManager.unhookRegistryListeners();
        return mutableActivityManager;
    }
}

